<?php

namespace App\Events;

use App\Models\SavingsTransaction;
use Illuminate\Broadcasting\Channel;
use Illuminate\Queue\SerializesModels;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;

class TransactionCreated implements ShouldBroadcast
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    public $transaction;
    public $customerId;

    public function __construct(SavingsTransaction $transaction)
    {
        $this->transaction = $transaction;
        $this->customerId  = $transaction->customer_id;
    }

    // The WebSocket channel name
    public function broadcastOn()
    {
        return new PrivateChannel('transactions.' . $this->customerId);
    }

    // The event name on the frontend
    public function broadcastAs()
    {
        return 'TransactionCreated';
    }
}
