<?php

namespace App\Exports;

use App\Models\TargetSavings;
use Illuminate\Contracts\Support\Responsable;
use Maatwebsite\Excel\Concerns\FromQuery;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\Exportable;

class TargetSavingsExport implements FromQuery, WithHeadings, WithMapping, ShouldAutoSize, Responsable
{
    use Exportable;

    public string $fileName;
    protected ?string $q;

    public function __construct(?string $q = null)
    {
        $this->q = $q ? trim($q) : null;
        $this->fileName = 'target_savings_' . now()->format('Ymd_His') . '.xlsx';
    }

    public function query()
    {
        $query = TargetSavings::with('customer')->latest();

        if ($this->q !== null && $this->q !== '') {
            $q = $this->q;
            $query->where(function ($qb) use ($q) {
                $qb->where('code', 'like', "%{$q}%")
                   ->orWhere('account_number', 'like', "%{$q}%")
                   ->orWhere('frequency', 'like', "%{$q}%")
                   ->orWhere('status', 'like', "%{$q}%")
                   ->orWhere('target_amount', 'like', "%{$q}%")
                   ->orWhere('auto_save_amount', 'like', "%{$q}%")
                   ->orWhereHas('customer', function ($qc) use ($q) {
                       $qc->where('first_name', 'like', "%{$q}%")
                          ->orWhere('last_name', 'like', "%{$q}%")
                          ->orWhereRaw("CONCAT(first_name,' ',last_name) LIKE ?", ["%{$q}%"]);
                   });
            });
        }

        return $query;
    }

    public function headings(): array
    {
        return [
            'ID', 'Code', 'Customer Name', 'Account Number',
            'Target Amount', 'Save Now Amount', 'Target Name',
            'Frequency', 'Start Date', 'Status',
        ];
    }

    public function map($t): array
    {
        $customerName = trim(optional($t->customer)->first_name . ' ' . optional($t->customer)->last_name);

        return [
            $t->id,
            $t->code,
            $customerName,
            $t->account_number,
            number_format((float) $t->target_amount, 2, '.', ''),
            number_format((float) $t->auto_save_amount, 2, '.', ''),
            $t->savings_plan_name,
            $t->frequency,
            (string) $t->auto_save_start_date,
            $t->status,
        ];
    }
}
