<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromArray;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Events\AfterSheet;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;

class TrialBalanceExport implements FromArray, WithEvents, ShouldAutoSize
{
    protected $rows;
    protected $companyName;

    public function __construct(array $rows, string $companyName = '')
    {
        $this->rows = $rows;
        $this->companyName = $companyName;
    }

    public function array(): array
    {
        return $this->rows;
    }

    public function registerEvents(): array
    {
        return [
            AfterSheet::class => function(AfterSheet $event) {
                $sheet = $event->sheet->getDelegate();

                // --- Merges to mimic sample header layout
                $sheet->mergeCells('A1:E1'); // company name
                $sheet->mergeCells('A2:E2'); // report title
                $sheet->mergeCells('A3:C3'); // As at left
                $sheet->mergeCells('D3:E3'); // Generated on right

                // Header row styling
                $sheet->getStyle('A1:E2')->getFont()->setBold(true)->setSize(14);
                $sheet->getStyle('A3:E3')->getFont()->setBold(true)->setSize(10);

                // Column header row (we place it at row 4 in rows array later) - style bold
                $headerRowIndex = 4;
                $sheet->getStyle("A{$headerRowIndex}:E{$headerRowIndex}")->getFont()->setBold(true);
                $sheet->getStyle("A{$headerRowIndex}:E{$headerRowIndex}")->getFill()
                    ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
                    ->getStartColor()->setARGB('FFF2F2F2');

                // Apply thin borders around the used range
                $highestRow = $sheet->getHighestRow();
                $sheet->getStyle("A1:E{$highestRow}")->getBorders()->getAllBorders()->setBorderStyle(\PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN);

                // Align columns: Debit & Credit right
                $sheet->getStyle("D1:D{$highestRow}")->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
                $sheet->getStyle("E1:E{$highestRow}")->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);

                // Number format for Debit and Credit columns (D & E)
                $sheet->getStyle("D5:E{$highestRow}")->getNumberFormat()->setFormatCode('#,##0.00');

                // Optional: set widths (auto-size is active via ShouldAutoSize, but prefer explicit widths)
                $sheet->getColumnDimension('A')->setWidth(12);
                $sheet->getColumnDimension('B')->setWidth(50);
                $sheet->getColumnDimension('C')->setWidth(15);
                $sheet->getColumnDimension('D')->setWidth(18);
                $sheet->getColumnDimension('E')->setWidth(18);
            }
        ];
    }
}
