<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Traites\AuditTraite;
use App\Http\Traites\SavingTraite;
use App\Http\Traites\TransferTraite;
use App\Http\Traites\UserTraite;
use App\Models\Bank;
use App\Models\Customer;
use App\Models\CustomerRestriction;
use App\Models\Email;
use App\Models\GeneralLedger;
use App\Models\Saving;
use App\Models\SavingsTransaction;
use App\Models\Setting;
use Carbon\Carbon;
use Exception;
use Illuminate\Contracts\Cache\LockTimeoutException;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Validator;

class NibbsController extends Controller
{

    use SavingTraite;
    use AuditTraite;
    use UserTraite;
    use TransferTraite;

    /*
    3. Nibss Unlien customer account
    4. Nibss Lien customer account
    5. Nibss Block customer account
    */
    public function blockUserAccount(Request $request)
    {

        $this->logInfo("blockUser Account request log", $request->all());

        $validator = Validator::make($request->all(), [
            'accountName' => 'required|string',
            'accountNumber' => 'required|numeric|digits:10',
            'sessionId' => 'required|string',
            "narration" => "required|string",
            'transactionRef' => 'required|string'
        ]);

        if ($validator->fails()) {
            return response()->json(['status' => "57", 'message' => $validator->errors()->all()[0]]);
        }

        $sessionValidationResult = $this->verifySessionID($request->sessionId);

        if ($sessionValidationResult['status'] != "00") {
            return response()->json($sessionValidationResult, 200);
        }

        $narrationResult = $this->validateNarration($request->narration);

        if ($narrationResult['status'] != "00") {
            return response()->json($narrationResult, 200);
        }

        $custAccunt = Customer::where('acctno', $request->accountNumber)->first();

        if ($custAccunt) {

            $cname = $custAccunt->last_name." ".$custAccunt->first_name;

            $restrictUserAccount = $this->CustomerRestrictionNibssLog($custAccunt->id,$cname,$request->accountNumber,null,$request->transactionRef,$request->sessionId,"NIBSS Block Account request -".$request->narration,5,null);

            $this->Nibsslog($custAccunt->id,$cname,$custAccunt->acctno,null,$request->transactionRef,$request->sessionId,$request->narration,'NIBSS Account Block',null);

            $this->tracktrails('1','1',$cname,'customer',"NIBSS Block Account request -".$request->narration);

            if($restrictUserAccount == true){

                return response()->json(['status' => '00','message' => 'Customer Account Block successfully']);

            }else{
                return response()->json(['status' => '70','message' => $restrictUserAccount['message']]);

            }

        } else {

            return response(['status' => "70", 'message' => 'Invalid customer Account number']);

        }
    }

    public function unblockUserAccount(Request $request)
    {
        $this->logInfo("unblockUser Account request log", $request->all());

        $validator = Validator::make($request->all(), [
            'accountName' => 'required|string',
            'accountNumber' => 'required|numeric|digits:10',
            'sessionId' => 'required|string',
            "narration" => "required|string",
            'transactionRef' => 'required|string'
        ]);

        if ($validator->fails()) {
            return response()->json(['status' => "70", "message" => $validator->errors()->all()[0]]);
        }

        $sessionValidationResult = $this->verifySessionID($request->sessionId);

        if ($sessionValidationResult['status'] != "00") {
            return response()->json($sessionValidationResult, 200);
        }

        $narrationResult = $this->validateNarration($request->narration);

        if ($narrationResult['status'] != "00") {
            return response()->json($narrationResult, 200);
        }

        $custAccunt = Customer::where('acctno', $request->accountNumber)->first();

        if ($custAccunt) {

            $cname = $custAccunt->last_name." ".$custAccunt->first_name;


            $restrictUserAccount = $this->RemoveCustomerRestrictionNibssLog($custAccunt->id,5,$request->transactionRef,null);

            $this->Nibsslog($custAccunt->id,$cname,$custAccunt->acctno,null,$request->transactionRef,$request->sessionId,$request->narration,'NIBSS Unblock Account',null);

                if($restrictUserAccount["status"] == false){
                     return response()->json(['status' => "70", 'message' => $restrictUserAccount['message']]);
                }

                $this->tracktrails('1','1',$cname,'customer',"NIBSS Unblock Account request -".$request->narration);


            return response()->json(['status' => '00','message' => 'Customer restriction removed successfully']);

        } else {

            return response()->json(['status' => "70", 'message' => 'Invalid Customer Account number']);
        }
    }

    public function getAccountBalance(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'accountName' => 'required|string',
            'accountNumber' => 'required|numeric|digits:10',
            'sessionId' => 'required|string',
            "authorizationCode" => "required|string"
        ]);

        if ($validator->fails()) {
            return \response()->json(['status' => "70", "message" => $validator->errors()->all()[0]]);
        }

        $this->logInfo("NIBSS get Account balance log", $request->accountNumber);

        $userAccount = Customer::select('id','last_name','first_name','acctno')->where('acctno', $request->accountNumber)->first();

        if ($userAccount) {

            $balance = Saving::select('account_balance')->where('customer_id',$userAccount->id)->first();

            return \response()->json([
                'status' => "00",
                'message' => "Successful, balance enquiry returned",
                'data' => [
                    "accountName" => $userAccount->first_name." ".$userAccount->last_name,
                    "accountNumber" => $userAccount->acctno,
                    "availableBalance" => $balance->account_balance < 0 ? "0.00" : $balance->account_balance
                ]
            ]);
        } else {
            return response(['status' => "70", 'message' => 'Invalid Customer Account number']);
        }
    }

    public function lookupAccount($account_number)
    {
        $this->logInfo("NIBSS account lookup",$account_number);

        $lock = Cache::lock('customeracctlookup',3);

        try {

            $lock->block(5);


            if (!is_numeric($account_number)) {
                return response()->json(['status' => "70", 'message' =>'Account number must be numeric'],406);
            }

            if (strlen($account_number) > 10 || strlen($account_number) < 10) {
                return response()->json(['status' => "70", 'message' =>'invalid account number Lenght'],406);
            }

        $userAccount = Customer::where('acctno',$account_number)->first();

        if ($userAccount) {

            $name = !is_null($userAccount->business_name) ? $userAccount->business_name : $userAccount->first_name." ".$userAccount->last_name;

            return \response()->json([
                'status' => "00",
                'message' => "Account verified successfully",
                'data' => [
                    "accountName" => $name,
                    "accountNumber" => $userAccount->acctno,
                    "bvn" => $userAccount->bvn,
                    "kycLevel" => 1
                ]
            ]);
        }else{
          return \response()->json([
                'status' => "70",
                'message' => "Invalid Account Number",
                'data' => [
                    "accountName" => " ",
                    "accountNumber" => "",
                    "bvn" => "",
                    "kycLevel" => 0
                ]
            ]);
       }

    } catch (LockTimeoutException $e) {

        $this->logInfo("DB accoutn lookup Error", $e->getMessage());

        return response()->json(['status' => "70", 'message' => 'Failed to validate Account'], 406);

    } finally {
        optional($lock)->release();
    }

    }

    public function lienAccount(Request $request)
    {
        $this->logInfo("NIBSS lien Account log",$request->all());

        $validator = Validator::make($request->all(), [
            'accountName' => 'required|string',
            'accountNumber' => 'required|numeric|digits:10',
            'amount' => 'required|numeric|gt:0',
            "narration" => "required|string",
            "sessionId" => "required|string",
            'transactionRef' => 'required|string'
        ]);


        $lock = Cache::lock('liencustomeracct',3);

        try {

            $lock->block(1);

            $sessionValidationResult = $this->verifySessionID($request->sessionId);

        if ($sessionValidationResult['status'] != "00") {
            return response()->json($sessionValidationResult, 200);
        }

        $narrationResult = $this->validateNarration($request->narration);

        if ($narrationResult['status'] != "00") {
            return response()->json($narrationResult, 200);
        }

        $custCheck = Customer::where('acctno', $request->accountNumber)->first();

        if (!$custCheck) {
            return response()->json(['status' => "70", 'message' => 'Invalid Account provided']);
        }

        $lienCheck = CustomerRestriction::where('reference_no', $request->transactionRef)->orWhere('session_id',$request->transactionRef)->first();

        if ($lienCheck) {
            return response()->json(['status' => "69", 'message' => 'Unsuccessful, account/amount block']);
        }

        $cname = $custCheck->last_name." ".$custCheck->first_name;

            $userWallet = Saving::lockForUpdate()->where('customer_id', $custCheck->id)->first();

            $this->logInfo("Customer wallet log",$custCheck);

            if ($userWallet) {

                $amountPaid = 0;
                $amountRemaining = 0;

                if ($userWallet->account_balance >= $request->amount) {

                    $amountPaid = $request->amount;

                    $reamount = $userWallet->account_balance - $request->amount;
                    $userWallet->account_balance = $reamount;

                    $reqamount = $userWallet->lien_amount + $request->amount;
                    $userWallet->lien_amount = $reqamount;

                    $ramount = $userWallet->lien_deducted + $request->amount;
                    $userWallet->lien_deducted = $ramount;

                     $userWallet->save();


                     $this->tracktrails('1','1',$cname,'customer',"NIBSS Lien Account With Amount -".number_format($request->amount,2));

                } else {

                    $amountPaid = $userWallet->account_balance;
                    $amountRemaining = $request->amount - $userWallet->account_balance;
                    $userWallet->account_balance = $amountRemaining;

                    $requamount = $userWallet->lien_amount + $request->amount;
                    $userWallet->lien_amount = $requamount;

                    $amtPaid = $userWallet->lien_deducted + $amountPaid;
                    $userWallet->lien_deducted = $amtPaid;

                    $userWallet->lien_remaining + $amountRemaining;
                    $userWallet->lien_remaining = $amountRemaining;

                    $userWallet->save();

                    $this->tracktrails('1','1',$cname,'customer',"NIBSS Lien Account With Amount -".number_format($request->amount,2)."Amount deducted - ".number_format($amountPaid,2)." Remaining Amount -".number_format($amountRemaining,2));

                }

                $this->CustomerRestrictionNibssLog($custCheck->id,$cname,$request->accountNumber,$request->amount,$request->transactionRef,$request->sessionId,"NIBSS Lien Customer account - " . $request->narration,4,null);

                $this->Nibsslog($custCheck->id,$cname,$request->accountNumber,$request->amount,$request->transactionRef,$request->sessionId,$request->narration,'NIBSS Amount Block',null);

                return response()->json(['status' => "00", 'message' => 'Successful, amount is blocked']);

            } else {
                return response()->json(['status' => "70", 'message' => 'Account not found'], 200);
            }

        } catch (LockTimeoutException $e) {

            $this->logInfo("DB lock Error", $e->getMessage());

            return response()->json(['status' => "70", 'message' => 'Failed to Block Account'], 406);

        } finally {
            optional($lock)->release();
        }
    }

    public function unLienAccount(Request $request)
    {
        $this->logInfo("NIBSS unlien Account log",$request->all());

        $validator = Validator::make($request->all(), [
            'accountName' => 'required|string',
            'accountNumber' => 'required|numeric|digits:10',
            'amount' => 'required|numeric|gt:0',
            "narration" => "required|string",
            "sessionId" => "required|string",
            'transactionRef' => 'required|string'
        ]);


        $lock = Cache::lock('unliencustomeracct',3);

        try {

            $lock->block(5);

            $sessionValidationResult = $this->verifySessionID($request->sessionId);

        if ($sessionValidationResult['status'] != "00") {
            return response()->json($sessionValidationResult, 200);
        }

        $narrationResult = $this->validateNarration($request->narration);

        if ($narrationResult['status'] != "00") {
            return response()->json($narrationResult, 200);
        }

            $custCheck = Customer::where('acctno', $request->accountNumber)->first();

            if (!$custCheck) {
                return response()->json(['status' => "70", 'message' => 'Invalid Account provided']);
            }

            $lienCheck = CustomerRestriction::where('reference_no', $request->transactionRef)
                                            ->where('amount', '>', $request->amount)->first();

            if ($lienCheck) {
                return response()->json(['status' => "70", 'message' => 'Unsuccessful, account/amount unblock']);
            }

            // if ($lienCheck->status == 4) {
            //     return response()->json(['status' => "69", 'message' => 'Unsuccessful, account/amount unblock']);
            // }

            $cname = $custCheck->last_name." ".$custCheck->first_name;

            $userWallet = Saving::lockForUpdate()->where('customer_id', $custCheck->id)->first();

            if ($userWallet) {

                $amountPaid = $userWallet->lien_deducted;

                $this->logInfo($amountPaid, "Amount paid is");

                if ($userWallet->lien_deducted <= $request->amount) {

                    $wlaltamountPaid = $userWallet->account_balance + $amountPaid;
                    $userWallet->account_balance = $wlaltamountPaid;

                    $linamount = $userWallet->lien_amount - $request->amount;
                    $userWallet->lien_amount = $linamount;

                    $userWallet->lien_deducted = 0;

                    $userWallet->save();

                } else {

                    $balwla = $userWallet->account_balance + $request->amount;
                    $userWallet->account_balance = $balwla;

                    $lienamount = $userWallet->lien_amount - $request->amount;
                    $userWallet->lien_amount = $lienamount;

                    $liandamount = $userWallet->lien_deducted - $request->amount;
                    $userWallet->lien_deducted = $liandamount;

                    $userWallet->save();

                }

                if ($userWallet->lien_remaining < $userWallet->account_balance) {

                    $userWallienremaining = $userWallet->account_balance - $userWallet->lien_remaining;
                    $userWallet->account_balance = $userWallienremaining;

                    $uWlienremaining = $userWallet->lien_deducted + $userWallet->lien_remaining;
                    $userWallet->lien_deducted = $uWlienremaining;

                    $userWallet->lien_remaining = 0;
                    $userWallet->save();

                } else {

                    $userWalletbalance = $userWallet->lien_remaining - $userWallet->account_balance;
                    $userWallet->lien_remaining = $userWalletbalance;

                    $userWallet->account_balance = 0;
                    $userWallet->save();

                }


                $lienCheckkk = CustomerRestriction::where('reference_no', $request->transactionRef)->first();

                if ($lienCheckkk->amount == $request->amount) {
                    $lienCheckkk->status = 3;
                } else {

                    $ramount = $lienCheckkk->amount - $request->amount;
                    $lienCheckkk->amount = $ramount;

                    if ($lienCheckkk->amount_paid > $request->amount) {

                        $rrtamount = $lienCheckkk->amount_paid - $request->amount;
                        $lienCheckkk->amount_paid = $rrtamount;

                    } else {
                        $lienCheckkk->amount_paid = 0;
                    }

                    $lamountpaid = $lienCheckkk->amount - $lienCheck->amount_paid;
                     $lienCheckkk->amount = $lamountpaid;
                }

                $lienCheckkk->save();

                $this->Nibsslog($custCheck->id,$cname,$custCheck->acctno,$request->amount, $request->transactionRef,$request->sessionId,$request->narration,'NIBSS Amount Unblock',null);


                $this->tracktrails('1','1',$cname,'customer',"NIBSS Unlien Account With Amount -".number_format($request->amount,2));

                return response()->json(['status' => "00", 'message' => 'Successful, amount is unblocked']);

            } else {
                return response()->json(['status' => "70", 'message' => 'Account not found'], 200);
            }

    } catch (LockTimeoutException $e) {

        $this->logInfo($e->getMessage(), "DB lock Error for Unlien");
            return response()->json(['status' => "70", 'message' => 'Failed to Unlien Account'], 406);

    } finally {
        optional($lock)->release();
    }

    }

    public function accountMandate(Request $request)
    {
       $this->logInfo("Account Mandate request log",$request->all());

        $validator = Validator::make($request->all(), [
            'accountName' => 'required|string',
            'accountNumber' => 'required|numeric|digits:10',
            'amount' => 'required|numeric|gt:0',
            "sessionId" => "required|string",
            'mandateReferenceNumber' => 'required|string'
        ]);

        if ($request->amount < 0) {
            return response()->json(['status' => "13", 'message' => "Invalid Amount"]);
        }

        $lock = Cache::lock('accountmandateacct',3);

        try {

            $lock->block(5);

            $sessionValidationResult = $this->verifySessionID($request->sessionId);

        if ($sessionValidationResult['status'] != "00") {
            return \response()->json($sessionValidationResult, 200);
        }

            $custCheck = Customer::where('acctno', $request->accountNumber)->first();

            if (!$custCheck) {
                return response()->json(['status' => "70", 'message' => 'Invalid Account provided']);
            }

            $lienCheck = CustomerRestriction::where('reference_no', $request->mandateReferenceNumber)->orWhere('session_id', $request->sessionId)->first();

            if ($lienCheck) {
                return response()->json(['status' => "94", 'message' => 'Duplicate Transaction - ' . $request->mandateReferenceNumber]);

            }

            $cname = $custCheck->last_name." ".$custCheck->first_name;

            $userWallet = Saving::lockForUpdate()->where('customer_id', $custCheck->id)->first();

            if ($userWallet) {

                $this->CustomerRestrictionNibssLog($custCheck->id,$request->accountName,$request->accountNumber,$request->amount,$request->mandateReferenceNumber,$request->sessionId,"NIBSS Account Mandate - " . $request->narration,8,null);

                $this->Nibsslog($custCheck->id,$request->accountName,$request->accountNumber,$request->amount,$request->mandateReferenceNumber,$request->sessionId,'NIBSS Account Mandate Request','NIBSS Account Mandate',null);

                return response()->json(
                    [
                        'status' => "00",
                        'message' => 'FOR AMOUNT ' . $request->amount . ' AND REFERENCE - ' . $request->mandateReferenceNumber,
                        'data' => [
                            'accountNumber' => $request->accountNumber,
                            'accountName' => $request->accountName,
                            'mandateReferenceNumber' => $request->mandateReferenceNumber
                        ]
                    ]
                );

            } else {
                return response()->json(['status' => "70", 'message' => 'Account not found'], 200);
            }

        }catch (LockTimeoutException $e) {

            $this->logInfo($e->getMessage(), "DB Error for Mandate Advice");
                return response()->json(['status' => "70", 'message' => 'Failed to Place Mandate'], 406);

        } finally {
            optional($lock)->release();
        }
    }

    public function creditUser(Request $request)
    {

       $this->logInfo("creditUser",$request->all());

        $validator = Validator::make($request->all(), [
            'accountName' => 'required|string',
            'accountNumber' => 'required|numeric|digits:10',
            'amount' => 'required|numeric|gt:0',
            'sessionId' => 'required|string',
            "sourceAccountName" => 'required|string',
            "sourceAccountNumber" => 'required|numeric|digits:10'
        ]);

        if ($validator->fails()) {
            return response()->json(['status' => "70", 'message' => $validator->errors()->all()[0]],406);
        }

        if ($request->amount <= 0) {
            return response()->json(['status' => "13", 'message' => "Invalid Amount"]);
        }

        // $narrationResult = $this->validateNarration($request->narration);

        // if ($narrationResult['status'] != "00") {
        //     return response()->json($narrationResult, 200);
        // }

        $sessionValidationResult = $this->verifySessionID($request->sessionId);

        if ($sessionValidationResult['status'] != "00") {
            return \response()->json($sessionValidationResult, 200);
        }

        $lock = Cache::lock('creditcustomeracct',3);

        try {

            $lock->block(1);

            DB::beginTransaction();

            $userAccount = Customer::select('id','last_name','first_name','enable_email_alert','enable_sms_alert','phone','email','account_type','acctno','ctype')->where('acctno',$request->accountNumber)->first();

            if(!$userAccount){
                return response()->json(['status' => "70", 'message' => 'Invalid account number'],406);
            }

            $getsetvalue = new Setting();

             $glsavingdacct = GeneralLedger::select('id','status','account_balance')->where('gl_code','20993097')->first();
             $glcurrentacct = GeneralLedger::select('id','status','account_balance')->where('gl_code','20639526')->first();
             $glinwardacct = GeneralLedger::select('id','status','account_balance')->where('gl_code',$getsetvalue->getsettingskey('inwardoptiongl'))->first();
             $glinwardacctchrage = GeneralLedger::select('id','status','account_balance')->where('gl_code',$getsetvalue->getsettingskey('inwardoptionchrgl'))->first();


             $userWallet = Saving::lockForUpdate()->where('customer_id', $userAccount->id)->first();


             $checkRestriction =  $this->checkCustomerRestrictionNibssLog($userAccount->id,5,null);//check for nibss block account

             if ($checkRestriction == true) {
                 return \response()->json(['status' => "57", 'message' => "TRANSACTION NOT PERMITTED TO SENDER"], 406);
             }

             $usern = $userAccount->last_name." ".$userAccount->first_name;


            $checkTransaction = SavingsTransaction::where('reference_no', $request->sessionId)->first();

            if ($checkTransaction) {
                return response()->json(['status' => "15", 'message' => "INVALID SESSION ID"], 406);
            }


            if($glinwardacct){

                if($glinwardacct->status == '1'){
                    $this->gltransaction('withdrawal',$glinwardacct,$request->amount,null);
                    $this->create_saving_transaction_gl(null,$glinwardacct->id,null, $request->amount,'debit',"NIP",$request->sessionId,$this->generatetrnxref('C'),'customer credited','approved',$usern);
                }

            }else{

                $this->logInfo("Inward GL Error",["Error" => "Please Check GL Inward Option"]);
                return \response()->json(['status' => "57", 'message' => "GL TRANSACTION Error"], 406);
            }

           $balance = $userWallet->account_balance + $request->amount;
           $userWallet->account_balance =  $balance;
           $userWallet->save();

             $narration = $request->narration == "" ? "NIP Inward" : "NIP Inward/".$request->narration;
            $desc = $narration."-- ".$request->sourceAccountName." - ".$request->sourceAccountNumber;
            $source = $request->sourceAccountName." - ".$request->sourceAccountNumber;

           $this->create_saving_transaction(null,$userAccount->id,null,(int)$request->amount,
           'credit','NIP','0',null,null,null,$source,$request->sessionId,$desc,'approved','1','trnsfer',$usern);

           $this->tracktrails('1',null,$usern,'NIP Inward','customer account credited');

        if($userAccount->account_type == '1'){//saving acct GL

            if($glsavingdacct->status == '1'){
                $this->gltransaction('withdrawal',$glsavingdacct,$request->amount,null);
                $this->create_saving_transaction_gl(null,$glsavingdacct->id,null, $request->amount,'credit',"NIP",$request->sessionId,$this->generatetrnxref('C'),'customer credited','approved',$usern);
            }

        }elseif($userAccount->account_type == '2'){//current acct GL

            if($glcurrentacct->status == '1'){
                $this->gltransaction('withdrawal',$glcurrentacct,$request->amount,null);
                $this->create_saving_transaction_gl(null,$glcurrentacct->id,null, $request->amount,'credit',"NIP",$request->sessionId,$this->generatetrnxref('C'),'customer credited','approved',$usern);
            }

        }

            if($getsetvalue->getsettingskey('enable_inward_charge') == "1"){//if charge is enabled

                $inwrdcharge = Setting::where('setting_key', 'stamp_duty')->value('setting_value');

                if($getsetvalue->getsettingskey('account_inward_charge') == "1"){//all account

                    if($request->amount >= '10000'){

                        $balance = (float)$userWallet->account_balance - (float)$inwrdcharge;
                        $userWallet->account_balance =  $balance;
                        $userWallet->save();


                        $this->create_saving_transaction(null,$userAccount->id,null,(int)$inwrdcharge,
                        'debit','Charge on NIP','0',null,null,null,null,$this->generatetrnxref('chrg'),$desc,'approved','10','trnsfer',$usern);

                        $this->tracktrails('1',null,$usern,'NIP Inward charge','customer account debited');

                        if($userAccount->account_type == '1'){//saving acct GL

                            if($glsavingdacct->status == '1'){
                                $this->gltransaction('deposit',$glsavingdacct,$inwrdcharge,null);
                                $this->create_saving_transaction_gl(null,$glsavingdacct->id,null, $inwrdcharge,'debit',"NIP charge",$request->sessionId,$this->generatetrnxref('w'),'customer debited','approved',$usern);
                            }

                        }elseif($userAccount->account_type == '2'){//current acct GL

                            if($glcurrentacct->status == '1'){
                                $this->gltransaction('deposit',$glcurrentacct,$inwrdcharge,null);
                                $this->create_saving_transaction_gl(null,$glcurrentacct->id,null, $inwrdcharge,'debit',"NIP charge",$request->sessionId,$this->generatetrnxref('w'),'customer debited','approved',$usern);
                            }

                        }

                           if($glinwardacctchrage->status == '1'){//inward charge gl
                                 $this->gltransaction('withdrawal',$glinwardacctchrage,$inwrdcharge,null);
                                $this->create_saving_transaction_gl(null,$glinwardacctchrage->id,null, $inwrdcharge,'credit',"NIP charge",$request->sessionId,$this->generatetrnxref('C'),'customer credited','approved',$usern);
                            }
                    }

                }elseif($getsetvalue->getsettingskey('account_inward_charge') == "2"){// only coorporate account

                    if($userAccount->ctype == "cooperate"){

                        if($request->amount >= '10000'){

                            $balance = (float)$userWallet->account_balance - (float)$inwrdcharge;
                            $userWallet->account_balance =  $balance;
                            $userWallet->save();


                        $this->create_saving_transaction(null,$userAccount->id,null,(int)$inwrdcharge,
                        'debit','Charge on NIP','0',null,null,null,null,$this->generatetrnxref('chrg'),$desc,'approved','10','trnsfer',$usern);

                        $this->tracktrails('1',null,$usern,'NIP Inward charge','customer account debited');

                        if($userAccount->account_type == '1'){//saving acct GL

                            if($glsavingdacct->status == '1'){
                                $this->gltransaction('deposit',$glsavingdacct,$inwrdcharge,null);
                                $this->create_saving_transaction_gl(null,$glsavingdacct->id,null, $inwrdcharge,'debit',"NIP charge",$request->sessionId,$this->generatetrnxref('w'),'customer debited','approved',$usern);
                            }

                        }elseif($userAccount->account_type == '2'){//current acct GL

                            if($glcurrentacct->status == '1'){
                                $this->gltransaction('deposit',$glcurrentacct,$inwrdcharge,null);
                                $this->create_saving_transaction_gl(null,$glcurrentacct->id,null, $inwrdcharge,'debit',"NIP charge",$request->sessionId,$this->generatetrnxref('w'),'customer debited','approved',$usern);
                            }

                        }

                             if($glinwardacctchrage->status == '1'){//inward charge gl
                                 $this->gltransaction('withdrawal',$glinwardacctchrage,$inwrdcharge,null);
                                $this->create_saving_transaction_gl(null,$glinwardacctchrage->id,null, $inwrdcharge,'credit',"NIP charge",$request->sessionId,$this->generatetrnxref('C'),'customer credited','approved',$usern);
                            }
                        }

                    }
                }

            }

            DB::commit();

           $msg =  "Credit Amt: N".number_format($request->amount,2)."<br> Desc: ".$desc." <br>Avail Bal: N". number_format($userWallet->account_balance,2)."<br> Date: ".date("Y-m-d")."<br>Ref: ".$request->sessionId;

           $smsmsg = "Credit Amt: N".number_format($request->amount,2)."\n Desc: ".$desc." \n Avail Bal: N".number_format($userWallet->account_balance,2)."\n Date: ".date("Y-m-d")."\n Ref: ".$request->sessionId;

             if($userAccount->enable_sms_alert){
                 $this->sendSms($userAccount->phone,$smsmsg,$getsetvalue->getsettingskey('active_sms'));//send sms
                 }

           if($userAccount->enable_email_alert){

            Email::create([
                'user_id' => $userAccount->id,
                'subject' => ucwords($getsetvalue->getsettingskey('company_name')).' Credit Alert',
                'message' => $msg,
                'recipient' => $userAccount->email,
            ]);

            $this->sendMail($msg,'Credit Transaction',$userAccount->email,ucwords($getsetvalue->getsettingskey('company_name')).' Credit Alert');


            //   Mail::send(['html' => 'mails.sendmail'],[
            //       'msg' => $msg,
            //       'type' => 'Credit Transaction'
            //   ],function($mail)use($getsetvalue,$userAccount){
            //       $mail->from($getsetvalue->getsettingskey('company_email'),ucwords($getsetvalue->getsettingskey('company_name')));
            //        $mail->to();
            //       $mail->subject(ucwords($getsetvalue->getsettingskey('company_name')).' Credit Alert');
            //   });
      }


        return \response()->json([
            'status' => "00",
            'message' => "Customer Credited Successfully",
            "data" => [
                "accountName" => $userAccount->first_name." ".$userAccount->last_name,
                "accountNumber" => $userAccount->acctno,
                "amount" => number_format($request->amount),
                "narration" => "NIP Inward-- ".$request->sourceAccountName,
                "transactionRef" => $request->sessionId
            ]
        ]);


    }catch (LockTimeoutException $e) {

        DB::rollBack();

        $this->logInfo($e->getMessage(), "DB Error for customer deposit");
            return response()->json(['status' => "70", 'message' => 'Failed to credit customer'], 406);

    } finally {
        optional($lock)->release();
    }

}

public function reverseFundsTransferCredit(Request $request)
    {
        $this->logInfo("reverseFundsTransferCredit",$request->all());

        $validator = Validator::make($request->all(), [
            'accountName' => 'required|string',
            'accountNumber' => 'required|numeric|digits:10',
            'amount' => 'required|numeric|gt:0',
            'sessionId' => 'required|string',
            "narration" => 'required|string',
            "sourceAccountName" => 'required|string',
            "sourceAccountNumber" => 'required|numeric|digits:10'
        ]);

        if ($validator->fails()) {
            return \response()->json(['status' => "70", 'message' => $validator->errors()->all()[0]]);
        }

        if ($request->amount <= 0) {
            return response()->json(['status' => "13", 'message' => "Invalid Amount"]);
        }

        $sessionValidationResult = $this->verifySessionID($request->sessionId);

        if ($sessionValidationResult['status'] != "00") {
            return \response()->json($sessionValidationResult, 200);
        }

        $narrationResult = $this->validateNarration($request->narration);

        if ($narrationResult['status'] != "00") {
            return \response()->json($narrationResult, 200);
        }

        $userAccount = Customer::where('acctno',$request->accountNumber)->first();

        if ($userAccount) {

            $getsetvalue = new Setting();

            $glsavingdacct = GeneralLedger::select('id','status','account_balance')->where('gl_code','20993097')->first();
            $glcurrentacct = GeneralLedger::select('id','status','account_balance')->where('gl_code','20639526')->first();

             $glinwardacct = GeneralLedger::select('id','status','account_balance')->where('gl_code',$getsetvalue->getsettingskey('inwardoptiongl'))->first();


            $checkTransaction = SavingsTransaction::where(['reference_no' => $request->sessionId, 'status_type' => 1])->first();

            if (!$checkTransaction) {
                return \response()->json(['status' => "15", 'message' => "INVALID SESSION ID"],406);
            }

            if ($checkTransaction->amount != $request->amount) {
                return \response()->json(['status' => "15", 'message' => "INVALID AMOUNT"],406);
            }

            $checkrevervseTransaction = SavingsTransaction::where(['reference_no' => $request->sessionId, 'status_type' => 3])->first();
            if ($checkrevervseTransaction) {
                return \response()->json(['status' => "21", 'message' => "TRANSACTION ALREADY REVERSED"],200);
            }


    $checkRestriction =  $this->checkCustomerRestrictionNibssLog($userAccount->id,5,null);//check for nibss block account

        if ($checkRestriction == true) {
            return \response()->json(['status' => "57", 'message' => "TRANSACTION NOT PERMITTED TO SENDER"], 406);
        }

        $usern = $userAccount->last_name." ".$userAccount->first_name;

        $userWallet = Saving::lockForUpdate()->where('customer_id', $userAccount->id)->first();


        if($glinwardacct){

               if($glinwardacct->status == '1'){
                   $this->gltransaction('deposit',$glinwardacct,$request->amount,null);
                   $this->create_saving_transaction_gl(null,$glinwardacct->id,null, $request->amount,'credit',"NIP",$request->sessionId,$this->generatetrnxref('NIPRV'),'customer debited','approved',$usern);
               }

       }else{

           $this->logInfo("Inward GL Error",["Error" => "Please Check GL Inward Option"]);
           return \response()->json(['status' => "57", 'message' => "GL TRANSACTION Error"], 406);
       }

       if($request->amount > $userWallet->account_balance){
            return \response()->json(['status' => "16", 'message' => "INSUFFICIENT BALANCE"], 406);
        }

        $balance = $userWallet->account_balance - $request->amount;
        $userWallet->account_balance =  $balance;
        $userWallet->save();

        $desc = "NIBSS Credit Funds Transfer Reversed-- ".$request->sourceAccountName." - ".$request->sourceAccountNumber;

        $this->create_saving_transaction(null,$userAccount->id,null,$request->amount,
        'debit','NIP','0',null,null,null,null,$request->sessionId,$desc,'approved','3','trnsfer',$usern);

        $this->tracktrails('1',null,$usern,'NIP Transfer reverse','customer account debited reverse due to transfer credit');

     if($userAccount->account_type == '1'){//saving acct GL

         if($glsavingdacct->status == '1'){
             $this->gltransaction('deposit',$glsavingdacct,$request->amount,null);
             $this->create_saving_transaction_gl(null,$glsavingdacct->id,null, $request->amount,'debit',"NIP",$request->sessionId,$this->generatetrnxref('NIPRV'),'customer debited','approved',$usern);
         }

     }elseif($userAccount->account_type == '2'){//current acct GL

         if($glcurrentacct->status == '1'){
             $this->gltransaction('deposit',$glcurrentacct,$request->amount,null);
             $this->create_saving_transaction_gl(null,$glcurrentacct->id,null, $request->amount,'debit',"NIP",$request->sessionId,$this->generatetrnxref('NIPRV'),'customer debited','approved',$usern);
         }

     }

     $this->Nibsslog($userAccount->id,$usern,$userAccount->acctno,$request->amount,$ref=null,$request->sessionId,$request->narration,'Funds transfer advice credit',null);

            return \response()->json(
                [
                    'status' => "00",
                    'message' => "SUCESSFUL",
                    "data" => [
                        "accountName" => $userAccount->first_name." ".$userAccount->last_name,
                        "accountNumber" => $userAccount->acctno,
                        "amount" => number_format($request->amount),
                        "narration" => "NIBSS Funds Transfer Reversed | ".$request->sourceAccountName,
                        "transactionRef" => $request->sessionId
                    ]
                    ],200
            );
        } else {
            return \response()->json(['status' => "70", 'message' => "User Account Not found"], 406);
        }
    }

    public function reverseFundsTransferDebit(Request $request)
    {
        $this->logInfo("reverseFundsTransferDebit",$request->all());

        $validator = Validator::make($request->all(), [
            'accountName' => 'required|string',
            'accountNumber' => 'required|numeric|digits:10',
            'amount' => 'required|numeric|gt:0',
            'transactionFee' => 'required|numeric|gt:0',
            'sessionId' => 'required|string',
            "narration" => 'required|string',
            "sourceAccountName" => 'required|string',
            "sourceAccountNumber" => 'required|numeric|digits:10'
        ]);

        if ($validator->fails()) {
            return \response()->json(['status' => "70", 'message' => $validator->errors()->all()[0]]);
        }

        if ($request->amount <= 0) {
            return response()->json(['status' => "13", 'message' => "Invalid Amount"]);
        }

        $sessionValidationResult = $this->verifySessionID($request->sessionId);

        if ($sessionValidationResult['status'] != "00") {
            return \response()->json($sessionValidationResult, 200);
        }

        $narrationResult = $this->validateNarration($request->narration);

        if ($narrationResult['status'] != "00") {
            return \response()->json($narrationResult, 200);
        }

        $userAccount = Customer::where('acctno',$request->accountNumber)->first();

        if ($userAccount) {

                $getsetvalue = new Setting();

            $glsavingdacct = GeneralLedger::select('id','status','account_balance')->where('gl_code','20993097')->first();
            $glcurrentacct = GeneralLedger::select('id','status','account_balance')->where('gl_code','20639526')->first();
            $glinwardacct = GeneralLedger::select('id','status','account_balance')->where('gl_code',$getsetvalue->getsettingskey('inwardoptiongl'))->first();
            $gltransfee = GeneralLedger::select('id','status','account_balance')->where('gl_code','40750866')->first();


            $checkTransaction = SavingsTransaction::where(['reference_no' => $request->sessionId, 'status_type' => 2])->first();

            if (!$checkTransaction) {
                return \response()->json(['status' => "15", 'message' => "INVALID SESSION ID"], 200);
            }

            $checkrevervseTransaction = SavingsTransaction::where(['reference_no' => $request->sessionId, 'status_type' => 4])->first();
            if ($checkrevervseTransaction) {
                return \response()->json(['status' => "21", 'message' => "TRANSACTION ALREADY REVERSED"],200);
            }

     $checkRestriction =  $this->checkCustomerRestrictionNibssLog($userAccount->id,5,null);//check for nibss block account

        if ($checkRestriction == true) {
            return \response()->json(['status' => "57", 'message' => "TRANSACTION NOT PERMITTED TO SENDER"], 406);
        }

        $usern = $userAccount->last_name." ".$userAccount->first_name;

     if($glinwardacct){

        if($glinwardacct->status == '1'){
            $this->gltransaction('withdrawal',$glinwardacct,$request->amount,null);
            $this->create_saving_transaction_gl(null,$glinwardacct->id,null, $request->amount,'debit',"NIP",$request->sessionId,$this->generatetrnxref('NIPRV'),'customer credited','approved',$usern);
        }
    }else{

        $this->logInfo("Inward GL Error",["Error" => "Please Check GL Inward Option"]);

        return \response()->json(['status' => "57", 'message' => "GL TRANSACTION Error"], 406);
    }



        $userWallet = Saving::lockForUpdate()->where('customer_id', $userAccount->id)->first();

        $balance = $userWallet->account_balance + $request->amount;
        $userWallet->account_balance =  $balance;
        $userWallet->save();

        $desc = "NIBSS Debit Funds Transfer Reversed-- ".$request->sourceAccountName." - ".$request->sourceAccountNumber;

        $this->create_saving_transaction(null,$userAccount->id,null,$request->amount,
        'credit','NIP','0',null,null,null,null,$request->sessionId,$desc,'approved','4','trnsfer',$usern);

        $this->tracktrails('1',null,$usern,'NIP Transfer reverse','customer account credit reverse due to transfer debit');

     if($userAccount->account_type == '1'){//saving acct GL

         if($glsavingdacct->status == '1'){
             $this->gltransaction('withdrawal',$glsavingdacct,$request->amount,null);
             $this->create_saving_transaction_gl(null,$glsavingdacct->id,null, $request->amount,'credit',"NIP",$request->sessionId,$this->generatetrnxref('NIPRV'),'customer credited','approved',$usern);
         }

     }elseif($userAccount->account_type == '2'){//current acct GL

         if($glcurrentacct->status == '1'){
             $this->gltransaction('withdrawal',$glcurrentacct,$request->amount,null);
             $this->create_saving_transaction_gl(null,$glcurrentacct->id,null, $request->amount,'credit',"NIP",$request->sessionId,$this->generatetrnxref('NIPRV'),'customer credited','approved',$usern);
         }

     }

     if($request->transactionFee > 0){ //reverse transaction fee

        $balancefee = $userWallet->account_balance + $request->transactionFee;
        $userWallet->account_balance =  $balancefee;
        $userWallet->save();

        $desc = "NIBSS direct debit transaction fee reversed";

        $this->create_saving_transaction(null,$userAccount->id,null,$request->transactionFee,
        'credit','NIP','0',null,null,null,null,$request->sessionId,$desc,'approved','4','trnsfer',$usern);

        $this->tracktrails('1',null,$usern,'NIP','customer account debited');

        if($userAccount->account_type == '1'){//saving acct GL

            if($glsavingdacct->status == '1'){
                $this->gltransaction('withdrawal',$glsavingdacct,$request->transactionFee,null);
                $this->create_saving_transaction_gl(null,$glsavingdacct->id,null, $request->transactionFee,'credit',"NIP",$request->sessionId,$this->generatetrnxref('NIPTrnfee'),'customer credited','approved',$usern);
            }

        }elseif($userAccount->account_type == '2'){//current acct GL

            if($glcurrentacct->status == '1'){
                $this->gltransaction('withdrawal',$glcurrentacct,$request->transactionFee,null);
                $this->create_saving_transaction_gl(null,$glcurrentacct->id,null, $request->transactionFee,'credit',"NIP",$request->sessionId,$this->generatetrnxref('NIPTrnfee'),'customer credited','approved',$usern);
            }

        }

        if( $gltransfee->status == '1'){
            $this->gltransaction('withdrawal', $gltransfee,$request->transactionFee,null);
            $this->create_saving_transaction_gl(null, $gltransfee->id,null, $request->transactionFee,'credit',"NIP",$request->sessionId,$this->generatetrnxref('NIPTrnfee'),'GL debited','approved',$usern);
        }
     }

     $finalAmt =$request->amount+$request->transactionFee;
     $this->Nibsslog($userAccount->id,$usern,$userAccount->acctno,$finalAmt,$ref=null,$request->sessionId,$request->narration,'Funds transfer advice debit',null);

            return \response()->json(
                [
                    'status' => "00",
                    'message' => "SUCESSFUL",
                    "data" => [
                        "accountName" => $userAccount->first_name." ".$userAccount->last_name,
                        "accountNumber" => $userAccount->acctno,
                        "amount" => number_format($request->amount,2),
                        "narration" => "NIBSS Funds Transfer Reversed | ".$request->sourceAccountName,
                        "transactionRef" => $request->sessionId
                    ]
                ]
            );
        } else {
            return \response()->json(['status' => "70", 'message' => "User Account Not found"], 200);
        }
    }


    public function debitUser(Request $request)
    {
        $this->logInfo("debitUser",$request->all());

        $validator = Validator::make($request->all(), [
            'accountName' => 'required|string',
            'accountNumber' => 'required|numeric|digits:10',
            'amount' => 'required|numeric|gt:0',
            'transactionFee' => 'required|numeric|gt:0',
            'sessionId' => 'required|string',
            "narration" => 'required|string',
            "sourceAccountName" => 'required|string',
            "sourceAccountNumber" => 'required|numeric|digits:10'
        ]);

        if ($validator->fails()) {
            return \response()->json(['status' => "70", 'message' => $validator->errors()->all()[0]]);
        }

        if ($request->amount <= 0) {
            return response()->json(['status' => "13", 'message' => "Invalid Amount"]);
        }

        $sessionValidationResult = $this->verifySessionID($request->sessionId);

        if ($sessionValidationResult['status'] != "00") {
            return \response()->json($sessionValidationResult, 200);
        }

        $narrationResult = $this->validateNarration($request->narration);

        if ($narrationResult['status'] != "00") {
            return \response()->json($narrationResult, 200);
        }

        $userAccount = Customer::where('acctno',$request->accountNumber)->first();

        if ($userAccount) {

            $getsetvalue = new Setting();

            $glsavingdacct = GeneralLedger::select('id','status','account_balance')->where('gl_code','20993097')->first();
            $glcurrentacct = GeneralLedger::select('id','status','account_balance')->where('gl_code','20639526')->first();
            $gltransfee = GeneralLedger::select('id','status','account_balance')->where('gl_code','40750866')->first();

            $glinwardacct = GeneralLedger::select('id','status','account_balance')->where('gl_code',$getsetvalue->getsettingskey('inwardoptiongl'))->first();

            $checkTransaction = SavingsTransaction::where('reference_no', $request->sessionId)->first();

            if ($checkTransaction) {
                return \response()->json(['status' => "15", 'message' => "INVALID SESSION ID"], 200);
            }

            $checkRestriction =  $this->checkCustomerRestrictionNibssLog($userAccount->id,5,null);//check for nibss block account

            if ($checkRestriction == true) {
                return \response()->json(['status' => "57", 'message' => "TRANSACTION NOT PERMITTED TO SENDER"], 406);
            }

            $usern = $userAccount->last_name." ".$userAccount->first_name;

       $finalAmount = $request->amount + $request->transactionFee;



        if($glinwardacct){

               if($glinwardacct->status == '1'){
                   $this->gltransaction('deposit',$glinwardacct,$request->amount,null);
                   $this->create_saving_transaction_gl(null,$glinwardacct->id,null, $request->amount,'credit',"NIP",$request->sessionId,$this->generatetrnxref('NIPRV'),'customer debited','approved',$usern);
               }
       }else{

           $this->logInfo("Inward GL Error",["Error" => "Please Check GL Inward Option"]);

           return \response()->json(['status' => "57", 'message' => "GL TRANSACTION Error"], 406);
       }


        $userWallet = Saving::lockForUpdate()->where('customer_id', $userAccount->id)->first();

        if($finalAmount > $userWallet->account_balance){
            return \response()->json(['status' => "16", 'message' => "INSUFFICIENT BALANCE"], 406);
        }

        $balance = $userWallet->account_balance - $request->amount;
        $userWallet->account_balance =  $balance;
        $userWallet->save();

        $desc = "NIBSS customer direct debit ".$request->sourceAccountName." - ".$request->sourceAccountNumber;

        $this->create_saving_transaction(null,$userAccount->id,null,$request->amount,
        'debit','NIP','0',null,null,null,null,$request->sessionId,$desc,'approved','2','trnsfer',$usern);

        $this->tracktrails('1',null,$usern,'NIP','customer account debited');

     if($userAccount->account_type == '1'){//saving acct GL

         if($glsavingdacct->status == '1'){
             $this->gltransaction('deposit',$glsavingdacct,$request->amount,null);
             $this->create_saving_transaction_gl(null,$glsavingdacct->id,null, $request->amount,'debit',"NIP",$request->sessionId,$this->generatetrnxref('NIPTrnfee'),'customer debited','approved',$usern);
         }

     }elseif($userAccount->account_type == '2'){//current acct GL

         if($glcurrentacct->status == '1'){
             $this->gltransaction('deposit',$glcurrentacct,$request->amount,null);
             $this->create_saving_transaction_gl(null,$glcurrentacct->id,null, $request->amount,'debit',"NIP",$request->sessionId,$this->generatetrnxref('NIPTrnfee'),'customer debited','approved',$usern);
         }

     }

     if($request->transactionFee > 0){ //transaction fee

        $balance = $userWallet->account_balance - $request->transactionFee;
        $userWallet->account_balance =  $balance;
        $userWallet->save();

        $desc = "NIBSS direct debit transaction fee";

        $this->create_saving_transaction(null,$userAccount->id,null,$request->transactionFee,
        'debit','NIP','0',null,null,null,null,$request->sessionId,$desc,'approved','2','trnsfer',$usern);

        $this->tracktrails('1',null,$usern,'NIP','customer account debited');

        if($userAccount->account_type == '1'){//saving acct GL

            if($glsavingdacct->status == '1'){
                $this->gltransaction('deposit',$glsavingdacct,$request->transactionFee,null);
                $this->create_saving_transaction_gl(null,$glsavingdacct->id,null, $request->transactionFee,'debit',"NIP",$request->sessionId,$this->generatetrnxref('NIPTrnfee'),'customer debited','approved',$usern);
            }

        }elseif($userAccount->account_type == '2'){//current acct GL

            if($glcurrentacct->status == '1'){
                $this->gltransaction('deposit',$glcurrentacct,$request->transactionFee,null);
                $this->create_saving_transaction_gl(null,$glcurrentacct->id,null, $request->transactionFee,'debit',"NIP",$request->sessionId,$this->generatetrnxref('NIPTrnfee'),'customer debited','approved',$usern);
            }

        }

        if( $gltransfee->status == '1'){
            $this->gltransaction('deposit', $gltransfee,$request->transactionFee,null);
            $this->create_saving_transaction_gl(null, $gltransfee->id,null, $request->transactionFee,'debit',"NIP",$request->sessionId,$this->generatetrnxref('NIPTrnfee'),'GL credited','approved',$usern);
        }
     }

     $this->Nibsslog($userAccount->id,$usern,$userAccount->acctno,$finalAmount,$ref=null,$request->sessionId,$request->narration,'NIBSS direct debit',null);

            return \response()->json(
                [
                    'status' => "00",
                    'message' => "User Debited Successfully",
                    "data" => [
                        "accountName" => $userAccount->first_name." ".$userAccount->last_name,
                        "accountNumber" => $userAccount->acctno,
                        "amount" => number_format($request->amount),
                        "narration" => "NIBSS customer Debit",
                        "transactionRef" => $request->sessionId
                    ]
                ]
            );
        } else {
            return \response()->json(['status' => "70", 'message' => "User Account Not found"], 200);
        }
    }

    public function directDebitMandate(Request $request)
    {

        $this->logInfo("direct debit mandate", $request->all());

        $validator = Validator::make($request->all(), [
            'accountName' => 'required|string',
            'accountNumber' => 'required|numeric|digits:10',
            'amount' => 'required|numeric|gt:0',
            'sessionId' => 'required|string',
            'narration' => 'required|string',
            'mandateReferenceNumber' => 'required|string'
        ]);

        if ($validator->fails()) {
            return \response()->json(['status' => "70", 'message' => $validator->errors()->all()[0]],406);
        }

        $sessionValidationResult = $this->verifySessionID($request->sessionId);

        if ($sessionValidationResult['status'] != "00") {
            return \response()->json($sessionValidationResult, 200);
        }

        $narrationResult = $this->validateNarration($request->narration);

        if ($narrationResult['status'] != "00") {
            return \response()->json($narrationResult, 200);
        }


        $userAccount = Customer::where('acctno', $request->accountNumber)->first();

        if ($userAccount) {

            $getsetvalue = new Setting();

            $glsavingdacct = GeneralLedger::select('id','status','account_balance')->where('gl_code','20993097')->first();
            $glcurrentacct = GeneralLedger::select('id','status','account_balance')->where('gl_code','20639526')->first();
            $glinwardacct = GeneralLedger::select('id','status','account_balance')->where('gl_code',$getsetvalue->getsettingskey('inwardoptiongl'))->first();


            $lienCheck = CustomerRestriction::where('reference_no',$request->mandateReferenceNumber)->first();

            if (!$lienCheck) {
                return response()->json(['status' => "25", 'message' => 'UNABLE TO LOCATE RECORD']);
            }

            if ($lienCheck->amount < $request->amount) {
                return response()->json(['status' => "13", 'message' => 'INVALID AMOUNT']);
            }

            $usern = $userAccount->last_name." ".$userAccount->first_name;


       if($glinwardacct){

              if($glinwardacct->status == '1'){
                  $this->gltransaction('deposit',$glinwardacct,$request->amount,null);
                  $this->create_saving_transaction_gl(null,$glinwardacct->id,null, $request->amount,'credit',"NIP",$request->sessionId,$this->generatetrnxref('NIPRV'),'customer debited','approved',$usern);
              }
      }else{

          $this->logInfo("Inward GL Error",["Error" => "Please Check GL Inward Option"]);

          return \response()->json(['status' => "57", 'message' => "GL TRANSACTION Error"], 406);
      }


            $userWallet = Saving::lockForUpdate()->where('customer_id', $userAccount->id)->first();

            if($request->amount > $userWallet->account_balance){
                   return \response()->json(['status' => "16", 'message' => "INSUFFICIENT BALANCE"], 406);
             }


            $balance = $userWallet->account_balance - $request->amount;
            $userWallet->account_balance =  $balance;
            $userWallet->save();

            $desc = "NIBSS direct debit mandate - " . $request->mandateReferenceNumber;

            $this->create_saving_transaction(null,$userAccount->id,null,$request->amount,
            'debit','NIP','0',null,null,null,null,$request->sessionId,$desc,'approved','2','trnsfer',$usern);

            $this->tracktrails('1',null,$usern,'NIP','NIBSS direct debit mandate');

         if($userAccount->account_type == '1'){//saving acct GL

             if($glsavingdacct->status == '1'){
                 $this->gltransaction('deposit',$glsavingdacct,$request->amount,null);
                 $this->create_saving_transaction_gl(null,$glsavingdacct->id,null, $request->amount,'debit',"NIP",$request->sessionId,$this->generatetrnxref('NIPRV'),'customer debited','approved',$usern);
             }

         }elseif($userAccount->account_type == '2'){//current acct GL

             if($glcurrentacct->status == '1'){
                 $this->gltransaction('deposit',$glcurrentacct,$request->amount,null);
                 $this->create_saving_transaction_gl(null,$glcurrentacct->id,null, $request->amount,'debit',"NIP",$request->sessionId,$this->generatetrnxref('NIPRV'),'customer debited','approved',$usern);
             }

         }


            $reqamount = $lienCheck->amount - $request->amount;
            $lienCheck->amount = $reqamount;
            $lienCheck->save();

            $this->Nibsslog($userAccount->id,$usern,$userAccount->acctno,$request->amount,$request->mandateReferenceNumber,$request->sessionId,$request->narration,'NIBSS direct debit mandate',null);

            return \response()->json(
                [
                    'status' => "00",
                    'message' => "Successful",
                    "data" => [
                        "accountName" => $userAccount->first_name." ".$userAccount->last_name,
                        "accountNumber" => $userAccount->acctno,
                        "amount" => number_format($request->amount,2),
                        "narration" => "NIBSS Direct debit mandate",
                    ]
                ]
            );
        } else {
            return \response()->json(['status' => "70", 'message' => "User Account Not found"], 406);
        }
    }

    public function addNewBanks(Request $request)
    {
        $this->logInfo("new banks log",$request->all());

        $validator = Validator::make($request->all(), [
            'batchNumber' => 'required|string',
            'records' => 'required'
        ]);

        if ($validator->fails()) {
            return \response()->json(['status' => "70", 'message' => $validator->errors()->all()[0]]);
        }

        $records = $request->all();

        $banks = $records["records"];

        if (count($banks) > 0) {

            foreach ($banks as $bank) {
                Bank::create([
                    "bank_name" => $bank["institutionName"],
                    "bank_code" => $bank["institutionCode"],
                    "created_at" => Carbon::now(),
                    "updated_at" => Carbon::now()
                ]);
            }
            return response()->json(
                [
                    'status' => "00",
                    'message' => "Request processed successfully",
                    'data' => [
                        'numberOfRecords' => count($banks),
                        "batchNumber" => $records["batchNumber"]
                    ]
                ]
            );
        } else
            return \response()->json(['status' => "70", 'message' => "No Banks sent"], 406);
    }

     public function queryTransaction($reference){

        $this->logInfo("query transaction",$reference);

        $this->verifySessionID($reference);


        $transaction = Savingstransaction::where('reference_no', $reference)->first();

        if ($transaction) {

            return response()->json(
                ['status' => '00',
                 'message' => 'Transaction details fetched successfully',
                  'data' => [
                    "amount" => $transaction->amount,
                    "reference_no" =>  $transaction->reference_no,
                    "transaction_status" => $transaction->status == 'approved' ? 'success': 'failed',
                    "description" => $transaction->notes,
                    "transaction_date" => date('Y-m-d H:ia',strtotime($transaction->created_at)),
                    ]
                ],200);

        } else {

            return response()->json(['status' => '70', 'message' => 'Invalid transaction reference'], 406);

        }
    }

    public function validateNarration($narration)
    {
        if (preg_match('/[\'^£$%&*()}{@#~?><>,|=_+¬-]/', $narration)) {
            // one or more of the 'special characters' found in $string
            return ['status' => "30", 'message' => "REMOVE OR ESCAPE SPECIAL CHARACTERS IN NARRATION"];
        }

        if (\strlen($narration) > 100) {
            return ['status' => "30", 'message' => 'LENGTH OF NARRATION IS MAX 100'];
        }

        if (preg_match('/[^A-Za-z0-9 ]/', $narration)) {
            // one or more of the 'special characters' found in $string
            return ['status' => "30", 'message' => "REMOVE OR ESCAPE SPECIAL CHARACTERS IN NARRATION"];
        }

        return ['status' => "00", 'message' => 'Narration is valid'];
    }

    public function verifySessionID($sessionId)
    {
        if (strlen($sessionId) != 30) {
            return ['status' => "15", 'message' => "INVALID SESSION ID. SESSION ID MUST BE 30 CHARACTERS"];
        }

        if (preg_match('/[\'^£$%&*()}{@#~?><>,|=_+¬-]/', $sessionId)) {
            // one or more of the 'special characters' found in $string
            return ['status' => "30", 'message' => "INVALID SESSION ID. SESSION ID MUST NOT CONTAIN SPECIAL CHARACTERS"];
        }

        if (preg_match('/^[a-zA-Z]+[a-zA-Z0-9._]+$/', $sessionId)) {
            // one or more of the 'special characters' found in $string
            return ['status' => "30", 'message' => "INVALID SESSION ID. SESSION ID MUST CONTAIN ONLY NUMERIC CHARACTERS"];
        }

        return ['status' => "00", 'message' => "SESSION ID IS VALID"];
    }
}//endclass
