<?php

namespace App\Http\Controllers;

use Carbon\Carbon;
use App\Models\Bank;
use App\Models\Loan;
use App\Models\Saving;
use App\Models\Sector;
use App\Models\Payroll;
use App\Models\Setting;
use App\Models\Customer;
use App\Models\Expenses;
use App\Models\NibssLog;
use App\Models\OtherIncome;
use App\Models\Exchangerate;
use App\Models\FixedDeposit;
use App\Models\LoanSchedule;
use Illuminate\Http\Request;
use App\Models\GeneralLedger;
use App\Models\LoanRepayment;
use App\Models\Accountofficer;
use App\Http\Traites\LoanTraite;
use App\Http\Traites\UserTraite;
use App\Http\Traites\SavingTraite;
use App\Models\SavingsTransaction;
use Illuminate\Support\Facades\DB;
use App\Models\NotificationPayload;
use Illuminate\Support\Facades\Log;
use App\Models\MonthlySavingsProfit;
use App\Models\SavingsTransactionGL;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Http;
use PhpOffice\PhpSpreadsheet\IOFactory;
use PhpOffice\PhpSpreadsheet\Style\Fill;
use PhpOffice\PhpSpreadsheet\Reader\Xlsx;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use Spatie\SimpleExcel\SimpleExcelReader;
use Spatie\SimpleExcel\SimpleExcelWriter;
use function PHPUnit\Framework\returnSelf;
use PhpOffice\PhpSpreadsheet\Style\Border;
use PhpOffice\PhpSpreadsheet\Style\Alignment;
use PhpOffice\PhpSpreadsheet\Calculation\Calculation;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx as WriterXlsx;

class ReportsController extends Controller
{
    use LoanTraite;
    use SavingTraite;
    use UserTraite;

    public function __construct()
    {
        $this->middleware('auth');
    }
    public function balancesheet()
    {

        if (request()->bsheettyp == "1") {

            $capital = $this->total_capital(request()->datefrom, request()->dateto);
            $expenses = $this->total_expenses(request()->datefrom, request()->dateto);
            $payroll = $this->total_payroll(request()->datefrom, request()->dateto);
            $principal = $this->loans_total_principal(request()->datefrom, request()->dateto);
            $other_income = $this->total_other_income(request()->datefrom, request()->dateto);
            $deposits = $this->total_savings_deposits(request()->datefrom, request()->dateto);
            $withdrawals = $this->total_savings_withdrawals(request()->datefrom, request()->dateto);
            $principal_paid = $this->loans_total_paid_item('principal', request()->datefrom, request()->dateto);
            $interest_paid = $this->loans_total_paid_item('interest', request()->datefrom, request()->dateto);
            $fees_paid = $this->loans_total_paid_item('fees', request()->datefrom, request()->dateto);
            $penalty_paid = $this->loans_total_paid_item('penalty', request()->datefrom, request()->dateto);
            $total_payments = $expenses + $payroll + $principal + $withdrawals;
            $total_receipts = $principal_paid + $fees_paid + $interest_paid + $penalty_paid + $other_income + $deposits + $capital;
            $cash_balance = $total_receipts - $total_payments;

            if (request()->filter == "true") {
                return view('reports.balance_sheet')->with('capital', $capital)
                    ->with('expenses', $expenses)
                    ->with('payroll', $payroll)
                    ->with('principal', $principal)
                    ->with('otherincome', $other_income)
                    ->with('deposits', $deposits)
                    ->with('withdrawals', $withdrawals)
                    ->with('principalpaid', $principal_paid)
                    ->with('interest_paid', $interest_paid)
                    ->with('fees_paid', $fees_paid)
                    ->with('penalty_paid', $penalty_paid)
                    ->with('total_payments', $total_payments)
                    ->with('total_receipts', $total_receipts)
                    ->with('cash_balance', $cash_balance);
            } else {
                return view('reports.balance_sheet');
            }
        } elseif (request()->bsheettyp == "2") {
            return view('reports.balance_sheet2');
        }
    }

    public function trialbalance()
    {
        return view('reports.trial_balance');
    }

    public function print_balancesheet()
    {

        $capital = $this->total_capital(request()->datefrom, request()->dateto);
        $expenses = $this->total_expenses(request()->datefrom, request()->dateto);
        $payroll = $this->total_payroll(request()->datefrom, request()->dateto);
        $principal = $this->loans_total_principal(request()->datefrom, request()->dateto);
        $other_income = $this->total_other_income(request()->datefrom, request()->dateto);
        $deposits = $this->total_savings_deposits(request()->datefrom, request()->dateto);
        $withdrawals = $this->total_savings_withdrawals(request()->datefrom, request()->dateto);
        $principal_paid = $this->loans_total_paid_item('principal', request()->datefrom, request()->dateto);
        $interest_paid = $this->loans_total_paid_item('interest', request()->datefrom, request()->dateto);
        $fees_paid = $this->loans_total_paid_item('fees', request()->datefrom, request()->dateto);
        $penalty_paid = $this->loans_total_paid_item('penalty', request()->datefrom, request()->dateto);
        $total_payments = $expenses + $payroll + $principal + $withdrawals;
        $total_receipts = $principal_paid + $fees_paid + $interest_paid + $penalty_paid + $other_income + $deposits + $capital;
        $cash_balance = $total_receipts - $total_payments;

        return view('reports.print_balancesheet')->with('capital', $capital)
            ->with('expenses', $expenses)
            ->with('payroll', $payroll)
            ->with('principal', $principal)
            ->with('otherincome', $other_income)
            ->with('deposits', $deposits)
            ->with('withdrawals', $withdrawals)
            ->with('principalpaid', $principal_paid)
            ->with('interest_paid', $interest_paid)
            ->with('fees_paid', $fees_paid)
            ->with('penalty_paid', $penalty_paid)
            ->with('total_payments', $total_payments)
            ->with('total_receipts', $total_receipts)
            ->with('cash_balance', $cash_balance);
    }

    public function callover()
    {
        //$branch = session()->has('branchid') ? session()->get('branchid')['bid'] : Auth::user()->branch_id;

        //return dd(request()->all());
        if (request()->filter == true && request()->callovertype == '1') {
            if (request()->type == 'all' && empty(request()->type)) {

                $alldata = SavingsTransaction::whereBetween('created_at', [request()->datefrom, request()->dateto])->get();

                return view('reports.call_over')->with('data', $alldata);
            } else {

                if (request()->type = "deposit") {
                    $typdata = SavingsTransaction::whereBetween('created_at', [request()->datefrom, request()->dateto])
                        ->whereIn('type', ["deposit", "credit"])->get();

                    return view('reports.call_over')->with('data', $typdata);
                } elseif (request()->type = "withdrawal") {
                    $typdata = SavingsTransaction::whereBetween('created_at', [request()->datefrom, request()->dateto])
                        ->whereIn('type', ["debit", "withdrawal"])->get();

                    return view('reports.call_over')->with('data', $typdata);
                } else {

                    $typdata = SavingsTransaction::whereBetween('created_at', [request()->datefrom, request()->dateto])
                        ->where('type', request()->type)->get();

                    return view('reports.call_over')->with('data', $typdata);
                }
            }
        } elseif (request()->filter == true && request()->callovertype == '2') {

            if (request()->gl == '1') {

                if (request()->status == 'all' || empty(request()->status)) {
                    $alldatastatus = SavingsTransactionGL::whereBetween('created_at', [date("Y-m-d", strtotime(request()->datefrom)), date("Y-m-d", strtotime(request()->dateto))])->get();

                    return view('reports.call_over')->with('data', $alldatastatus);
                } else {

                    $statusdata = SavingsTransactionGL::whereBetween('created_at', [date("Y-m-d", strtotime(request()->datefrom)), date("Y-m-d", strtotime(request()->dateto))])
                        ->where('status', request()->status)->get();

                    return view('reports.call_over')->with('data', $statusdata);
                }
            } else {
                if (request()->status == 'all' || empty(request()->status)) {
                    $alldatastatus = SavingsTransaction::whereBetween('created_at', [date("Y-m-d", strtotime(request()->datefrom)), date("Y-m-d", strtotime(request()->dateto))])->get();

                    return view('reports.call_over')->with('data', $alldatastatus);
                } else {

                    $statusdata = SavingsTransaction::whereBetween('created_at', [date("Y-m-d", strtotime(request()->datefrom)), date("Y-m-d", strtotime(request()->dateto))])
                        ->where('status', request()->status)->get();

                    return view('reports.call_over')->with('data', $statusdata);
                }
            }
        } else {
            return view('reports.call_over');
        }
    }

    public function bvnsearch()
    {

        $cust = Customer::where('bvn', request()->bvn_number)->first();

        return view("reports.bvn_search")->with('cutoms', $cust);
    }

    public function notificationpayload()
    {
        // NotificationPayload::orderBy('created_at','DESC')->get()
        if (request()->filter == true) {
            $inward = SavingsTransaction::with('customer')->where('device', 'NIP')
                ->where('status_type', '1')
                ->whereBetween('created_at', [request()->datefrom, request()->dateto])
                ->get();

            return view("reports.virtual_inwardTrnx")->with('paylods', $inward);
        } else {
            $inward = SavingsTransaction::with('customer')->where('status_type', '1')
                ->where('device', 'NIP')
                ->orderBy('id', 'DESC')
                ->take(100)->get();

            return view("reports.virtual_inwardTrnx")->with('paylods', $inward);
        }
    }

    public function cashflow()
    {
        $capital = $this->total_capital(request()->datefrom, request()->dateto);
        $expenses = $this->total_expenses(request()->datefrom, request()->dateto);
        $payroll = $this->total_payroll(request()->datefrom, request()->dateto);
        $principal = $this->loans_total_principal(request()->datefrom, request()->dateto);
        $other_income = $this->total_other_income(request()->datefrom, request()->dateto);
        $deposits = $this->total_savings_deposits(request()->datefrom, request()->dateto);
        $withdrawals = $this->total_savings_withdrawals(request()->datefrom, request()->dateto);
        $principal_paid = $this->loans_total_paid_item('principal', request()->datefrom, request()->dateto);
        $interest_paid = $this->loans_total_paid_item('interest', request()->datefrom, request()->dateto);
        $fees_paid = $this->loans_total_paid_item('fees', request()->datefrom, request()->dateto);
        $penalty_paid = $this->loans_total_paid_item('penalty', request()->datefrom, request()->dateto);

        $rev_deposits = $this->rev_total_savings_deposits(request()->datefrom, request()->dateto);
        $fixed_deposit = $this->total_fixed_deposit(request()->datefrom, request()->dateto);
        $investment = $this->total_investment(request()->datefrom, request()->dateto);
        $wht = $this->total_wht(request()->datefrom, request()->dateto);
        $rev_fixed_deposit = $this->rev_total_fixed_deposit(request()->datefrom, request()->dateto);
        $rev_withdrawals = $this->rev_total_savings_withdrawals(request()->datefrom, request()->dateto);

        $total_payments = $expenses + $payroll + $principal + $withdrawals - $rev_withdrawals;

        $total_receipts = $principal_paid + $fees_paid + $interest_paid + $penalty_paid + $other_income + $deposits + $fixed_deposit - $rev_deposits - $rev_fixed_deposit + $investment + $capital;

        $cash_balance = $total_receipts - $total_payments;

        if (request()->filter == "true") {
            return view('reports.cash_flow')->with('capital', $capital)
                ->with('expenses', $expenses)
                ->with('payroll', $payroll)
                ->with('principal', $principal)
                ->with('other_income', $other_income)
                ->with('deposits', $deposits)
                ->with('withdrawals', $withdrawals)
                ->with('principal_paid', $principal_paid)
                ->with('interest_paid', $interest_paid)
                ->with('fees_paid', $fees_paid)
                ->with('penalty_paid', $penalty_paid)
                ->with('total_payments', $total_payments)
                ->with('total_receipts', $total_receipts)
                ->with('rev_withdrawals', $rev_withdrawals)
                ->with('rev_deposits', $rev_deposits)
                ->with('fixed_deposit', $fixed_deposit)
                ->with('rev_fixed_deposit', $rev_fixed_deposit)
                ->with('investment', $investment)
                ->with('wht', $wht)
                ->with('cash_balance', $cash_balance);
        } else {
            return view('reports.cash_flow');
        }
    }

    public function reference_search()
    {
        $gettranslip = SavingsTransaction::where('slip', request()->slipno)->orWhere('reference_no', request()->slipno)->get();
        if (empty($gettranslip)) {
            return view('reports.reference_search')->with('error', 'slip or reference number not found');
        } else {
            return view('reports.reference_search')->with('data', $gettranslip);
        }
    }



    public function collection_project()
    {
        $branch = session()->has('branchid') ? session()->get('branchid')['bid'] : Auth::user()->branch_id;

        $monthly_collections = array();
        $start_date1 = date("Y-m-d");
        //   for ($i = 1; $i < 14; $i++) {
        //$d = explode('-', $start_date1);
        //get loans in that period

        $payments_due = 0;
        foreach (LoanSchedule::where('branch_id', $branch)->get() as $key) {
            $payments_due = $payments_due + $key->principal + $key->interest + $key->fees + $key->penalty;
        }
        $payments_due = round($payments_due, 2);
        //$ext = ' ' . $d[0];
        $date = date("M Y");
        array_push($monthly_collections, array(
            'month' => $date,
            'due' => $payments_due
        ));
        //add 1 month to start date
        $start_date1 = date_format(
            date_add(
                date_create($start_date1),
                date_interval_create_from_date_string('1 months')
            ),
            'Y-m-d'
        );
        //}
        $collections = json_encode(array('month' => $date, 'due' => $payments_due));

        return view('reports.collection_projection')->with('collections', $collections);
    }

    public function collection_report()
    {
        $branch = session()->has('branchid') ? session()->get('branchid')['bid'] : Auth::user()->branch_id;

        $payments = 0;
        $payments_due = 0;
        foreach (Loan::where('branch_id', $branch)->where('status', 'disbursed')->get() as $key) {
            $payments = $payments + $this->loan_paid_item($key->id, 'interest', $key->due_date) + $this->loan_paid_item(
                $key->id,
                'fees',
                $key->due_date
            ) + $this->loan_paid_item(
                        $key->id,
                        'penalty',
                        $key->due_date
                    ) + $this->loan_paid_item($key->id, 'principal', $key->due_date);
            $payments_due = $payments_due + $this->loan_total_principal($key->id) + $this->loan_total_fees($key->id) + $this->loan_total_penalty($key->id) + $this->loan_total_interest($key->id);
        }
        $payments = round($payments, 2);
        $payments_due = round($payments_due, 2);
        $date = date("M Y");
        // array_push($monthly_collections, array(
        //     'month' => date_format(date_create($start_date1),
        //         'M' . $ext),
        //     'payments' => $payments,
        //     'due' => $payments_due
        // ));
        //add 1 month to start date
        ;

        $collections = json_encode(array('month' => $date, 'paid' => $payments, 'due' => $payments_due));

        return view('reports.collection_report')->with('collections', $collections);
    }

    public function posting_approval()
    {
        $branch = session()->has('branchid') ? session()->get('branchid')['bid'] : Auth::user()->branch_id;
        if (request()->filter == true) {
            if (request()->status == 'all') {
                $alldatastatus = SavingsTransaction::whereIn('status', ['approved', 'declined'])
                    ->whereBetween('created_at', [date("Y-m-d", strtotime(request()->datefrom)), date("Y-m-d", strtotime(request()->dateto))])
                    ->where('is_approve', '1')
                    ->get();

                return view('reports.posting_approval')->with('data', $alldatastatus);
            } else {
                $statusdata = SavingsTransaction::whereBetween('created_at', [date("Y-m-d", strtotime(request()->datefrom)), date("Y-m-d", strtotime(request()->dateto))])
                    ->where('status', request()->status)
                    ->where('is_approve', '1')
                    ->get();
                return view('reports.posting_approval')->with('data', $statusdata);
            }
        } else {
            return view('reports.posting_approval');
        }
    }

    public function customer_statement()
    {
        $branch = session()->has('branchid') ? session()->get('branchid')['bid'] : Auth::user()->branch_id;

        if (request()->filter == true) {
            $balance = 0;
            //where('branch_id', $branch)
            $custmer = Customer::where('acctno', request()->acctno)->first();

            $data = SavingsTransaction::whereBetween('created_at', [date("Y-m-d", strtotime(request()->datefrom)), date("Y-m-d", strtotime(request()->dateto))])
                ->where('customer_id', $custmer->id)->orderBy('created_at', "ASC")->get();

            $savtrns = SavingsTransaction::where('customer_id', $custmer->id)->whereDate('created_at', '<', request()->datefrom)->orderBy('created_at', 'ASC')->get();

            foreach ($savtrns as $key) {
                if (
                    $key['type'] == "deposit" || $key['type'] == "investment" || $key['type'] == "dividend" || $key['type'] == "interest" ||
                    $key['type'] == "credit" || $key['type'] == "fixed_deposit" || $key['type'] == "loan" || $key['type'] == "fd_interest"
                    || $key['type'] == "inv_int" || $key['type'] == "rev_withdrawal" || $key['type'] == 'guarantee_restored'
                ) {

                    if ($key['status'] == 'approved') {
                        $balance += $key->amount;
                    } else {
                        $balance;
                    }
                } else {
                    if ($key->status == 'pending' || $key->status == 'declined') {
                        $balance += 0;
                    } else {
                        $balance -= $key->amount;
                    }
                }

                $balance;
            }

            return view('reports.customer_statement')->with('data', $data)
                ->with('custid', $balance);
        } else {
            return view('reports.customer_statement');
        }
    }

    public function customer_balance()
    {
        if (request()->filter == true) {
            if (request()->fetchby == "byname") {

                $bynme = Customer::select('id', 'last_name', 'first_name', 'branch_id', 'acctno', 'accountofficer_id', 'phone')
                    ->where('first_name', request()->name)
                    ->orWhere('last_name', request()->name)->get();

                return view('reports.customer_balance')->with('data', $bynme);
            } elseif (request()->fetchby == "byaccount") {

                $byac = Customer::select('id', 'last_name', 'first_name', 'branch_id', 'acctno', 'accountofficer_id', 'phone')
                    ->where('acctno', request()->acctno)->get();

                return view('reports.customer_balance')->with('data', $byac);
            } elseif (empty(request()->acctno) || empty(request()->name)) {

                return view('reports.customer_balance')->with('data', Customer::select('id', 'last_name', 'first_name', 'branch_id', 'acctno', 'accountofficer_id', 'phone')->orderBy('id', 'DESC')->get());
            } else {

                return view('reports.customer_balance')->with('data', Customer::select('id', 'last_name', 'first_name', 'branch_id', 'acctno', 'accountofficer_id', 'phone')->orderBy('id', 'DESC')->get());
            }
        } else {
            return view('reports.customer_balance');
        }
    }

    public function customer_view()
    {
        $branch = session()->has('branchid') ? session()->get('branchid')['bid'] : Auth::user()->branch_id;

        if (request()->filter == true) {

            if (request()->officer == 'all') {

                $data = Customer::select('first_name', 'last_name', 'phone', 'status', 'gender', 'accountofficer_id')
                    ->where('id', request()->cusmername)->get();

                return view('reports.customer_view')->with('data', $data)
                    ->with('customers', Customer::select('id', 'first_name', 'last_name')->get())
                    ->with('officers', Accountofficer::select('id', 'full_name')->get());
            } else {

                $data = Customer::select('first_name', 'last_name', 'phone', 'status', 'gender', 'accountofficer_id')
                    ->where('id', request()->cusmername)
                    ->where('accountofficer_id', request()->officer)->get();

                return view('reports.customer_view')->with('data', $data)
                    ->with('customers', Customer::select('id', 'first_name', 'last_name')->get())
                    ->with('officers', Accountofficer::select('id', 'full_name')->get());
            }
        } else {

            return view('reports.customer_view')->with('customers', Customer::select('id', 'first_name', 'last_name')->get())
                ->with('officers', Accountofficer::select('id', 'full_name')->get());
        }
    }

    public function profit_loss()
    {
        $branch = session()->has('branchid') ? session()->get('branchid')['bid'] : Auth::user()->branch_id;

        if (request()->prfltype == '1') {
            if (request()->filter == true) {

                $expenses = $this->total_expenses(request()->datefrom, request()->dateto);
                $other_expenses = $this->total_savings_interest(request()->datefrom, request()->dateto);
                $fd_interest_expense = $this->total_FD_interest_expense(request()->datefrom, request()->dateto);
                $inv_interest_expense = $this->total_inv_int_expense(request()->datefrom, request()->dateto);
                $payroll = $this->total_payroll(request()->datefrom, request()->dateto);
                $other_income = $this->total_other_income(request()->datefrom, request()->dateto);
                $interest_paid = $this->loans_total_paid_item('interest', request()->datefrom, request()->dateto);
                $fees_paid = $this->loans_total_paid_item('fees', request()->datefrom, request()->dateto);
                $bank_fees = $this->total_bank_fees(request()->datefrom, request()->dateto);
                $wht = $this->total_wht(request()->datefrom, request()->dateto);
                $form_fees = $this->total_form_fees(request()->datefrom, request()->dateto);
                $process_fees = $this->total_process_fees(request()->datefrom, request()->dateto);
                $esusu = $this->total_esusu(request()->datefrom, request()->dateto);
                $monthly_charge = $this->total_monthly_charge(request()->datefrom, request()->dateto);
                $transfer_charge = $this->total_transfer_charge(request()->datefrom, request()->dateto);
                $penalty_paid = $this->loans_total_paid_item('penalty', request()->datefrom, request()->dateto);
                $loan_default = $this->loans_total_default(request()->datefrom, request()->dateto);

                $operating_expenses = $expenses + $payroll + $other_expenses + $fd_interest_expense + $inv_interest_expense;

                $operating_profit = $fees_paid + $interest_paid + $penalty_paid + $bank_fees + $form_fees + $process_fees + $esusu + $monthly_charge + $transfer_charge + $other_income;

                $gross_profit = $operating_profit - $operating_expenses;

                $net_profit = $gross_profit - $loan_default;

                $fromdate = date("Y-m", strtotime(request()->datefrom));
                $todate = date("Y-m", strtotime(request()->dateto));


                //monthly_net_income_data
                //get loans in that period
                $o_profit = 0;
                foreach (
                    Loan::where('branch_id', $branch)->whereBetween('created_at', [$fromdate, $todate])->where(
                        'status',
                        'disbursed'
                    )->get() as $key
                ) {
                    $o_profit = $o_profit + $this->loan_paid_item(
                        $key->id,
                        'interest',
                        $key->due_date
                    ) + $this->loan_paid_item(
                                $key->id,
                                'fees',
                                $key->due_date
                            ) + $this->loan_paid_item($key->id, 'penalty', $key->due_date);
                }
                $o_profit = round($o_profit + OtherIncome::whereBetween('created_at', [$fromdate, $todate])->sum('amount'), 2);

                $o_expense = Expenses::where('branch_id', $branch)->whereBetween('created_at', [$fromdate, $todate])->sum('amount');

                foreach (Payroll::whereBetween('created_at', [$fromdate, $todate])->get() as $key) {
                    $o_expense = $o_expense + $this->single_payroll_total_pay($key->id);
                }

                $o_expense = round($o_expense, 2);
                $ot_expense = 0;

                foreach (
                    Loan::where('branch_id', $branch)->whereBetween('created_at', [$fromdate, $todate])->where(
                        'status',
                        'disbursed'
                    )->get() as $key
                ) {
                    $ot_expense = $ot_expense + ($key->principal - $this->loan_total_paid($key->id));
                }

                $ot_expense = round($ot_expense, 2);

                $totnet_income = round(($o_profit - $o_expense - $ot_expense), 2);

                //$monthly_operating_profit_expenses_data
                $o_profit = 0;
                foreach (
                    Loan::where('branch_id', $branch)->whereBetween('created_at', [$fromdate, $todate])->where(
                        'status',
                        'disbursed'
                    )->get() as $key
                ) {
                    $o_profit = $o_profit + $this->loan_paid_item(
                        $key->id,
                        'interest',
                        $key->due_date
                    ) + $this->loan_paid_item(
                                $key->id,
                                'fees',
                                $key->due_date
                            ) + $this->loan_paid_item($key->id, 'penalty', $key->due_date);
                }

                $o_profit = round($o_profit + OtherIncome::where('branch_id', $branch)->whereBetween('created_at', [$fromdate, $todate])->sum('amount'), 2);

                $o_expense = Expenses::where('branch_id', $branch)->whereBetween('created_at', [$fromdate, $todate])->sum('amount');

                foreach (Payroll::where('branch_id', $branch)->whereBetween('created_at', [$fromdate, $todate])->get() as $key) {
                    $o_expense = $o_expense + $this->single_payroll_total_pay($key->id);
                }

                $o_expense = round($o_expense, 2);
                $ot_expense = 0;

                foreach (
                    Loan::where('branch_id', $branch)->whereBetween('created_at', [$fromdate, $todate])->where(
                        'status',
                        'disbursed'
                    )->get() as $key
                ) {
                    $ot_expense = $ot_expense + ($key->principal - $this->loan_total_paid($key->id));
                }

                $ot_expense = round($ot_expense, 2);

                $n_income = round(($o_profit - $o_expense - $ot_expense), 2);

                //get loans in that period
                $o_profit = 0;
                foreach (
                    Loan::where('branch_id', $branch)->whereBetween('created_at', [$fromdate, $todate])->where(
                        'status',
                        'disbursed'
                    )->get() as $key
                ) {
                    $o_profit = $o_profit + $this->loan_paid_item(
                        $key->id,
                        'interest',
                        $key->due_date
                    ) + $this->loan_paid_item(
                                $key->id,
                                'fees',
                                $key->due_date
                            ) + $this->loan_paid_item($key->id, 'penalty', $key->due_date);
                }
                $o_profit = round($o_profit + OtherIncome::where('branch_id', $branch)->whereBetween('created_at', [$fromdate, $todate])->sum('amount'), 2);

                $o_expense = Expenses::where('branch_id', $branch)->whereBetween('created_at', [$fromdate, $todate])->sum('amount');

                foreach (Payroll::where('branch_id', $branch)->whereBetween('created_at', [$fromdate, $todate])->get() as $key) {
                    $o_expense = $o_expense + $this->single_payroll_total_pay($key->id);
                }
                $o_expense = round($o_expense, 2);
                $ot_expense = 0;

                foreach (
                    Loan::where('branch_id', $branch)->whereBetween('created_at', [$fromdate, $todate])->where(
                        'status',
                        'disbursed'
                    )->get() as $key
                ) {
                    $ot_expense = $ot_expense + ($key->principal - $this->loan_total_paid($key->id));
                }

                foreach (SavingsTransaction::where('branch_id', $branch)->whereBetween('created_at', [$fromdate, $todate])->where('type', 'interest')->get() as $key) {
                    $ot_expense = $ot_expense + $key->amount;
                }
                // FD INTEREST
                foreach (SavingsTransaction::where('branch_id', $branch)->whereBetween('created_at', [$fromdate, $todate])->where('type', 'fd_interest_expense')->get() as $key) {
                    $ot_expense = $ot_expense + $key->amount;
                }

                $ot_expense = round($ot_expense, 2);

                $n_income = round(($o_profit - $o_expense - $ot_expense), 2);

                $date = date("M Y");

                $monthly_net_income_data = json_encode(array('month' => date("M Y", strtotime(request()->dateto)), 'amount' => $net_profit));
                $monthly_operating_profit_expenses_data = json_encode(array('month' => date("M Y", strtotime(request()->dateto)), 'profit' => $operating_profit, 'expenses' => $operating_expenses));
                $monthly_other_expenses_data = json_encode(array('month' => date("M Y", strtotime(request()->dateto)), 'expenses' => $loan_default));

                return view('reports.profit_loss')->with('incomedata', $monthly_net_income_data)
                    ->with('operating_profit_data', $monthly_operating_profit_expenses_data)
                    ->with('other_expenses_data', $monthly_other_expenses_data)
                    ->with('expenses', $expenses)
                    ->with('payroll', $payroll)
                    ->with('operating_expenses', $operating_expenses)
                    ->with('other_income', $other_income)
                    ->with('bank_fees', $bank_fees)
                    ->with('form_fees', $form_fees)
                    ->with('process_fees', $process_fees)
                    ->with('interest_paid', $interest_paid)
                    ->with('fees_paid', $fees_paid)
                    ->with('penalty_paid', $penalty_paid)
                    ->with('esusu', $esusu)
                    ->with('monthly_charge', $monthly_charge)
                    ->with('transfer_charge', $transfer_charge)
                    ->with('interest_paid', $interest_paid)
                    ->with('operating_profit', $operating_profit)
                    ->with('gross_profit', $gross_profit)
                    ->with('net_profit', $net_profit)
                    ->with('other_expenses', $other_expenses)
                    ->with('inv_interest_expense', $inv_interest_expense)
                    ->with('loan_default', $loan_default)
                    ->with('fd_interest_expense', $fd_interest_expense);
            } else {
                return view('reports.profit_loss');
            }
        } elseif (request()->prfltype == '2') {

            return view('reports.profit_loss2')->with('branch', $branch);
        }
    }

    public function loan_balance()
    {
        $branch = session()->has('branchid') ? session()->get('branchid')['bid'] : Auth::user()->branch_id;

        if (request()->filter == true) {

            $data = Loan::select('id', 'release_date', 'principal', 'customer_id', 'interest_period', 'interest_rate', 'balance', 'override')
                ->whereBetween('disbursed_date', [request()->datefrom, request()->dateto])
                ->where('status', 'disbursed')->get();

            return view('reports.loan_balance')->with('data', $data);
        } else {
            return view('reports.loan_balance');
        }
    }

    public function loan_classification()
    {
        $branch = session()->has('branchid') ? session()->get('branchid')['bid'] : Auth::user()->branch_id;

        if (request()->filter == true) {

            $data = Loan::select('id', 'maturity_date', 'principal', 'customer_id', 'balance', 'override')
                ->where('status', 'disbursed')
                ->whereBetween('disbursed_date', [request()->datefrom, request()->dateto])
                ->get();

            return view('reports.loan_classification')->with('data', $data);
        } else {
            return view('reports.loan_classification');
        }
    }


    public function loan_list()
    {
        $branch = session()->has('branchid') ? session()->get('branchid')['bid'] : Auth::user()->branch_id;

        if (request()->filter == true) {

            if (request()->status == 'all') {

                $alldata = Loan::select('id', 'principal', 'customer_id', 'release_date', 'interest_period', 'interest_rate', 'override', 'balance', 'maturity_date', 'status')
                    ->whereBetween('release_date', [request()->datefrom, request()->dateto])->get();

                return view('reports.loan_list')->with('data', $alldata);
            } else {

                $data = Loan::select('id', 'principal', 'customer_id', 'release_date', 'interest_period', 'interest_rate', 'override', 'balance', 'maturity_date', 'status')
                    ->whereBetween('release_date', [request()->datefrom, request()->dateto])
                    ->where('status', request()->status)->get();

                return view('reports.loan_list')->with('data', $data);
            }
        } else {
            return view('reports.loan_list');
        }
    }

    public function repayment_report()
    {
        $branch = session()->has('branchid') ? session()->get('branchid')['bid'] : Auth::user()->branch_id;

        if (request()->filter == true) {

            $data = LoanSchedule::where('branch_id', $branch)
                ->whereBetween('due_date', [request()->datefrom, request()->dateto])
                ->orderBy('due_date', 'asc')->get();

            return view('reports.repayment')->with('data', $data);
        } else {
            return view('reports.repayment');
        }
    }

    public function loan_transaction()
    {
        $branch = session()->has('branchid') ? session()->get('branchid')['bid'] : Auth::user()->branch_id;

        if (request()->filter == true) {

            $data = LoanRepayment::select('loan_id', 'customer_id', 'user_id', 'collection_date', 'amount', 'repayment_method')
                ->whereBetween('collection_date', [request()->datefrom, request()->dateto])
                ->get();

            return view('reports.loan_repayment_trx')->with('data', $data);
        } else {
            return view('reports.loan_repayment_trx');
        }
    }

    public function chart_of_accounts()
    {
        if (request()->filter == true) {

            $asset = GeneralLedger::with(['savingstrangl'])
                ->where('gl_type', 'asset')
                ->where('account_balance', '!=', 0)
                ->where('status', '1')
                ->get();
            $libility = GeneralLedger::with(['savingstrangl'])
                ->where('gl_type', 'liability')
                ->where('account_balance', '!=', 0)
                ->where('status', '1')
                ->get();
            $capital = GeneralLedger::with(['savingstrangl'])
                ->where('gl_type', 'capital')
                ->where('account_balance', '!=', 0)
                ->where('status', '1')
                ->get();
            $income = GeneralLedger::with(['savingstrangl'])
                ->where('gl_type', 'income')
                ->where('account_balance', '!=', 0)
                ->where('status', '1')
                ->get();
            $expense = GeneralLedger::with(['savingstrangl'])
                ->where('gl_type', 'expense')
                ->where('account_balance', '!=', 0)
                ->where('status', '1')
                ->get();


            return view('reports.chart_of_accounts')->with('data', $asset)
                ->with('datalib', $libility)
                ->with('datacap', $capital)
                ->with('dataincom', $income)
                ->with('dataexp', $expense);
        } else {
            return view('reports.chart_of_accounts');
        }
    }

    public function accounts_mgmt_report()
    {

        $balance = 0;

        if (request()->filter == true) {
            if (empty(request()->fetchby)) {
                return redirect()->back()->with('error', 'search option is required');
            } else {

                if (request()->fetchby == "bygl") {

                    $gl = GeneralLedger::select('id')->where('gl_code', request()->glcode)->first();
                    // dd($gl);
                    if (empty($gl->id)) {

                        return view('reports.accounts_mgmt_report')->with('data', []);
                    } else {

                        $data = SavingsTransactionGL::where('general_ledger_id', $gl->id)
                            ->whereBetween('created_at', [request()->datefrom, request()->dateto])
                            ->get();

                        //return $data;
                        $datasavrts = SavingsTransactionGL::where('general_ledger_id', $gl->id)
                            ->whereDate('created_at', '<=', request()->datefrom)
                            ->orderBy('created_at', 'ASC')
                            ->get();

                        //return $data;
                        foreach ($datasavrts as $key) {
                            if ($key->generalledger->gl_type == "asset") {

                                if ($key->type == "credit") {
                                    if ($key->status == 'approved') {
                                        $balance -= $key->amount;
                                    } else {
                                        $balance;
                                    }
                                } else {
                                    if ($key->status == 'pending' || $key->status == 'declined') {
                                        $balance += 0;
                                    } else {
                                        $balance += $key->amount;
                                    }
                                }
                            } elseif ($key->generalledger->gl_type == "liability") {

                                if ($key->type == "credit") {
                                    if ($key->status == 'approved') {
                                        $balance += $key->amount;
                                    } else {
                                        $balance += 0;
                                    }
                                } else {

                                    if ($key->status == 'pending' || $key->status == 'declined') {
                                        $balance -= 0;
                                    } else {
                                        $balance -= $key->amount;
                                    }
                                }
                            } elseif ($key->generalledger->gl_type == "capital") {

                                if ($key->type == "credit") {
                                    if ($key->status == 'approved') {
                                        $balance += $key->amount;
                                    } else {
                                        $balance += 0;
                                    }
                                } else {
                                    if ($key->status == 'pending' || $key->status == 'declined') {
                                        $balance -= 0;
                                    } else {
                                        $balance -= $key->amount;
                                    }
                                }
                            } elseif ($key->generalledger->gl_type == "income") {

                                if ($key->type == "credit") {
                                    if ($key->status == 'approved') {
                                        $balance += $key->amount;
                                    } else {
                                        $balance += 0;
                                    }
                                } else {
                                    if ($key->status == 'pending' || $key->status == 'declined') {
                                        $balance -= 0;
                                    } else {
                                        $balance -= $key->amount;
                                    }
                                }
                            } elseif ($key->generalledger->gl_type == "expense") {

                                if ($key->type == "credit") {
                                    if ($key->status == 'approved') {
                                        $balance -= $key->amount;
                                    } else {
                                        $balance -= 0;
                                    }
                                } else {
                                    if ($key->status == 'pending' || $key->status == 'declined') {
                                        $balance += 0;
                                    } else {
                                        $balance += $key->amount;
                                    }
                                }
                            }
                            $balance;
                        }

                        return view('reports.accounts_mgmt_report')->with('data', $data)
                            ->with('opbal', $balance)
                            ->with('gl', GeneralLedger::select('gl_name')->where('gl_code', request()->glcode)->first());
                    }
                } elseif (request()->fetchby == "byref") {

                    $data = SavingsTransactionGL::where('reference_no', request()->reference)
                        ->whereBetween('created_at', [request()->datefrom, request()->dateto])
                        ->get();

                    $datasavrts = SavingsTransactionGL::where('reference_no', request()->reference)
                        ->whereDate('created_at', '<=', request()->datefrom)
                        ->orderBy('created_at', 'ASC')
                        ->get();

                    //return $data;
                    foreach ($datasavrts as $key) {
                        if ($key->generalledger->gl_type == "asset") {

                            if ($key->type == "credit") {
                                if ($key->status == 'approved') {
                                    $balance -= $key->amount;
                                } else {
                                    $balance;
                                }
                            } else {
                                if ($key->status == 'pending' || $key->status == 'declined') {
                                    $balance += 0;
                                } else {
                                    $balance += $key->amount;
                                }
                            }
                        } elseif ($key->generalledger->gl_type == "liability") {

                            if ($key->type == "credit") {
                                if ($key->status == 'approved') {
                                    $balance += $key->amount;
                                } else {
                                    $balance += 0;
                                }
                            } else {

                                if ($key->status == 'pending' || $key->status == 'declined') {
                                    $balance -= 0;
                                } else {
                                    $balance -= $key->amount;
                                }
                            }
                        } elseif ($key->generalledger->gl_type == "capital") {

                            if ($key->type == "credit") {
                                if ($key->status == 'approved') {
                                    $balance += $key->amount;
                                } else {
                                    $balance += 0;
                                }
                            } else {
                                if ($key->status == 'pending' || $key->status == 'declined') {
                                    $balance -= 0;
                                } else {
                                    $balance -= $key->amount;
                                }
                            }
                        } elseif ($key->generalledger->gl_type == "income") {

                            if ($key->type == "credit") {
                                if ($key->status == 'approved') {
                                    $balance += $key->amount;
                                } else {
                                    $balance += 0;
                                }
                            } else {
                                if ($key->status == 'pending' || $key->status == 'declined') {
                                    $balance -= 0;
                                } else {
                                    $balance -= $key->amount;
                                }
                            }
                        } elseif ($key->generalledger->gl_type == "expense") {

                            if ($key->type == "credit") {
                                if ($key->status == 'approved') {
                                    $balance -= $key->amount;
                                } else {
                                    $balance -= 0;
                                }
                            } else {
                                if ($key->status == 'pending' || $key->status == 'declined') {
                                    $balance += 0;
                                } else {
                                    $balance += $key->amount;
                                }
                            }
                        }
                        $balance;
                    }

                    return view('reports.accounts_mgmt_report')->with('data', $data)
                        ->with('opbal', $balance);

                    return view('reports.accounts_mgmt_report')->with('data', $data);
                } else {
                    return view('reports.accounts_mgmt_report');
                }
            }
        } else {
            return view('reports.accounts_mgmt_report');
        }
    }

    public function fund_transfer_report()
    {

        if (request()->filter == true) {

            global $fundTrnx;

            $cust = Customer::where('acctno', request()->reference)
                ->orWhere('first_name', request()->reference)
                ->orWhere('last_name', request()->reference)
                ->first();

            $fundTrnx = SavingsTransaction::select('id', 'customer_id', 'type', 'reference_no', 'amount', 'status', 'created_at')
                ->where('customer_id', $cust->id)
                ->where('trnx_type', 'trnsfer')
                ->whereIn('status', ['failed', 'pending'])
                ->whereIn('device', ['Mobile', 'web'])
                ->whereBetween('created_at', [request()->datefrom, request()->dateto])
                ->get();



            return view('reports.fund_transfer')->with('data', $fundTrnx);
        } else {


            $allfndTrnx = SavingsTransaction::select('id', 'customer_id', 'type', 'reference_no', 'amount', 'status', 'created_at')
                ->where('trnx_type', 'trnsfer')
                ->whereIn('status', ['failed', 'pending'])
                ->whereIn('device', ['Mobile', 'web'])
                ->take(2000)
                ->get();

            return view('reports.fund_transfer')->with('data', $allfndTrnx);
        }
    }

    public function updatefund_transfer($id)
    {

        $statuss = request()->staty == '1' ? 'approved' : 'failed';

        $uptns = SavingsTransaction::where('id', $id)->first();

        $uptns->status = $statuss;
        $uptns->save();


        return ['status' => 'success', 'msg' => 'Transaction Updated Successfully'];
    }


    public function vendors_data_report()
    {
        if (request()->filter == true) {
            $succesTrnx = SavingsTransaction::where('trnx_type', 'utility')
                ->whereIn('status', ['approved', 'failed', 'pending', 'decline'])
                ->whereBetween('created_at', [request()->datefrom, request()->dateto])
                ->get();
            return view('reports.utility_data')->with('data', $succesTrnx);
        } else {
            $allTrnx = SavingsTransaction::where('trnx_type', 'utility')
                ->whereIn('status', ['approved', 'failed', 'pending', 'decline'])
                ->get();
            return view('reports.utility_data')->with('data', $allTrnx);
        }
    }


    public function icard_report()
    {
        $customers = Customer::query()
            ->select('first_name', 'last_name', 'email', 'dob', 'phone', 'status', 'account_type', 'bvn', 'created_at', 'id', 'residential_address', 'acctno')
            ->limit(50)->get();

        return view('reports.icard_data', [
            'customers' => $customers
        ]);
    }

    public function icard_report_export(Request $request)
    {
        // EXACT headers from your uploaded template (kept in the same order)
        $headers = [
            'SN',
            'Account Name',
            'Account Number',
            'Date Of Birth',
            'Email',
            'First Name',
            'Middle Name',
            'Last Name',
            'Old Account Number',
            'Phone Number',
            'Account Designation',
            'Account Status',
            'Account Type',
            'BVN',
            'PEP',
            'Sector Type',
            'TIN',
            'Date Opened',
            'User ID',
            'Account Tier',
            'Address',
        ];

        $customers = Customer::query()
            ->select(
                'first_name',
                'last_name',
                'email',
                'dob',
                'phone',
                'status',
                'account_type',
                'bvn',
                'created_at',
                'id',
                'residential_address',
                'acctno'
            )
            ->limit(50)
            ->get();

        $rows = [];
        foreach ($customers as $i => $c) {
            // Build each row to match header keys; use empty string for missing values
            $rows[] = [
                'SN' => $i + 1,
                // Template shows uppercase names; keep it consistent
                'Account Name' => trim(strtoupper($c->last_name ?? '') . ' ' . strtoupper($c->first_name ?? '')),
                'Account Number' => (string) ($c->acctno ?? ''),
                'Date Of Birth' => (string) ($c->dob ?? ''),
                'Email' => (string) ($c->email ?? ''),
                'First Name' => (string) ($c->first_name ?? ''),
                'Middle Name' => '', // not in DB for now
                'Last Name' => (string) ($c->last_name ?? ''),
                'Old Account Number' => '', // not in DB for now
                'Phone Number' => (string) ($c->phone ?? ''),
                'Account Designation' => '', // not in DB for now
                'Account Status' => (string) ($c->status ?? ''),
                'Account Type' => (string) ($c->account_type ?? ''),
                'BVN' => (string) ($c->bvn ?? ''),
                'PEP' => '', // not in DB for now
                'Sector Type' => '', // not in DB for now
                'TIN' => '', // not in DB for now
                'Date Opened' => optional($c->created_at)->format('Y-m-d') ?? '',
                'User ID' => (string) ($c->id ?? ''),
                'Account Tier' => '', // not in DB for now
                'Address' => (string) ($c->residential_address ?? ''),
            ];
        }

        return SimpleExcelWriter::streamDownload('ICAD-Report.xlsx')
            ->addHeader($headers)
            ->addRows($rows)
            ->toBrowser();
    }

    public function ledger_details()
    {
        $tabdata = "";

        if (!empty(request()->ref)) {
            $savingtrx = SavingsTransaction::select('amount', 'type', 'notes', 'customer_id')
                ->where('reference_no', request()->ref)
                ->orWhere('slip', request()->ref)->get();

            $deatails = SavingsTransactionGL::select('type', 'amount', 'notes', 'general_ledger_id')
                ->where('slip', request()->ref)
                ->orWhere('reference_no', request()->ref)->get();


            //  return $deatails;
            foreach ($savingtrx as $deatai) {
                $tabdata .= "<tr>
               <td>" . $deatai->customer->last_name . " " . $deatai->customer->first_name . "</td>
             <td>" . $deatai->customer->acctno . "</td>";
                if ($deatai->type == 'debit' || $deatai->type == 'withdrawal') {
                    $tabdata .= "<td>" . number_format($deatai->amount, 2) . "</td>";
                } else {
                    $tabdata .= "<td></td>";
                }
                if ($deatai->type == 'credit' || $deatai->type == 'deposit' || $deatai->type == "dividend" || $deatai->type == "interest" || $deatai->type == "fixed_deposit" || $deatai->type == "loan" || $deatai->type == "fd_interest" || $deatai->type == "rev_withdrawal" || $deatai->type == 'guarantee_restored') {
                    $tabdata .= "<td>" . number_format($deatai->amount, 2) . "</td>";
                } else {
                    $tabdata .= "<td></td>";
                }
                $tabdata .= "<td>" . $deatai->notes . "</td>
             </tr>";
            }

            foreach ($deatails as $deatai) {
                $tabdata .= "<tr>
               <td>" . $deatai->generalledger->gl_name . "</td>
             <td>" . $deatai->generalledger->gl_code . "</td>";
                if ($deatai->type == 'debit') {
                    $tabdata .= "<td>" . number_format($deatai->amount, 2) . "</td>";
                } else {
                    $tabdata .= "<td></td>";
                }
                if ($deatai->type == 'credit') {
                    $tabdata .= "<td>" . number_format($deatai->amount, 2) . "</td>";
                } else {
                    $tabdata .= "<td></td>";
                }
                $tabdata .= "<td>" . $deatai->notes . "</td>
             </tr>";
            }
            //return $tabdata;
            return ["status" => "success", "msg" => "data fetched", "data" => $tabdata];
        } else {
            return ["status" => "false", "msg" => "No Data Found", "data" => $tabdata];
        }
    }

    public function tsq_report()
    {

        return view('reports.tsq')->with('banks', Bank::orderBy('bank_name', 'ASC')->get());
    }

    public function queryTransactionStatus(Request $r)
    {
        $getsetvalue = new Setting();

        $baseurl = env('APP_MODE') == "test" ? env("TEST_ACCESS_URL") : env("LIVE_ACCESS_URL");

        $token = $this->AccessMiddelware();

        $response = Http::withHeaders([
            "Authorization" => "Bearer " . $token['token'],
            "Accept" => "application/json",
            "Content-Type" => "application/json"
        ])->get($baseurl . "outward/transaction/status/query", [
                    "session_id" => $r->reference,
                    "channel_code" => 1,
                    "source_institution_code" => $r->institution_code
                ])->json();

        $this->logInfo('tsq response', $response);

        //return  dd($response);

        if ($response["data"]["response"]["responseCode"] == "00") {
            return response()->json(["status" => 'success', 'ptype' => "2", "msg" => "Transaction Found Successfully", "data" => ""]);
        } else {
            return response()->json(["status" => false, "msg" => "Transaction not Found"]);
        }

        // if($getsetvalue->getsettingskey('payoption') == '1'){

        //    $response = Http::withHeaders([
        //       "PublicKey" => env('PUBLIC_KEY'),
        //    "EncryptKey" => env('ENCRYPT_KEY'),
        //    "Content-Type" => "application/json"
        //    ])->get(env('ASSETMATRIX_BASE_URL')."query-transaction/settlement",[
        //       'ref' => $r->reference
        //    ])->json();

        //    if($response['status'] == true){
        //       return response()->json(["status" => 'success','ptype' => "1","msg" => "Transaction Found Successfully", "data" => $response['data']]);
        //    }else {
        //          return response()->json(["status" => false, "msg" => "Transaction not Found"]);
        //    }

        // }elseif($getsetvalue->getsettingskey('payoption') == '2'){

        //    $authbasic = base64_encode(env('MONNIFY_LIVE_API_KEY').":".env('MONNIFY_LIVE_SECRET_KEY'));
        //    $response = Http::withHeaders([
        //        "Authorization" => "Basic ".$authbasic,
        //       "Accept" => "application/json",
        //       "Content-Type" => "application/json"
        //    ])->get(env('MONNIFY_LIVE_URL')."v1/transactions/search",[
        //       "paymentReference" => $r->reference
        //    ])->json();


        //    if($response["responseCode"] == "0" || $response["requestSuccessful"] == true){
        //       return response()->json(["status" => 'success','ptype' => "2","msg" => "Transaction Found Successfully", "data" => $response["responseBody"]["content"]]);
        //   }else {
        //       return response()->json(["status" => false, "msg" => "Transaction not Found"]);
        //   }

        // }elseif($getsetvalue->getsettingskey('payoption') == '4'){

        //    $response = Http::withHeaders([
        //        "Api-Key" => env('WIRELESS_API_KEY'),
        //     "Accept" => "application/json"
        //     ])->post("https://backup.wirelessbeta.com/api/v1/tsq-reference-number",[
        //       "transaction_reference" => $r->reference
        //    ])->json();

        //   //return $response;
        //    if($response['status'] == "success"){
        //          return response()->json(["status" => 'success', 'ptype' => "4", "msg" => "Transaction Found Successfully", "data" => ['status' => $response['status'],'message' => $response['message']]]);
        //    }else {
        //          return response()->json(["status" => false, "msg" => "Transaction not Found"]);
        //    }
        // }

    }

    public function nibss_log()
    {

        $nibslog = NibssLog::select('customer_id', 'customer_name', 'account_number', 'amount', 'reference_no', 'session_id', 'note', 'type', 'created_at')
            ->orderBy('id', 'DESC')
            ->get();

        return view('reports.nibsslog')->with('nibs', $nibslog);
    }

    public function GetcurrencyExchge($currencyid)
    {
        $exghcg = Exchangerate::where('id', $currencyid)->orderBy('created_at', 'DESC')->first();
        return $exghcg->currency_symbol;
    }

    public function cbn_returns_report()
    {

        return view('reports.cbn_reports');
    }




    public function generate_cbn_report(Request $r)
    {
        @set_time_limit(300);
        @ini_set('memory_limit', '1024M');

        $TRIM_DIVISOR = 1000;
        $fmt = static function ($v) use ($TRIM_DIVISOR) {
            if ($v === null)
                return 0;
            if (!is_numeric($v))
                $v = (int) preg_replace('/\D/', '', (string) $v);
            return (int) intdiv((int) $v, max(1, (int) $TRIM_DIVISOR));
        };

        $reportDate = Carbon::parse($r->reporting_date);
        $startMonth = $reportDate->copy()->startOfMonth();
        $startYear = $reportDate->copy()->startOfYear();

        $filename = public_path('csv/cbnreturn.xlsx');
        $reader = IOFactory::createReader('Xlsx');
        $reader->setReadDataOnly(true);
        $spreadsheet = $reader->load($filename);
        Calculation::getInstance($spreadsheet)->setCalculationCacheEnabled(false);

        $needGlCodes = [
            'vault' => '10373391',
            'treasury_bills' => '10525945',
            'micro_loans' => '10739869',
            'sme' => '10156223',
            'staff_loan' => '10156223', // TODO: replace with the correct STAFF loan GL code if different
            'bldg_purchase' => '10502088',
            'bldg_lease' => '10465194',
            'plant' => '10280383',
            'furniture' => '10968173',
            'motor' => '10815485',
            'office' => '10661678',
            'capital_shares' => '30488648',
            'voluntary_current' => '20639526',
            'voluntary_savings' => '20993097',
            'fixed_deposit' => '20944548',
            'loan_interest_income' => '40248362',
            'fd_interest_expense' => '50249457',
        ];

        $glRows = GeneralLedger::select('id', 'gl_code', 'gl_name', 'account_category_id', 'account_balance')
            ->where('status', 1)
            ->whereIn('gl_code', array_values($needGlCodes))
            ->get();

        $glByCode = $glRows->keyBy('gl_code');
        $gl = [];
        foreach ($needGlCodes as $key => $code) {
            $gl[$key] = $glByCode->has($code) ? $glByCode[$code] : null;
        }

        $accumIds = GeneralLedger::where('status', 1)->where('account_category_id', 7)->pluck('id')->all();
        $feesIds = GeneralLedger::where('status', 1)->where('account_category_id', 36)->pluck('id')->all();
        $commIds = GeneralLedger::where('status', 1)->where('account_category_id', 20)->pluck('id')->all();
        $staffIds = GeneralLedger::where('status', 1)->where('account_category_id', 106)->pluck('id')->all();
        $ovhIds = GeneralLedger::where('status', 1)->where('account_category_id', 81)->pluck('id')->all();

        $dueFromBanks = GeneralLedger::select('id', 'gl_name', 'account_balance')
            ->where('status', 1)
            ->where('account_category_id', 32)
            ->get();

        $monthGlIds = collect([
            $gl['vault']?->id,
            $gl['treasury_bills']?->id,
            $gl['micro_loans']?->id,
            $gl['sme']?->id,
            $gl['staff_loan']?->id,
            $gl['bldg_purchase']?->id,
            $gl['bldg_lease']?->id,
            $gl['plant']?->id,
            $gl['furniture']?->id,
            $gl['motor']?->id,
            $gl['office']?->id,
            $gl['capital_shares']?->id,
            $gl['voluntary_current']?->id,
            $gl['voluntary_savings']?->id,
            $gl['fixed_deposit']?->id,
            $gl['loan_interest_income']?->id,
            $gl['fd_interest_expense']?->id,
        ])->filter()->values()->all();

        $monthGlSums = SavingsTransactionGL::select(
            'general_ledger_id',
            'type',
            DB::raw('SUM(amount) as total')
        )
            ->whereIn('general_ledger_id', $monthGlIds)
            ->where('status', 'approved')
            ->whereBetween('created_at', [$startMonth, $reportDate])
            ->groupBy('general_ledger_id', 'type')
            ->get()
            ->groupBy('general_ledger_id');

        $getMonthSum = static function ($glId, $type) use ($monthGlSums) {
            if (!$glId)
                return 0;
            $rows = $monthGlSums->get($glId);
            if (!$rows)
                return 0;
            foreach ($rows as $r) {
                if ($r->type === $type)
                    return (int) $r->total;
            }
            return 0;
        };

        $yearCatIds = array_merge($accumIds, $feesIds, $commIds, $staffIds, $ovhIds);
        $yearCatSums = [];
        if (!empty($yearCatIds)) {
            $yearCatSums = SavingsTransactionGL::select(
                'general_ledger_id',
                'type',
                DB::raw('SUM(amount) as total')
            )
                ->whereIn('general_ledger_id', $yearCatIds)
                ->where('status', 'approved')
                ->whereBetween('created_at', [$startYear, $reportDate])
                ->groupBy('general_ledger_id', 'type')
                ->get()
                ->groupBy('general_ledger_id');
        }

        $getYearCatSumSet = static function (array $ids, $type) use ($yearCatSums) {
            if (empty($ids))
                return 0;
            $sum = 0;
            foreach ($ids as $id) {
                $rows = $yearCatSums[$id] ?? null;
                if (!$rows)
                    continue;
                foreach ($rows as $r) {
                    if ($r->type === $type) {
                        $sum += (int) $r->total;
                        break;
                    }
                }
            }
            return $sum;
        };

        $month = $reportDate->format('m');

        $loanMonthAgg = Loan::select(
            DB::raw("SUM(CASE WHEN status='disbursed' AND DATE_FORMAT(created_at,'%m') = ? THEN 1 ELSE 0 END) as totloan"),
            DB::raw("SUM(CASE WHEN status='disbursed' AND DATE_FORMAT(created_at,'%m') = ? AND EXISTS (SELECT 1 FROM customers c WHERE c.id=loans.customer_id AND c.gender='female') THEN 1 ELSE 0 END) as floan"),
            DB::raw("SUM(CASE WHEN status='disbursed' AND DATE_FORMAT(created_at,'%m') = ? AND EXISTS (SELECT 1 FROM customers c WHERE c.id=loans.customer_id AND c.gender='male') THEN 1 ELSE 0 END) as mloan"),
            DB::raw("SUM(CASE WHEN status='disbursed' AND DATE_FORMAT(created_at,'%m') = ? THEN principal ELSE 0 END) as totloanamt")
        )
            ->addBinding([$month, $month, $month, $month], 'select')
            ->first();

        $totloandisbur = Loan::where('status', 'disbursed')->count();

        $cumAgg = Loan::select(
            DB::raw("SUM(CASE WHEN status='disbursed' AND created_at BETWEEN ? AND ? THEN 1 ELSE 0 END) as cumtotloan"),
            DB::raw("SUM(CASE WHEN status='disbursed' AND created_at BETWEEN ? AND ? THEN principal ELSE 0 END) as cumtotloanamt")
        )
            ->addBinding([$startYear, $reportDate, $startYear, $reportDate], 'select')
            ->first();

        $genderCumCounts = Customer::select(
            DB::raw("SUM(CASE WHEN gender='female' AND created_at BETWEEN ? AND ? THEN 1 ELSE 0 END) as fcummuloan"),
            DB::raw("SUM(CASE WHEN gender='male'   AND created_at BETWEEN ? AND ? THEN 1 ELSE 0 END) as mcummuloan")
        )
            ->addBinding([$startYear, $reportDate, $startYear, $reportDate], 'select')
            ->first();

        $dropMonth = Customer::select(
            DB::raw("SUM(CASE WHEN gender='female' AND status='2' AND DATE_FORMAT(created_at,'%m') = ? THEN 1 ELSE 0 END) as femaledropout"),
            DB::raw("SUM(CASE WHEN gender='male'   AND status='2' AND DATE_FORMAT(created_at,'%m') = ? THEN 1 ELSE 0 END) as maledropout")
        )
            ->addBinding([$month, $month], 'select')
            ->first();

        $dropCum = Customer::select(
            DB::raw("SUM(CASE WHEN gender='female' AND status='2' AND created_at BETWEEN ? AND ? THEN 1 ELSE 0 END) as femaledropoutcumm"),
            DB::raw("SUM(CASE WHEN gender='male'   AND status='2' AND created_at BETWEEN ? AND ? THEN 1 ELSE 0 END) as maledropoutcumm")
        )
            ->addBinding([$startYear, $reportDate, $startYear, $reportDate], 'select')
            ->first();

        $depMonth = Customer::select(
            DB::raw("SUM(CASE WHEN gender='female' AND status IN ('1','4','7') AND DATE_FORMAT(created_at,'%m') = ? THEN 1 ELSE 0 END) as femaledepositors"),
            DB::raw("SUM(CASE WHEN gender='male'   AND status IN ('1','4','7') AND DATE_FORMAT(created_at,'%m') = ? THEN 1 ELSE 0 END) as maledepositors")
        )
            ->addBinding([$month, $month], 'select')
            ->first();

        $femaleIdsDrop = Customer::where('gender', 'female')->where('status', '2')->pluck('id')->all();
        $maleIdsDrop = Customer::where('gender', 'male')->where('status', '2')->pluck('id')->all();

        $dropMonthSums = [
            'f_cr' => empty($femaleIdsDrop) ? 0 : SavingsTransaction::whereIn('customer_id', $femaleIdsDrop)
                ->whereIn('type', ["deposit", "credit", "dividend", "interest", "fixed_deposit", "loan", "fd_interest", "rev_withdrawal", "guarantee_restored"])
                ->where('status', 'approved')
                ->whereBetween('created_at', [$startMonth, $reportDate])
                ->sum('amount'),
            'f_db' => empty($femaleIdsDrop) ? 0 : SavingsTransaction::whereIn('customer_id', $femaleIdsDrop)
                ->whereIn('type', ["rev_fixed_deposit", "withdrawal", "monthly_charge", "debit", "repayment", "transfer_charge"])
                ->where('status', 'approved')
                ->whereBetween('created_at', [$startMonth, $reportDate])
                ->sum('amount'),
            'm_cr' => empty($maleIdsDrop) ? 0 : SavingsTransaction::whereIn('customer_id', $maleIdsDrop)
                ->whereIn('type', ["deposit", "credit", "dividend", "interest", "fixed_deposit", "loan", "fd_interest", "rev_withdrawal", "guarantee_restored"])
                ->where('status', 'approved')
                ->whereBetween('created_at', [$startMonth, $reportDate])
                ->sum('amount'),
            'm_db' => empty($maleIdsDrop) ? 0 : SavingsTransaction::whereIn('customer_id', $maleIdsDrop)
                ->whereIn('type', ["rev_fixed_deposit", "withdrawal", "monthly_charge", "debit", "repayment", "transfer_charge"])
                ->where('status', 'approved')
                ->whereBetween('created_at', [$startMonth, $reportDate])
                ->sum('amount'),
        ];

        $femaleIdsDep = Customer::where('gender', 'female')->whereIn('status', ['1', '4', '7'])->pluck('id')->all();
        $maleIdsDep = Customer::where('gender', 'male')->whereIn('status', ['1', '4', '7'])->pluck('id')->all();

        $depMonthSums = [
            'f' => empty($femaleIdsDep) ? 0 : SavingsTransaction::whereIn('customer_id', $femaleIdsDep)
                ->whereIn('type', ["deposit", "credit", "dividend", "interest", "fixed_deposit", "loan", "fd_interest", "rev_withdrawal", "guarantee_restored"])
                ->where('status', 'approved')
                ->whereBetween('created_at', [$startMonth, $reportDate])
                ->sum('amount'),
            'm' => empty($maleIdsDep) ? 0 : SavingsTransaction::whereIn('customer_id', $maleIdsDep)
                ->whereIn('type', ["deposit", "credit", "dividend", "interest", "fixed_deposit", "loan", "fd_interest", "rev_withdrawal", "guarantee_restored"])
                ->where('status', 'approved')
                ->whereBetween('created_at', [$startMonth, $reportDate])
                ->sum('amount'),
        ];

        $femaleDropSavSum = empty($femaleIdsDrop) ? 0 : Saving::whereIn('customer_id', $femaleIdsDrop)->sum('account_balance');
        $maleDropSavSum = empty($maleIdsDrop) ? 0 : Saving::whereIn('customer_id', $maleIdsDrop)->sum('account_balance');

        $femaleDepSavSum = empty($femaleIdsDep) ? 0 : Saving::whereIn('customer_id', $femaleIdsDep)->sum('account_balance');
        $maleDepSavSum = empty($maleIdsDep) ? 0 : Saving::whereIn('customer_id', $maleIdsDep)->sum('account_balance');

        $savingAgg = Saving::select(
            DB::raw("SUM(CASE WHEN savings_product_id=1 AND account_balance BETWEEN 1 AND 100000 AND created_at BETWEEN ? AND ? THEN 1 ELSE 0 END) as totnumsaving100"),
            DB::raw("SUM(CASE WHEN savings_product_id=1 AND account_balance BETWEEN 1 AND 100000 AND created_at BETWEEN ? AND ? THEN account_balance ELSE 0 END) as totamountsaving100"),
            DB::raw("SUM(CASE WHEN savings_product_id=1 AND account_balance >= 101000 AND created_at BETWEEN ? AND ? THEN 1 ELSE 0 END) as totnumsavingsabve100"),
            DB::raw("SUM(CASE WHEN savings_product_id=1 AND account_balance >= 1 AND created_at BETWEEN ? AND ? THEN account_balance ELSE 0 END) as totamountsavingabve100"),
            DB::raw("SUM(CASE WHEN savings_product_id=2 AND account_balance BETWEEN 1 AND 100000 AND created_at BETWEEN ? AND ? THEN 1 ELSE 0 END) as totnumcurrent100"),
            DB::raw("SUM(CASE WHEN savings_product_id=2 AND account_balance BETWEEN 1 AND 100000 AND created_at BETWEEN ? AND ? THEN account_balance ELSE 0 END) as totamountcurrent100"),
            DB::raw("SUM(CASE WHEN savings_product_id=2 AND account_balance >= 101000 AND created_at BETWEEN ? AND ? THEN 1 ELSE 0 END) as totnumcurrentabve100"),
            DB::raw("SUM(CASE WHEN savings_product_id=2 AND account_balance >= 101000 AND created_at BETWEEN ? AND ? THEN account_balance ELSE 0 END) as totamountcurrentabove100")
        )
            ->addBinding([$startMonth, $reportDate, $startMonth, $reportDate, $startMonth, $reportDate, $startMonth, $reportDate, $startMonth, $reportDate, $startMonth, $reportDate, $startMonth, $reportDate, $startMonth, $reportDate], 'select')
            ->first();

        $fdAgg = FixedDeposit::select(
            DB::raw("SUM(CASE WHEN principal BETWEEN 1 AND 100000 AND created_at BETWEEN ? AND ? THEN 1 ELSE 0 END) as numfixeddeposits100"),
            DB::raw("SUM(CASE WHEN principal BETWEEN 1 AND 100000 AND created_at BETWEEN ? AND ? THEN principal ELSE 0 END) as amtfixeddeposits100"),
            DB::raw("SUM(CASE WHEN principal >= 101000 AND created_at BETWEEN ? AND ? THEN 1 ELSE 0 END) as numfixeddepositsabove100"),
            DB::raw("SUM(CASE WHEN principal >= 101000 AND created_at BETWEEN ? AND ? THEN principal ELSE 0 END) as amtfixeddepositsabove100")
        )
            ->addBinding([$startMonth, $reportDate, $startMonth, $reportDate, $startMonth, $reportDate, $startMonth, $reportDate], 'select')
            ->first();

        $ascrtrnx = $getMonthSum($gl['vault']?->id, 'credit');
        $asdbtrnx = $getMonthSum($gl['vault']?->id, 'debit');

        $trecrtrnx = $getMonthSum($gl['treasury_bills']?->id, 'credit');
        $tredbtrnx = $getMonthSum($gl['treasury_bills']?->id, 'debit');

        $miccrtrnx = $getMonthSum($gl['micro_loans']?->id, 'credit');
        $micdbtrnx = $getMonthSum($gl['micro_loans']?->id, 'debit');

        $smecrtrnx = $getMonthSum($gl['sme']?->id, 'credit');
        $smedbtrnx = $getMonthSum($gl['sme']?->id, 'debit');

        $staffcrtrnx = $getMonthSum($gl['staff_loan']?->id, 'credit');
        $staffdbtrnx = $getMonthSum($gl['staff_loan']?->id, 'debit');

        $bpurcrtrnx = $getMonthSum($gl['bldg_purchase']?->id, 'credit');
        $bpurdbtrnx = $getMonthSum($gl['bldg_purchase']?->id, 'debit');

        $bleasecrtrnx = $getMonthSum($gl['bldg_lease']?->id, 'credit');
        $bleasedbtrnx = $getMonthSum($gl['bldg_lease']?->id, 'debit');

        $plantcrtrnx = $getMonthSum($gl['plant']?->id, 'credit');
        $plantdbtrnx = $getMonthSum($gl['plant']?->id, 'debit');

        $furnicrtrnx = $getMonthSum($gl['furniture']?->id, 'credit');
        $furnidbtrnx = $getMonthSum($gl['furniture']?->id, 'debit');

        $motocrtrnx = $getMonthSum($gl['motor']?->id, 'credit');
        $motodbtrnx = $getMonthSum($gl['motor']?->id, 'debit');

        $offccrtrnx = $getMonthSum($gl['office']?->id, 'credit');
        $offcdbtrnx = $getMonthSum($gl['office']?->id, 'debit');

        $accumcrtrnx = $getYearCatSumSet($accumIds, 'credit');
        $accumdbtrnx = $getYearCatSumSet($accumIds, 'debit');

        $voluncrtrnx = $getMonthSum($gl['voluntary_current']?->id, 'credit') + $getMonthSum($gl['voluntary_savings']?->id, 'credit');
        $volundbtrnx = $getMonthSum($gl['voluntary_current']?->id, 'debit') + $getMonthSum($gl['voluntary_savings']?->id, 'debit');

        $sharescrtrnx = $getMonthSum($gl['capital_shares']?->id, 'credit');
        $sharesdbtrnx = $getMonthSum($gl['capital_shares']?->id, 'debit');

        $fixeddpocrtrnx = $getMonthSum($gl['fixed_deposit']?->id, 'credit');
        $fixeddpodbtrnx = $getMonthSum($gl['fixed_deposit']?->id, 'debit');

        $loanintrincmcrtrnx = $getMonthSum($gl['loan_interest_income']?->id, 'credit');
        $loanintrincmdbtrnx = $getMonthSum($gl['loan_interest_income']?->id, 'debit');

        $fixeddpointrexpcrtrnx = $getMonthSum($gl['fd_interest_expense']?->id, 'credit');
        $fixeddpointrexpdbtrnx = $getMonthSum($gl['fd_interest_expense']?->id, 'debit');

        $feesncgrcrtrnx = $getYearCatSumSet($feesIds, 'credit');
        $feesncgrdbtrnx = $getYearCatSumSet($feesIds, 'debit');

        $commisncrtrnx = $getYearCatSumSet($commIds, 'credit');
        $commisndbtrnx = $getYearCatSumSet($commIds, 'debit');

        $sfcostscrtrnx = $getYearCatSumSet($staffIds, 'credit');
        $sfcostsdbtrnx = $getYearCatSumSet($staffIds, 'debit');

        $ovrheadscrtrnx = $getYearCatSumSet($ovhIds, 'credit');
        $ovrheadsdbtrnx = $getYearCatSumSet($ovhIds, 'debit');

        $terbills = $tredbtrnx - $trecrtrnx;
        $cashasst = $asdbtrnx - $ascrtrnx;
        $microasst = $micdbtrnx - $miccrtrnx;
        $smeasst = $smedbtrnx - $smecrtrnx;
        $staffasst = $staffdbtrnx - $staffcrtrnx;
        $freehold = $bpurdbtrnx - $bpurcrtrnx;
        $lease = $bleasedbtrnx - $bleasecrtrnx;
        $plant = $plantdbtrnx - $plantcrtrnx;
        $furni = $furnidbtrnx - $furnicrtrnx;
        $moto = $motodbtrnx - $motocrtrnx;
        $office = $offcdbtrnx - $offccrtrnx;
        $accumdepre = $accumdbtrnx - $accumcrtrnx;
        $voluntarysav = $voluncrtrnx - $volundbtrnx;
        $ordinshares = $sharescrtrnx - $sharesdbtrnx;
        $fixeddepo = $fixeddpocrtrnx - $fixeddpodbtrnx;
        $feesandchargs = $feesncgrcrtrnx - $feesncgrdbtrnx;
        $intrincome = $loanintrincmcrtrnx - $loanintrincmdbtrnx;
        $intrexpens = $fixeddpointrexpdbtrnx - $fixeddpointrexpcrtrnx;
        $commission = $commisncrtrnx - $commisndbtrnx;
        $staffcost = $sfcostsdbtrnx - $sfcostscrtrnx;
        $ovheads = $ovrheadsdbtrnx - $ovrheadscrtrnx;
        $dropoutcummufemale = $dropMonthSums['f_cr'] - $dropMonthSums['f_db'];
        $dropoutcummumale = $dropMonthSums['m_cr'] - $dropMonthSums['m_db'];
        $totmloan = $microasst + $smeasst;

        $sheet0 = $spreadsheet->getSheet(0);
        $sheet0->getCell('B114')->setValue($r->md_name);
        $sheet0->getCell('B115')->setValue($r->md_phone);
        $sheet0->getCell('B117')->setValue($r->bank_email);
        $sheet0->getCell('C1')->setValue($r->bank_code);
        $sheet0->getCell('C2')->setValue($r->bank_name);
        $sheet0->getCell('C5')->setValue($reportDate->format('d/m/Y'));
        $sheet0->getCell('C6')->setValue($r->state);
        $sheet0->getCell('C7')->setValue($r->state_code);
        $sheet0->getCell('C8')->setValue($r->lga);
        $sheet0->getCell('C9')->setValue($r->lga_code);
        $sheet0->getCell('D15')->setValue($fmt($cashasst));
        $sheet0->getCell('D27')->setValue($fmt($terbills));
        $sheet0->getCell('D36')->setValue($fmt($smeasst));
        $sheet0->getCell('D41')->setValue($fmt($staffasst));
        $sheet0->getCell('D52')->setValue($fmt($freehold));
        $sheet0->getCell('D53')->setValue($fmt($lease));
        $sheet0->getCell('D54')->setValue($fmt($plant));
        $sheet0->getCell('D55')->setValue($fmt($furni));
        $sheet0->getCell('D56')->setValue($fmt($moto));
        $sheet0->getCell('D57')->setValue($fmt($office));
        $sheet0->getCell('D59')->setValue($fmt($accumdepre));
        $sheet0->getCell('D67')->setValue($fmt($voluntarysav));
        $sheet0->getCell('D68')->setValue($fmt($fixeddepo));
        $sheet0->getCell('D89')->setValue($fmt($ordinshares));
        $sheet0->getCell('D91')->setValue($fmt($ordinshares));
        $sheet0->getCell('E114')->setValue($r->co_name);
        $sheet0->getCell('E115')->setValue($r->co_phone);

        $sheet1 = $spreadsheet->getSheet(1);
        $sheet1->getCell('D14')->setValue($fmt($intrincome));
        $sheet1->getCell('D15')->setValue($fmt($intrexpens));
        $sheet1->getCell('D18')->setValue($fmt($commission));
        $sheet1->getCell('D19')->setValue($fmt($feesandchargs));
        $sheet1->getCell('D25')->setValue($fmt($staffcost));
        $sheet1->getCell('D27')->setValue(0);
        $sheet1->getCell('D31')->setValue($fmt($ovheads));

        $sheet2 = $spreadsheet->getSheet(2);
        $sheet2->getCell('C13')->setValue((int) $loanMonthAgg->totloan);
        $sheet2->getCell('C15')->setValue((int) $loanMonthAgg->floan);
        $sheet2->getCell('C16')->setValue((int) $loanMonthAgg->mloan);
        $sheet2->getCell('C18')->setValue((int) $dropMonth->femaledropout);
        $sheet2->getCell('C19')->setValue((int) $dropMonth->maledropout);
        $sheet2->getCell('C21')->setValue((int) $depMonth->femaledepositors);
        $sheet2->getCell('C22')->setValue((int) $depMonth->maledepositors);
        $sheet2->getCell('C24')->setValue($r->male_senior);
        $sheet2->getCell('C25')->setValue($r->male_junior);
        $sheet2->getCell('C27')->setValue($r->loan_officer);
        $sheet2->getCell('C28')->setValue($r->male_resign);
        $sheet2->getCell('C29')->setValue($r->male_recruit);
        $sheet2->getCell('C30')->setValue($r->cbn_ndic);
        $sheet2->getCell('C31')->setValue($r->recommended_provision);
        $sheet2->getCell('C32')->setValue($r->financial_year_end);
        $sheet2->getCell('C34')->setValue($r->list_branch);
        $sheet2->getCell('C35')->setValue($r->new_branch);
        $sheet2->getCell('C36')->setValue($r->closed_branch);
        $sheet2->getCell('C37')->setValue($r->cash_center);
        $sheet2->getCell('C38')->setValue($r->meet_point);

        $sheet2->getCell('D13')->setValue($fmt((int) $loanMonthAgg->totloanamt));
        $sheet2->getCell('D15')->setValue($fmt((int) (
            Loan::where('status', 'disbursed')->whereMonth('created_at', $month)
                ->whereHas('customer', fn($q) => $q->where('gender', 'female'))->sum('principal')
        )));
        $sheet2->getCell('D16')->setValue($fmt((int) (
            Loan::where('status', 'disbursed')->whereMonth('created_at', $month)
                ->whereHas('customer', fn($q) => $q->where('gender', 'male'))->sum('principal')
        )));
        $sheet2->getCell('D18')->setValue($fmt($femaleDropSavSum));
        $sheet2->getCell('D19')->setValue($fmt($maleDropSavSum));
        $sheet2->getCell('D21')->setValue($fmt($femaleDepSavSum));
        $sheet2->getCell('D22')->setValue($fmt($maleDepSavSum));
        $sheet2->getCell('D24')->setValue($r->female_senior);
        $sheet2->getCell('D25')->setValue($r->female_junior);
        $sheet2->getCell('D28')->setValue($r->female_resign);
        $sheet2->getCell('D29')->setValue($r->female_recruit);

        $sheet2->getCell('E13')->setValue((int) $cumAgg->cumtotloan);
        $sheet2->getCell('E15')->setValue((int) $genderCumCounts->fcummuloan);
        $sheet2->getCell('E16')->setValue((int) $genderCumCounts->mcummuloan);
        $sheet2->getCell('E18')->setValue((int) $dropCum->femaledropoutcumm);
        $sheet2->getCell('E19')->setValue((int) $dropCum->maledropoutcumm);
        $sheet2->getCell('E24')->setValue($r->cum_male_senior);
        $sheet2->getCell('E25')->setValue($r->cum_male_junior);
        $sheet2->getCell('E28')->setValue($r->cum_male_resign);
        $sheet2->getCell('E29')->setValue($r->cum_male_recruit);

        $sheet2->getCell('F13')->setValue($fmt((int) $cumAgg->cumtotloanamt));
        $sheet2->getCell('F15')->setValue($fmt((int) (
            Loan::where('status', 'disbursed')->whereBetween('created_at', [$startYear, $reportDate])
                ->whereHas('customer', fn($q) => $q->where('gender', 'female'))->sum('principal')
        )));
        $sheet2->getCell('F16')->setValue($fmt((int) (
            Loan::where('status', 'disbursed')->whereBetween('created_at', [$startYear, $reportDate])
                ->whereHas('customer', fn($q) => $q->where('gender', 'male'))->sum('principal')
        )));
        $sheet2->getCell('F18')->setValue($fmt($dropoutcummufemale));
        $sheet2->getCell('F19')->setValue($fmt($dropoutcummumale));
        $sheet2->getCell('F21')->setValue($fmt($depMonthSums['f']));
        $sheet2->getCell('F22')->setValue($fmt($depMonthSums['m']));
        $sheet2->getCell('F28')->setValue($r->cum_female_resign);
        $sheet2->getCell('F24')->setValue($r->cum_female_senior);
        $sheet2->getCell('F25')->setValue($r->cum_female_junior);
        $sheet2->getCell('F29')->setValue($r->cum_female_recruit);

        $sheet3 = $spreadsheet->getSheet(3);
        $currentcontentrow = 13;
        foreach ($dueFromBanks as $dfb) {
            $sheet3->getCell('A' . $currentcontentrow)->setValue("");
            $sheet3->getCell('B' . $currentcontentrow)->setValue(ucwords($dfb->gl_name));
            $sheet3->getCell('D' . $currentcontentrow)->setValue($fmt($dfb->account_balance));
            $currentcontentrow++;
        }

        $sheet7 = $spreadsheet->getSheet(7);
        $sheet7->getCell('C12')->setValue((int) $totloandisbur);
        $sheet7->getCell('D12')->setValue($fmt($totmloan));

        $sheet9 = $spreadsheet->getSheet(9);
        $prformin = Loan::where("status", "disbursed")
            ->where("provision_type", "performing")
            ->whereBetween('created_at', [$startYear, $reportDate])
            ->sum("provision_amount");
        $sheet9->getCell('D12')->setValue($fmt($prformin));

        $loansproves = Loan::with(['customer:id,first_name,last_name'])
            ->select('id', 'loan_code', 'customer_id', 'maturity_date', 'principal', 'provision_type', 'provision_amount')
            ->where("status", "disbursed")
            ->whereBetween('created_at', [$startYear, $reportDate])
            ->get();

        $sheet10 = $spreadsheet->getSheet(10);
        $loancontentrow = 20;
        $sn = 0;
        foreach ($loansproves as $lp) {
            $sheet10->getCell('A' . $loancontentrow)->setValue(++$sn);
            $sheet10->getCell('B' . $loancontentrow)->setValue($lp->loan_code);
            $sheet10->getCell('C' . $loancontentrow)->setValue(ucwords(($lp->customer->last_name ?? '') . ' ' . ($lp->customer->first_name ?? '')));
            $sheet10->getCell('D' . $loancontentrow)->setValue(date("m/d/Y", strtotime($lp->maturity_date)));
            $sheet10->getCell('E' . $loancontentrow)->setValue(date("m/d/Y", strtotime($lp->maturity_date)));
            $sheet10->getCell('F' . $loancontentrow)->setValue($fmt($lp->principal));
            $sheet10->getCell('G' . $loancontentrow)->setValue($fmt($this->loan_paid_item($lp->id)));
            $sheet10->getCell('H' . $loancontentrow)->setValue($fmt($this->loan_interest_paid_item($lp->id)));
            $sheet10->getCell('J' . $loancontentrow)->setValue($lp->provision_type === "pass & watch" ? $fmt($lp->provision_amount) : "");
            $sheet10->getCell('K' . $loancontentrow)->setValue($lp->provision_type === "substandard" ? $fmt($lp->provision_amount) : "");
            $sheet10->getCell('L' . $loancontentrow)->setValue($lp->provision_type === "doubtful" ? $fmt($lp->provision_amount) : "");
            $sheet10->getCell('M' . $loancontentrow)->setValue($lp->provision_type === "lost" ? $fmt($lp->provision_amount) : "");
            $loancontentrow++;
        }

        $sheet11 = $spreadsheet->getSheet(11);
        $seccontentrow = 12;
        $sectorsAgg = Loan::select('sector_id', DB::raw('COUNT(*) as cnt'), DB::raw('SUM(principal) as sum_principal'))
            ->whereNotNull('sector_id')
            ->groupBy('sector_id')
            ->pluck('sum_principal', 'sector_id')
            ->toArray();

        $sectorsCnt = Loan::select('sector_id', DB::raw('COUNT(*) as cnt'))
            ->whereNotNull('sector_id')
            ->groupBy('sector_id')
            ->pluck('cnt', 'sector_id')
            ->toArray();

        $sectors = Sector::select('id', 'sector')->get();
        foreach ($sectors as $secto) {
            $sheet11->getCell('A' . $seccontentrow)->setValue($secto->sector);
            $sheet11->getCell('C' . $seccontentrow)->setValue((int) ($sectorsCnt[$secto->id] ?? 0));
            $sheet11->getCell('D' . $seccontentrow)->setValue($fmt((int) ($sectorsAgg[$secto->id] ?? 0)));
            $seccontentrow++;
        }

        $sheet17 = $spreadsheet->getSheet(17);
        $sheet17->getCell('D14')->setValue((int) $savingAgg->totnumcurrent100);
        $sheet17->getCell('D15')->setValue($fmt((int) $savingAgg->totamountcurrent100));
        $sheet17->getCell('D17')->setValue((int) $savingAgg->totnumsaving100);
        $sheet17->getCell('D18')->setValue($fmt((int) $savingAgg->totamountsaving100));
        $sheet17->getCell('D20')->setValue((int) $fdAgg->numfixeddeposits100);
        $sheet17->getCell('D21')->setValue($fmt((int) $fdAgg->amtfixeddeposits100));

        $sheet17->getCell('E14')->setValue((int) $savingAgg->totnumcurrentabve100);
        $sheet17->getCell('E15')->setValue($fmt((int) $savingAgg->totamountcurrentabove100));
        $sheet17->getCell('E17')->setValue((int) $savingAgg->totnumsavingsabve100);
        $sheet17->getCell('E18')->setValue($fmt((int) $savingAgg->totamountsavingabve100));
        $sheet17->getCell('E20')->setValue((int) $fdAgg->numfixeddepositsabove100);
        $sheet17->getCell('E21')->setValue($fmt((int) $fdAgg->amtfixeddepositsabove100));

        $writer = IOFactory::createWriter($spreadsheet, 'Xlsx');
        $writer->setPreCalculateFormulas(false);

        if (ob_get_length()) {
            @ob_end_clean();
        }
        $nfilename = "cbn_reports_" . date("Y_m_d");
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment; filename="' . $nfilename . '.xlsx"');
        header('Cache-Control: max-age=0');
        $writer->save('php://output');
        exit;
    }


    public function ndic_report()
    {

        return view('reports.ndic_data');
    }

    public function ndic_export(Request $request)
    {
        Log::info('NDIC export (no-template): start');

        try {
            // 1) Validate
            $data = $request->validate([
                'reporting_month' => ['required'], // YYYY-MM
                'type_of_bank' => ['required', 'string'],
                'bank_name' => ['required', 'string'],
                'bank_address' => ['required', 'string'],
                'md_name' => ['required', 'string'],
                'md_phone' => ['required', 'string'],
                'md_email' => ['required', 'email'],
                'cco_name' => ['required', 'string'],
                'cco_phone' => ['required', 'string'],
                'cco_email' => ['required', 'email'],
                'cfo_name' => ['required', 'string'],
                'cfo_phone' => ['required', 'string'],
                'cfo_email' => ['required', 'email'],
            ]);

            $reportingDate = Carbon::createFromFormat('Y-m', $data['reporting_month'])->endOfMonth();

            // 2) Prepare headers (NO TEMPLATE NEEDED)
            $sheetInd = 'DEPOSITS_&_LOANS (INDIVIDUAL)';
            $sheetCorp = 'DEPOSITS_&_LOANS (BusCorpPub)';

            $indHeaders = $this->ndicIndividualHeaders();
            $corpHeaders = $this->ndicCorporateHeaders();

            // 3) Aggregates
            $savingsByCustomer = Saving::select('customer_id', DB::raw('SUM(COALESCE(account_balance,0)) as bal'))
                ->groupBy('customer_id')
                ->pluck('bal', 'customer_id');

            $loansByBVN = Loan::query()
                ->join('customers', 'customers.id', '=', 'loans.customer_id')
                ->select('customers.bvn', DB::raw('SUM(COALESCE(loans.balance,0)) as bal'))
                ->groupBy('customers.bvn')
                ->pluck('bal', 'bvn');

            // 4) Build XLSX from scratch
            $filename = 'NDIC_' . $reportingDate->format('Y_m') . '.xlsx';
            $writer = SimpleExcelWriter::streamDownload($filename);
            $xlsx = $writer->getWriter();

            // Sheet 1: Bank details (simple 2-column style)
            $xlsx->getCurrentSheet()->setName("REPORTING BANK'S DETAILS");
            $writer->addRow(['Single Customer View', '', '', 'Reporting Date', $reportingDate->format('d-M-Y')]);
            $writer->addRow(['Type of Bank', $data['type_of_bank']]);
            $writer->addRow(['Bank Name', $data['bank_name']]);
            $writer->addRow(['Bank Address', $data['bank_address']]);
            $writer->addRow(['Managing Director (Name)', $data['md_name']]);
            $writer->addRow(['Managing Director (Phone)', $data['md_phone']]);
            $writer->addRow(['Managing Director (Email)', $data['md_email']]);
            $writer->addRow(['Chief Compliance Officer (Name)', $data['cco_name']]);
            $writer->addRow(['Chief Compliance Officer (Phone)', $data['cco_phone']]);
            $writer->addRow(['Chief Compliance Officer (Email)', $data['cco_email']]);
            $writer->addRow(['Chief Financial Officer (Name)', $data['cfo_name']]);
            $writer->addRow(['Chief Financial Officer (Phone)', $data['cfo_phone']]);
            $writer->addRow(['Chief Financial Officer (Email)', $data['cfo_email']]);

            // Sheet 2: Individuals
            $xlsx->addNewSheetAndMakeItCurrent();
            $xlsx->getCurrentSheet()->setName($sheetInd);
            $writer->addRow($indHeaders);

            $seq = 0;
            Customer::where(function ($q) {
                $q->whereNull('ctype')->orWhere('ctype', '!=', 'cooperate');
            })
                ->orderBy('id')
                ->chunk(1000, function ($customers) use (&$seq, $writer, $indHeaders, $savingsByCustomer, $loansByBVN) {
                    foreach ($customers as $c) {
                        $seq++;
                        $scvid = 'a' . str_pad((string) $seq, 4, '0', STR_PAD_LEFT);
                        $depositA = (float) ($savingsByCustomer[$c->id] ?? 0);
                        $loanB = (float) ($loansByBVN[$c->bvn] ?? 0);
                        $netAB = $depositA - $loanB;

                        // Build row map by header → value
                        $row = array_fill_keys($indHeaders, '');

                        // Minimal fields you actually have; rest stay blank by spec
                        $row['SCVID'] = $scvid;
                        $row['Customer BVN'] = $c->bvn ?? '';
                        $row[' National ID Type'] = $c->means_of_id ?? '';
                        $row['National ID No'] = $c->nin ?? '';
                        $row['Account Number'] = $c->acctno ?? '';
                        $row['Account Type (Savings, Current, Fixed, Domicilary)'] = $c->account_type ?? '';
                        $row['Category of account (Bank staff, Bank Director or Other customers)'] = $c->account_category ?? '';
                        $row['Individual/Joint Account Customer (Last) Name'] = $c->last_name ?? '';
                        $row['Individual/Joint Account Customer (First) Name'] = $c->first_name ?? '';
                        $row['Account Title ( Mr, Mrs, etc)'] = $c->title ?? '';
                        $row['Date of Birth'] = $c->dob ? Carbon::parse($c->dob)->format('Y-m-d') : '';
                        $row['Mobile No.'] = $c->phone ?? '';
                        $row['Customer Contact Address'] = $c->residential_address ?? '';
                        $row['Account Balance'] = $depositA;

                        $row['aggregated Loan Balance by BVN or Unique Identifier (i.e. addition of all loan account balances of the customer) (B)'] = $loanB;
                        $row["Net Depositor's Balance (A)-(B)"] = $netAB;

                        // Preserve original header order
                        $ordered = [];
                        foreach ($indHeaders as $h) {
                            $ordered[] = $row[$h] ?? '';
                        }
                        $writer->addRow($ordered);
                    }
                });

            // Sheet 3: Corporate/Business/Public
            $xlsx->addNewSheetAndMakeItCurrent();
            $xlsx->getCurrentSheet()->setName($sheetCorp);
            $writer->addRow($corpHeaders);

            $seq = 0;
            Customer::where('ctype', 'cooperate')
                ->orderBy('id')
                ->chunk(1000, function ($customers) use (&$seq, $writer, $corpHeaders, $savingsByCustomer, $loansByBVN) {
                    foreach ($customers as $c) {
                        $seq++;
                        $scvid = 'c' . str_pad((string) $seq, 4, '0', STR_PAD_LEFT);
                        $depositA = (float) ($savingsByCustomer[$c->id] ?? 0);
                        $loanB = (float) ($loansByBVN[$c->bvn] ?? 0);
                        $netAB = $depositA - $loanB;

                        $row = array_fill_keys($corpHeaders, '');

                        $row['SCVID'] = $scvid;
                        $row['Corporate BVN'] = $c->bvn ?? '';
                        $row['RC Number'] = $c->cac_no ?? '';
                        $row['Tax ID'] = $c->tax_id ?? '';
                        $row['Corporate Name'] = $c->business_name ?? '';
                        $row['Corporate Account Number'] = $c->acctno ?? '';
                        $row['Corporate Account Type (Savings, Current, Fixed, Domicilary)'] = $c->account_type ?? '';
                        $row['Corporate Contact Address'] = $c->residential_address ?? '';
                        $row['Date of Incorporation'] = $c->incorporated_date ? Carbon::parse($c->incorporated_date)->format('Y-m-d') : '';
                        $row['Account Balance'] = $depositA;

                        $row['Aggregated Loan Balance by BVN or Unique Identifier (i.e. addition of all outstanding loan balances of the customer) (B)'] = $loanB;
                        $row["Net Depositor's Balance (A)-(B)"] = $netAB;

                        $ordered = [];
                        foreach ($corpHeaders as $h) {
                            $ordered[] = $row[$h] ?? '';
                        }
                        $writer->addRow($ordered);
                    }
                });

            Log::info('NDIC export (no-template): streaming');
            return $writer->toBrowser();
        } catch (\Throwable $e) {
            Log::error('NDIC export error (no-template)', ['msg' => $e->getMessage()]);
            return back()->with('error', 'Failed to generate NDIC report: ' . $e->getMessage());
        }
    }


    private function ndicIndividualHeaders(): array
    {
        // Includes the columns you mapped in your code; others are left blank per your requirement.
        return [
            '',
            'SCVID',
            'Customer BVN',
            ' National ID Type',
            'National ID No',
            'Account Number',
            'Account Type (Savings, Current, Fixed, Domicilary)',
            'Category of account (Bank staff, Bank Director or Other customers)',
            'Individual/Joint Account Customer (Last) Name',
            'Individual/Joint Account Customer (Middle) Name',
            'Individual/Joint Account Customer (First) Name',
            'Account Title ( Mr, Mrs, etc)',
            'Date of Birth',
            'Mobile No.',
            'Customer Contact Address',
            'Account Balance',
            // Loan/Net balance keys used in your mapping:
            'aggregated Loan Balance by BVN or Unique Identifier (i.e. addition of all loan account balances of the customer) (B)',
            "Net Depositor's Balance (A)-(B)",
            // Reserve some common NDIC columns (left empty if you don't have them)
            'Waiver/Write Off',
            'Cash Backed',
            'Cash Amount If Yes',
            'Secured',
            'Collateral Type (Legal Mortgage/Equitable Mortgage /OTHERS)',
            'Collateral Value',
            'Collateral Description',
            'Collateral Full Address',
            'Collateral Status (Perfected or Not Perfected)',
            "Guarantor's Name",
            "Guarantor's BVN",
            "Guarantor's Additional National ID No (NIMC No, Passport No, Voter's Card No, etc)",
            "Guarantor's Address",
            "Guarantor's Phone Number",
        ];
    }


    private function ndicCorporateHeaders(): array
    {
        return [
            '',
            'SCVID',
            'Corporate BVN',
            'RC Number',
            'Tax ID',
            'Corporate Name',
            'Corporate Account Number',
            'Corporate Account Type (Savings, Current, Fixed, Domicilary)',
            'Corporate Contact Address',
            'Date of Incorporation',
            'Account Balance',
            'Aggregated Loan Balance by BVN or Unique Identifier (i.e. addition of all outstanding loan balances of the customer) (B)',
            "Net Depositor's Balance (A)-(B)",
            'Waiver/Write Off',
            'Cash Backed',
            'Cash Amount If Yes',
            'Secured',
            'Collateral Type (Legal Mortgage/Equitable Mortgage /OTHERS)',
            'Collateral Value',
            'Collateral Location',
            'Collateral Status ',
            'Guarantor(s) Name',
            'Guarantor(s) BVN',
            "Guarantor(s) Additional National ID No (NIMC No, Passport No, Voter's Card No, etc)",
            'Guarantor(s) Address',
            'Guarantor(s) Phone Number',
        ];
    }


    public function monthly_savings(Request $request)
    {
        $reference = trim((string) $request->get('reference', ''));
        $dateFrom = $request->get('datefrom'); // Y-m-d
        $dateTo = $request->get('dateto');   // Y-m-d

        $query = MonthlySavingsProfit::with('customer')
            ->when($reference !== '', function ($q) use ($reference) {
                $like = '%' . str_replace(' ', '%', $reference) . '%';

                $q->where(function ($x) use ($like) {
                    $x->where('account_number', 'like', $like)
                        ->orWhereHas('customer', function ($c) use ($like) {
                            $c->where('first_name', 'like', $like)
                                ->orWhere('last_name', 'like', $like)
                                ->orWhereRaw("CONCAT(TRIM(first_name),' ',TRIM(last_name)) LIKE ?", [$like])
                                ->orWhereRaw("CONCAT(TRIM(last_name),' ',TRIM(first_name)) LIKE ?", [$like]);
                        });
                });
            })
            ->when($dateFrom, function ($q) use ($dateFrom) {
                $q->where('created_at', '>=', Carbon::parse($dateFrom)->startOfDay());
            })
            ->when($dateTo, function ($q) use ($dateTo) {
                $q->where('created_at', '<=', Carbon::parse($dateTo)->endOfDay());
            })
            ->orderByDesc('created_at');

        if ($request->filled('export')) {
            $rows = $query->get()->map(function ($row) {
                $cust = $row->customer;
                $first = $cust?->first_name ?? '';
                $last = $cust?->last_name ?? '';
                $properName = trim(ucfirst(strtolower($last)) . ' ' . ucfirst(strtolower($first))) ?: 'N/A';

                return [
                    'Customer' => $properName,
                    'Account Number' => $row->account_number,
                    'Interest Rate (%)' => number_format((float) $row->interest_rate_percent, 4),
                    'Balance Basis' => number_format((float) $row->balance_basis, 2),
                    'Profit Amount' => number_format((float) $row->profit_amount, 2),
                    'Withdrawals Total' => number_format((float) $row->withdrawals_total, 2),
                    'Status' => ucfirst(strtolower((string) $row->status)),
                    'Reference' => $row->reference,
                    'Month' => $row->month,
                    'Created At' => optional($row->created_at)->format('Y-m-d H:i:s'),
                ];
            })->toArray();

            return SimpleExcelWriter::streamDownload('monthly-savings.xlsx')
                ->addRows($rows);
        }

        $montlys = $query->get();

        return view('reports.monthly_savings', [
            'montlys' => $montlys,
            'reference' => $reference,
            'datefrom' => $dateFrom,
            'dateto' => $dateTo,
        ]);
    }


}//endclass
