<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use App\Models\Ipwhitelisting;
use Illuminate\Support\Facades\Log;

class CheckIPAddress
{
    public function handle(Request $request, Closure $next)
    {
        
        $ip = $request->header('X-Forwarded-For')
            ? trim(explode(',', $request->header('X-Forwarded-For'))[0])
            : $request->ip();

        Log::info('IP WHITELIST CHECK', ['ip' => $ip]);

     
        $allowedIp = Ipwhitelisting::where('ip_address', $ip)
            ->where('status', 'active') 
            ->first();

        if (!$allowedIp) {
            Log::warning('IP BLOCKED', [
                'ip' => $ip,
                'reason' => 'not found or not active'
            ]);

            return response()->json([
                'status'  => false,
                'message' => 'Unauthorized IP address'
            ], 403);
        }

      
        return $next($request);
    }
}
