<?php
namespace App\Http\Traites;

use App\Models\NipAccessToken;
use Carbon\Carbon;
use Exception;
use App\Http\Traites\UserTraite;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Str;

trait TransferTraite{

    use UserTraite;

    public function monnifyTranfer($url,$apikey,$sercetkey,$amount,$transref,$desc,$bankcode,$destination_account,$sacctno,$receipient_name){
        $authbasic = base64_encode($apikey.":".$sercetkey);
        $bankTransfer = Http::withHeaders([
            "Authorization" => "Basic ".$authbasic
        ])->post($url,[
            "amount" => $amount,
            "reference" => $transref,
            "narration" => $desc,
            "destinationBankCode" => $bankcode,
            "destinationAccountNumber" => $destination_account,
            "currency" => "NGN",
            "sourceAccountNumber" => $sacctno,
            "destinationAccountName" => $receipient_name
        ])->json();

        return $bankTransfer;
    }
    
    public function bankTransfer($url,$pky,$sky,$amount,$destination_account,$bankcode,$racctname,$sname,$sourceacct,$sbvn,$transref,$desc){
       
        $token = $this->AccessMiddelware();

        $bankTransferPayout = Http::withHeaders([
            "Content-Type" => "application/json",
            "Authorization" => "Bearer ".$token['token'],
        ])->post($url,[
              "amount" => $amount,
            "narration" => $desc,
            "payment_reference" => $transref,
            "destination_institution_code" => $bankcode,
            "originator_account_name" => $sname,
            "originator_account_number" => $sourceacct,
            "originator_kyc_level" => "1",
            "originator_bvn" => $sbvn,
            "beneficiary_account_name" => $racctname,
            "beneficiary_account_number" => $destination_account,
            "beneficiary_bank_verification_number" => "nil",
            "beneficiary_kyc_level" => "1",
            "channel_code" => "1",

        ])->json();
       
         return ["status" => $bankTransferPayout['status'],"reponse" => $bankTransferPayout];
    }

    public function NibbsPayTransfer($url,$amount,$bname,$bacctno,$sname,$sacctno,$pyref,$desc,$billerid,$bnkcode,$trnid,$Neref,$setlacname,$setlacno){

        $t="";
       $response = Http::withHeaders([
            "Authorization" => "Bearer ".$t
        ])->post($url."nip/fundstransfer",[      
            "amount" => $amount,
            "beneficiaryAccountName" => $bname,
            "beneficiaryAccountNumber" => $bacctno,
            "beneficiaryBankVerificationNumber" => "",
            "beneficiaryKYCLevel" => "1",
            "channelCode" => "1",
            "originatorAccountName" => $sname,
            "originatorAccountNumber" => $sacctno,
            "originatorKYCLevel" => "1",
            "mandateReferenceNumber" => "MA-0112345678-2022315-53097",
            "paymentReference" => $pyref,
            "transactionLocation" => "1.38716,3.05117",
            "originatorNarration" => $desc,
            "beneficiaryNarration" => $desc,
            "billerId" => $billerid,
            "destinationInstitutionCode" => $bnkcode,
            "sourceInstittioncode" => "999998",
            "transactionId" => $trnid,
            "originatorBankVerificationNumber" => "",
            "nameEnquiryRef" => $Neref,
            "InitiatorAccountName" => $setlacname,
            "InitiatorAccountNumber" => $setlacno
        ]);
    }


    public function validateSettlementBalance($url,$amout,$tacctno,$tacctnme,$autocd,$intncod,$billerid,$trnxid){

           $checkbalanace = Http::withHeaders([
               "Authorization" => "Bearer "
           ])->post($url."nip/balanceenquiry",[      
            "channelCode" => "1",
            "targetAccountName" => $tacctnme,
            "targetAccountNumber" => $tacctno,
            "targetBankVerificationNumber" => "",
            "authorizationCode" => $autocd,
            "destinationInstitutionCode" => $intncod,
            "billerId" => $billerid,
            "transactionId" => $trnxid
           ])->json();
           
           $this->logInfo("validating settlement balance",$checkbalanace);
           //return $checkbalanace;
      
           if($checkbalanace["availableBalance"] < $amout){
                $response = ["status" => false, 'message' => "Switcher Error... Please contact support"];
           }else{
                $response = ["status" => true,'message' => "Amount is Valid",];
           }
           return $response;
    }
    
      public function WirelessTransfer($url,$akey,$amount,$treference,$bankcode,$accountnum,$receipient,$desc){
        $response = Http::withHeaders([
            "ApiKey" => $akey,
            "Content-Type" => 'application/json',
            "Accept" => "application/json"
        ])->post($url."transfer",[
            "amount" => $amount,
            "transaction_reference" => $treference,
            "bank_code" => $bankcode,
            "account_number" => $accountnum,
            "receipient_name" => $receipient,
            "description" => $desc,
        ])->json();
        
        return $response;
     }
}//end