<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class TargetSavingsApprovedMail extends Mailable implements ShouldQueue
{
    use Queueable, SerializesModels;

  public array $data;

    public function __construct(array $data)
    {
        $this->afterCommit();
        $this->data = $data;
    }

    public function envelope(): Envelope
    {
        return new Envelope(subject: $this->data['type'] ?? 'Target Savings Approved');
    }

    public function content(): Content
    {
        return new Content(
            view: 'target_savings.emails.approved',
            with: [
                'type'      => $this->data['type']      ?? 'Target Savings Approved',
                'preheader' => $this->data['preheader'] ?? '',
                'data'      => $this->data,
            ]
        );
    }

    public function attachments(): array { return []; }
}
