<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class MonthlySavingsProfit extends Model
{
    protected $fillable = [
        'customer_id',
        'user_id',
        'branch_id',
        'account_number',
        'interest_rate_percent',
        'balance_basis',
        'profit_amount',
        'withdrawals_total',
        'status',
        'reference',
        'initiated_by',
        'note',
        'month',
    ];

    public function customer()
    {
        return $this->belongsTo(Customer::class, 'customer_id');
    }
}
