<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    
    public function up()
    {
        Schema::create('emails', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->nullable();
            $table->foreignId('branch_id');
            $table->string('subject');
            $table->longText('message');
            $table->string('recipient')->nullable();
            $table->timestamps();
        });
    }


    public function down()
    {
        Schema::dropIfExists('emails');
    }
};
