<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *  
     * @return void
     */
    public function up()
    {
        Schema::create('customer_restrictions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('customer_id');
            $table->string('customer_name');
            $table->string('account_number');
            $table->string('amount')->nullable();
            $table->string('reference_no')->nullable();
            $table->string('session_id')->nullable();
            $table->text('note')->nullable();
            $table->integer('status');
            $table->string('branch_id')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('customer_restrictions');
    }
};
