<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {

    public function up(): void
    {
        Schema::create('target_savings', function (Blueprint $table) {
            $table->id();
            $table->string('code')->unique();
            $table->foreignId('customer_id')->nullable()->constrained('customers')->cascadeOnUpdate()->restrictOnDelete();
            $table->foreignId('user_id')->nullable()->constrained('users')->cascadeOnUpdate()->restrictOnDelete();
            $table->foreignId('target_savings_product_id')->constrained('target_savings_products')->cascadeOnUpdate()->restrictOnDelete();
            $table->string('account_number')->nullable();
            $table->string('savings_plan_name');
            $table->char('currency', 3)->default('NGN')->nullable();
            $table->decimal('target_amount', 15, 2);
            $table->unsignedInteger('duration')->nullable();
            $table->boolean('auto_save')->default(true);
            $table->enum('frequency', ['daily', 'weekly', 'monthly'])->default('daily');
            $table->decimal('per_debit_amount', 15, 2)->nullable();
            $table->date('auto_save_start_date')->nullable();
            $table->decimal('auto_save_amount', 15, 2)->nullable();
            $table->string('status')->default('pending');
            $table->string('target_status')->default('open');

            $table->date('start_date')->nullable();
            $table->date('maturity_date')->nullable();
            $table->enum('interest_method', ['daily', 'weekly', 'monthly'])->default('daily');
            $table->decimal('total_amount_saved', 15, 2)->default(0);
            $table->decimal('total_amount_paid', 15, 2)->default(0);
            $table->decimal('total_accrued_interest', 15, 2)->default(0);
            $table->string('funding_source_type')->nullable();

            // Flexible actor fields
            $table->string('created_by')->nullable();
            $table->string('declined_by')->nullable();
            $table->string('terminate_by')->nullable();
            $table->string('approved_by')->nullable();
            $table->string('updated_by')->nullable();

            $table->string('first_successful_auto_debit_at')->nullable();
            $table->string('last_interest_accrued_at')->nullable();

            $table->string('initiated_by')->nullable();
            $table->timestamp('initiated_at')->nullable();

            $table->string('terminated_by')->nullable();
            $table->timestamp('terminated_at')->nullable();

            $table->string('disbursed_by')->nullable();
            $table->timestamp('disbursed_at')->nullable();

            $table->timestamp('updated_date')->nullable();
            $table->timestamp('created_date')->nullable();
            $table->timestamp('declined_at')->nullable();
            $table->timestamp('terminate_at')->nullable();
            $table->timestamp('approved_at')->nullable();
            $table->timestamp('paused_at')->nullable();
            $table->string('paused_by')->nullable();

            $table->json('metadata')->nullable();
            $table->timestamps();

            $table->index(['customer_id', 'status']);
            $table->index(['user_id', 'status']);
        });

    }

    public function down(): void
    {
        Schema::dropIfExists('target_savings');
    }
};
