<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('target_savings_schedules', function (Blueprint $table) {
            $table->id();
            $table->foreignId('target_savings_id')->constrained('target_savings')->cascadeOnUpdate()->restrictOnDelete();
            $table->foreignId('customer_id')->nullable()->constrained('customers')->cascadeOnUpdate()->nullOnDelete();
            $table->foreignId('user_id')->nullable()->constrained('users')->cascadeOnUpdate()->nullOnDelete();
            $table->string('target_savings_code');
            $table->unsignedInteger('schedule_no');
            $table->date('due_date');
            $table->dateTime('due_at')->nullable();
            $table->decimal('amount', 15, 2);
            $table->string('status')->default('pending');
            $table->unsignedTinyInteger('attempt_count')->default(0);
            $table->timestamp('debit_at')->nullable();
            $table->timestamp('paid_at')->nullable();

            $table->string('debit_by')->nullable();
            $table->string('paid_by')->nullable();
            $table->string('updated_by')->nullable();

            $table->string('initiated_by')->nullable();
            $table->timestamp('initiated_at')->nullable();

            $table->string('terminated_by')->nullable();
            $table->timestamp('terminated_at')->nullable();

            $table->string('disbursed_by')->nullable();
            $table->timestamp('disbursed_at')->nullable();


            $table->timestamps();
            $table->unique(['target_savings_id', 'schedule_no']);
            $table->index('target_savings_code');
            $table->index(['due_date', 'status']);
            $table->index('due_at');
            $table->index('debit_at');
            $table->index('paid_at');
        });

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('target_savings_schedules');
    }
};
