<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('phone_verifications', function (Blueprint $table) {
            $table->id();

            $table->foreignId('customer_id')->nullable();
            $table->foreignId('user_id')->nullable();
            $table->string('branch_id')->nullable();

            $table->string('phone');
            $table->string('otp', 10);
            $table->timestamp('otp_expired_at')->nullable();
            $table->boolean('is_verify')->default(false);

            $table->string('ip_address')->nullable();
            $table->string('device_id')->nullable();


            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('phone_verifications');
    }
};
