@extends('layout.app')
@section('title')
    Manage Transfer Charges  
@endsection
@section('pagetitle')
Manage Transfer Charges  
@endsection
@section('content')
  <div class="container">
    <div class="row" id="advanced-input">
              <div class="col-md-12">
                <div class="panel widget">
                    <div class="panel-heading">
                      <div style="text-align: end">
                      @can('create transfer charges')
                      <a href="javascript:void(0)"  onclick="openModal('','','','','create')" class="btn btn-default"><span class="menu-icon"> <i class="fa fa-plus"></i> </span> Add Trnx Charges</a>
                      @endcan
                      </div>
                      </div>
                  <div class="panel-body">

                    <div class="row">
                    <div class="col-md-12 col-lg-12 col-sm-12">
                  @include('includes.success')
                    </div>
                    </div>
                    <div class="table-responsive">
                        <table class="table table-striped table-sm table-bordered table-condensed table-hover" id="acoff">
                            <thead>
                                <tr>
                                    <th>Sn</th>
                                    <th>Min Amount</th>
                                    <th>Max Amount</th>
                                    <th>Charge Amount</th>
                                    <th>Created on</th>
                                    <th></th>
                                </tr>
                            </thead>    
                            <tbody>
                                <?php $i=0;?>
                                @foreach ($transch as $item)
                                <tr>
                                    <td>{{$i+1}}</td>
                                    <td>{{number_format($item->min_amount,2)}}</td>
                                    <td>{{number_format($item->max_amount,2)}}</td>
                                    <td>{{number_format($item->charge_amount,2)}}</td>
                                    <td>{{date('d-m-Y H:ia',strtotime($item->created_at))}}</td>
                                    <td>
                                          @can('edit transfer charges')
                                              <a href="javascript:void(0)"  onclick="openModal('{{$item->min_amount}}','{{$item->max_amount}}','{{$item->charge_amount}}','{{$item->id}}','update')" title="Edit" class="btn menu-icon vd_bd-blue vd_blue btn-sm"><i class="fa fa-pencil"></i></a>
                                            @endcan
                                    </td>
                                </tr>
                                <?php $i++?>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                  </div>
                </div>
                <!-- Panel Widget --> 
              </div>
              <!-- col-md-12 --> 
            </div>
            <!-- row -->
  </div>

   <!-- Modal -->
 <div class="modal fade" id="myModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-md">
      <div class="modal-content">
        <div class="modal-header vd_bg-blue vd_white">
          <button type="button" class="close" data-dismiss="modal" aria-hidden="true"><i class="fa fa-times"></i></button>
          <h4 class="modal-title" id="myModalLabel">Transfer Charges</h4>
        </div>
        <div class="modal-body"> 
          <form class="form-horizontal" action="{{route('tranxcharges.save')}}" method="post" id="chtrans">
            @csrf
            <div class="form-group">
              <label class="col-sm-3 control-label">Min Amount</label>
              <div class="col-sm-7 controls">
               <input type="number" name="min_amount" class="form-control" required id="minamoutn">
              </div>
              </div>
            <div class="form-group">
              <label class="col-sm-3 control-label">Max Amount</label>
              <div class="col-sm-7 controls">
               <input type="number" name="max_amount" class="form-control" required id="maxamoutn">
              </div>
              </div>
            <div class="form-group">
              <label class="col-sm-3 control-label">Charge Amount</label>
              <div class="col-sm-7 controls">
               <input type="number" name="charge_amount" class="form-control" required id="chamoutn">
              </div>
              </div>

              <input type="hidden" name="storetyp" id="wtyp" value="">
              <input type="hidden" name="id" id="uid" value="">
      </div>
      <div class="modal-footer background-login">
        <button type="button" class="btn vd_btn vd_bg-grey" data-dismiss="modal">Close</button>
        <button type="submit" class="btn vd_btn vd_bg-green" id="btnssubmit">Save Charges</button>
      </div>
        </form>
      </div>
      <!-- /.modal-content --> 
    </div>
    <!-- /.modal-dialog --> 
  </div>
  <!-- /.modal --> 
@endsection
@section('scripts')
<script>
  function openModal(mnamt,mxamt,chramt,id,typ){
    $("#myModal").modal('show');
    $("#minamoutn").val(mnamt);
    $("#maxamoutn").val(mxamt);
    $("#chamoutn").val(chramt);
    $("#wtyp").val(typ);
    $("#uid").val(id);
  }
</script>

    <script type="text/javascript">
  $(document).ready(function(){
    $("#acoff").dataTable({
    'pageLength':25,
    'dom': 'Bfrtip',
      buttons: [ 'copy', 'csv', 'print','pdf']
  });

    $("#chtrans").submit(function(e){
      e.preventDefault();
      $.ajax({
        url: $("#chtrans").attr('action'),
        method: 'post',
        data: $("#chtrans").serialize(),
        beforeSend:function(){
          $("#btnssubmit").text('Please wait...');
          $("#btnssubmit").attr('disabled',true);
        },
        success:function(data){
          if(data.status == 'success'){
            $("#btnssubmit").text('Save Charges');
          $("#btnssubmit").attr('disabled',false);
          toastr.success(data.msg);
          $("#chtrans")[0].reset();
          window.location.reload();
          }else{
            toastr.error(data.msg);
             $("#btnssubmit").text('Save Charges');
           $("#btnssubmit").attr('disabled',false);
             return false;
           }
        },
        error:function(xhr,status,errorThrown){
          let err = '';
          $.each(xhr.responseJSON.errors, function (key, value) {
                err += value;
            });
            toastr.error(err);
          $("#btnssubmit").text('Save Charges');
          $("#btnssubmit").attr('disabled',false);
          return false;
        }
      });
    });
  });
</script>
@endsection
