@extends('layout.app')
@section('title')
    Wallet
@endsection
@section('pagetitle')
Wallet
@endsection
@section('content')
<?php
    $getsetvalue = new \App\Models\Setting();
    $tref = substr(mt_rand('0',time()),'0','7');
   ?>
  <div class="container">
    <div class="row" id="advanced-input">
              <div class="col-md-12">
                <div class="panel widget">
                    <div class="panel-heading">
                        <div style="text-align: end">
                            <a href="javascript:void(0)" onclick="fundbranch('wallet')" class="btn vd_btn vd_bg-blue btn-sm">Fund wallet</a>
                            <a href="javascript:void(0)" onclick="fundbranch('vas')" class="btn vd_btn vd_bg-red btn-sm">Fund Vas Wallet</a>
                            @if ($getsetvalue->getsettingskey('ussd_channel')==1)
                              <a href="javascript:void(0)" onclick="fundbranch('ussd')" class="btn vd_btn vd_bg-green btn-sm">Fund USSD wallet</a>
                            @endif
                            @if ($getsetvalue->getsettingskey('whatsapp_channel')==1)
                             <a href="javascript:void(0)" onclick="fundbranch('whatsapp')" class="btn vd_btn vd_bg-blue btn-sm">Fund Whatsapp Wallet</a> 
                            @endif
                            @if ($getsetvalue->getsettingskey('enable_verifyme')==1)
                             <a href="javascript:void(0)" onclick="fundbranch('verrifyme')" class="btn vd_btn vd_bg-black btn-sm">Fund Verifyme Wallet</a> 
                            @endif
                        </div>
                      </div>
                  <div class="panel-body">

                    <div class="row">
                    <div class="col-md-12 col-lg-12 col-sm-12">
                  @include('includes.success')
                    </div>
                    </div>
                    <div class="noprint" style="margin-bottom: 15px">
                        <form action="{{route('wallet')}}" method="get" onsubmit="thisForm()">
                          <input type="hidden" name="filter" value="true">
                          <table class="table table-bordered table-hover table-sm">
                            <thead>
                              <tr>
                                <th>From Date</th>
                                <th>To Date</th>
                                <th></th>
                              </tr>
                            </thead>
                            <tbody>
                              <tr>
                                <td>
                                  <div class="form-group">
                                    <input type="date" name="datefrom" required id="" class="form-control" value="{{!empty($_GET['datefrom']) ? $_GET['datefrom'] : ''}}">
                                  </div>
                                </td>
                                <td>
                                  <div class="form-group">
                                    <input type="date" name="dateto" required id="" class="form-control" value="{{!empty($_GET['dateto']) ? $_GET['dateto'] : ''}}">
                                  </div>
                                </td>
                            
                                <td>
                                  <button type="submit" class="btn btn-success btn-sm" id="btnsetsubmit">Generate</button>
                                  <button type="button" class="btn btn-danger btn-sm" onclick="window.location.href='{{route('wallet')}}'">Reset</button>
                                </td>
                              </tr>
                            </tbody>
                          </table>
                        </form>
                      </div>

                      <hr>
                      <table class="table table-bordered table-sm">
                        <thead>
                          <tr>
                            <th>Company Wallet</th>
                            <th>Vas Wallet</th>
                            @if ($getsetvalue->getsettingskey('ussd_channel')==1)
                            <th>USSD Wallet</th>
                            @endif
                            @if ($getsetvalue->getsettingskey('whatsapp_channel')==1)
                            <th>Whatsapp Wallet</th>
                            @endif
                            @if ($getsetvalue->getsettingskey('enable_verifyme')==1)
                            <th>Verifyme Wallet</th>
                            @endif
                          </tr>
                        </thead>
                        <tbody>
                          <tr>
                            <td>{{number_format($getsetvalue->getsettingskey('company_balance'),2)}}</td>
                            <td>{{number_format($getsetvalue->getsettingskey('vas_wallet'),2)}}</td>
                            @if ($getsetvalue->getsettingskey('ussd_channel')==1)
                            <td>{{number_format($getsetvalue->getsettingskey('ussd_balance'),2)}}</td>
                            @endif
                            @if ($getsetvalue->getsettingskey('whatsapp_channel')==1)
                            <td>{{number_format($getsetvalue->getsettingskey('whatsapp_balance'),2)}}</td>
                            @endif
                            @if ($getsetvalue->getsettingskey('enable_verifyme')==1)
                            <td>{{number_format($getsetvalue->getsettingskey('verifyme_balance'),2)}}</td>
                            @endif
                          </tr>
                        </tbody>
                      </table>
                      
                      <hr>

                    <div class="table-responsive">
                        <table class="table table-striped table-bordered table-condensed table-hover" id="acoff">
                            <thead>
                                <tr>
                                    <tr style="background-color: #D1F9FF">
                                        <th>Sn</th>
                                           <th>Transaction Date</th>
                                            <th>Reference</th>
                                            <th>Amount</th>
                                            <th>Posted by</th>
                                           <th>Balance ({{$getsetvalue->getsettingskey('currency_symbol')}})</th>
                                    
                                       </tr>
                                </tr>
                            </thead>    
                            <tbody>
                                <?php $i=0;
                                $balance = 0;
                                ?>
                                @if (!empty($_GET['filter']) && $_GET['filter'] == true)
                                
                                @foreach($data as $key)
                                <?php $balance += $key->amount;?>
                                <tr>
                                    <td>{{ $i+1 }}</td>  
                                    <td>{{date("d-m-Y",strtotime($key->created_at))." at ".date("h:ia",strtotime($key->created_at))}}</td>
                                   
                                    <td>{{$key->reference_no}} </td>
                                    <td>{{number_format($key->amount,2)}}</td>
                                    <td>
                                    {{$key->approve_by}}
                                    </td>
                                    <td>{{number_format($balance,2)}}</td>
                                </tr>
                                <?php $i++?>
                                @endforeach
                                @else
                                @foreach($data as $key)
                                <?php $balance += $key->amount;?>
                                <tr>
                                    <td>{{ $i+1 }}</td>  
                                    <td>{{date("d-m-Y",strtotime($key->created_at))." ".date("h:ia",strtotime($key->created_at))}}</td>
                                   
                                    <td>{{$key->reference_no}} </td>
                                    <td>{{number_format($key->amount,2)}}</td>
                                    <td>
                                        {{$key->approve_by}}
                                    </td>
                                    <td>{{number_format($balance,2)}}</td>
                                </tr>
                                <?php $i++?>
                                @endforeach
                            @endif
                            </tbody>
                        </table>
                    </div>
                  </div>
                </div>
                <!-- Panel Widget --> 
              </div>
              <!-- col-md-12 --> 
            </div>
            <!-- row -->
  </div>

   <!-- Modal -->
 <div class="modal fade" id="myModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-md">
      <div class="modal-content">
        <div class="modal-header vd_bg-blue vd_white">
          <button type="button" class="close" data-dismiss="modal" aria-hidden="true"><i class="fa fa-times"></i></button>
          <h4 class="modal-title" id="myModalLabel">Fund Wallet</h4>
        </div>
        <div class="modal-body"> 
          <form class="form-horizontal" action="{{route('walletfund')}}" method="post" id="fundwlet">
            @csrf
            <div class="form-group">
              <label class="col-sm-1 control-label">Amount</label>
              <div class="col-sm-12 controls">
               <input type="number" name="amount" class="form-control" required id="amoutn">
              </div>
              </div>

              <div class="form-group" id="shwglcod" style="display: none">
                <label class="col-sm-4 control-label">GL Account to Credit</label>
                <div class="col-sm-12 controls">  
                  <span>(Account must be a cash balance or due from banks)</span>
                   <select name="glaccount"  id="glcode"  class="width-70 glcr form-control" style="width: 100%">
                    <option selected disabled>Select Account</option>
                    @foreach ($gls as $item)
                      @foreach (DB::table('account_categories')->where('id',$item->account_category_id)->get() as $acitem)
                      <option value="{{$item->gl_code}}"><b>{{ucwords($item->gl_name)." [".$item->gl_code." - ".ucwords($acitem->name)." bal: ".number_format($item->account_balance,2)."]"}}</b></b></option>
                      @endforeach
                    @endforeach
                   </select>
                  <img src="{{asset('img/loading.gif')}}" id="sttext" style="display: none" alt="loading">  
    
                </div>
                </div>
          
              <input type="hidden" name="fundtype" id="wyp" value="">
              <input type="hidden" name="paymentref" value="{{"RX1_".$tref}}">
      </div>
      <div class="modal-footer background-login">
        <button type="button" class="btn vd_btn vd_bg-grey" data-dismiss="modal">Close</button>
        <button type="submit" class="btn vd_btn vd_bg-green" id="btnssubmit">Fund Wallet</button>
        <button type="submit" class="btn vd_btn vd_bg-green pflut" id="cmbtnssubmit" style="display:none">Fund Wallet
          <img src="{{asset('img/loading.gif')}}" id="btnsttext" style="display: none" alt="loading">  
        </button>
      </div>
        </form>
      </div>
      <!-- /.modal-content --> 
    </div>
    <!-- /.modal-dialog --> 
  </div>
  <!-- /.modal --> 
@endsection
@section('scripts')
<script>
    function fundbranch(ty){
        $("#myModal").modal('show');
        $("#wyp").val(ty);
      if(ty==="vas" || ty==="ussd" || ty==="whatsapp" || ty==="verrifyme"){
          $("#cmbtnssubmit").show();
         $("#shwglcod").hide();
          $("#btnssubmit").hide();
        }else{
          $("#cmbtnssubmit").hide();
          $("#shwglcod").hide();
          $("#btnssubmit").show();
        }
      }
  </script>
    <script type="text/javascript">
  $(document).ready(function(){
    $(".glcr").select2({
             dropdownParent: $('#myModal')
         });

     let aud = $("#acoff").dataTable({
      'pageLength':25,
      'dom': 'Bfrtip',
      buttons: [ 'copy', 'csv', 'print','pdf']
    });


    // $("#fundwlet").submit(function(e){
    //   e.preventDefault();
    //   $.ajax({
    //     url: $("#fundwlet").attr('action'),
    //     method: 'post',
    //     data: $("#fundwlet").serialize(),
    //     beforeSend:function(){
    //       $("#btnssubmit").text('Please wait...');
    //       $("#btnssubmit").attr('disabled',true);
    //     },
    //     success:function(data){
    //       if(data.status == 'success'){
    //         $("#btnssubmit").text('Fund Wallet');
    //       $("#btnssubmit").attr('disabled',false);
    //       toastr.success(data.msg);
    //       $("#fundwlet")[0].reset();
    //       window.location.reload();
    //       }else{
    //         toastr.error(data.msg);
    //          $("#btnssubmit").text('Fund Wallet');
    //        $("#btnssubmit").attr('disabled',false);
    //          return false;
    //        }
    //     },
    //     error:function(xhr,status,errorThrown){
    //       let err = '';
    //       $.each(xhr.responseJSON.errors, function (key, value) {
    //             err += value;
    //         });
    //         toastr.error(err);
    //       $("#btnssubmit").text('Fund Wallet');
    //       $("#btnssubmit").attr('disabled',false);
    //       return false;
    //     }
    //   });
    // });

    $("#glcode").change(function(){
      let glcodeval = $("#glcode").val();
      let amount = $("#amoutn").val();
      
     if(glcodeval.length == 8){
        $.ajax({
        url:"{{route('checkaccount')}}",
        method:"get",
        data:{'glcodeval':glcodeval,'amount':amount},
        beforeSend:function(){
          $("#sttext").show();
        },
        success:function(data){
          if(data.status === '0'){
            $("#sttext").hide();
             $("#cmbtnssubmit").attr('disabled',true);
            toastr.error(data.msg);
            return false;
          }else{
            $("#sttext").hide();
              $("#cmbtnssubmit").attr('disabled',false);
          $(".glname").text(data.name).addClass('text-success');
          $(".glcode").text(data.glcode).addClass('text-success');
          $(".glbal").text(data.bal).addClass('text-success');
          $("#glid").val(data.glid);
          }
        },
        error:function(xhr,status,errorThrown){
          toastr.error('An Error Occured... '+errorThrown);
          $("#sttext").hide();
           $("#cmbtnssubmit").attr('disabled',true);
          return false;
        }
      })
    }else if(glcodeval == ""){
         $("#cmbtnssubmit").attr('disabled',true);
      toastr.error('GL account field is empty');
        return false;
     }
     
    });
  });
</script>

<script>
  function payWithflutterwave(){
     $("#btnsttext").show();
    $(".pflut").attr('disabled',true); 
         
      FlutterwaveCheckout({
    public_key: "{{$getsetvalue->getsettingskey('gateway_pub_key')}}",
    tx_ref: "RX1_{{$tref}}",
    amount: document.getElementById("amoutn").value,
    currency: "NGN",
    country: "NG",
    payment_options: "card, banktransfer, ussd",
   
    customer: {
      email: "{{$getsetvalue->getsettingskey('company_email')}}",
      phone_number: "{{$getsetvalue->getsettingskey('company_phone')}}",
      name:"{{$getsetvalue->getsettingskey('company_name')}}",
    },
    callback: function (data) {
      let trns = data.transaction_id;
      const form = document.getElementById("fundwlet");
       form.submit();
      console.log(data);
    },
    onclose: function() {
      // close modal
       $("#btnsttext").hide();
    $(".pflut").attr('disabled',false); 
    },
    customizations: {
      title: "",
      description: "wallet Topup",
      logo: "",
    },
  });
    
  }//flutterwave
</script>
@endsection
