@extends('layout.app')
@section('title') Monthly Savings Interest @endsection
@section('pagetitle') Monthly Savings Interest @endsection

@section('content')
<div class="container">
  <div class="row" id="advanced-input">
    <div class="col-md-12">
      <div class="panel widget">
        <div class="panel-heading">
          <h4>Monthly Savings Interest</h4>
        </div>

        <div class="panel-body">

          {{-- Search / Export --}}
          <div style="margin-bottom: 15px">
            <form action="{{ route('report.monthly.savings') }}" method="get">
              <table class="table table-bordered table-hover table-sm">
                <thead>
                  <tr>
                    <th>Search By Customer Name or Account Number</th>
                    <th>Date From</th>
                    <th>Date To</th>
                    <th style="white-space:nowrap;">Actions</th>
                  </tr>
                </thead>
                <tbody>
                  <tr>
                    <td>
                      <input type="text"
                             name="reference"
                             value="{{ old('reference', request('reference')) }}"
                             placeholder="Enter Customer Name or Account Number"
                             class="form-control">
                    </td>
                    <td>
                      <input type="date"
                             name="datefrom"
                             value="{{ old('datefrom', request('datefrom')) }}"
                             class="form-control">
                    </td>
                    <td>
                      <input type="date"
                             name="dateto"
                             value="{{ old('dateto', request('dateto')) }}"
                             class="form-control">
                    </td>
                    <td>
                      <button type="submit" class="btn btn-success btn-sm">Search</button>

                      {{-- Export uses same filters + export flag --}}
                      <button type="submit" name="export" value="1" class="btn btn-primary btn-sm">
                        Export
                      </button>

                      <a href="{{ route('report.monthly.savings') }}" class="btn btn-danger btn-sm">
                        Reset
                      </a>
                    </td>
                  </tr>
                </tbody>
              </table>
            </form>
          </div>

          {{-- Results --}}
          <div class="table-responsive">
            <table class="table table-bordered table-striped table-condensed table-hover">
              <thead>
                <tr style="background-color:#D1F9FF">
                  <th>S/N</th>
                  <th>Customer</th>
                  <th>Account Number</th>
                  <th>Interest Rate (%)</th>
                  <th>Balance Basis</th>
                  <th>Profit Amount</th>
                  <th>Withdrawals Total</th>
                  <th>Status</th>
                  <th>Reference</th>
                  <th>Month</th>
                  <th>Created At</th>
                </tr>
              </thead>
              <tbody>
                @php $i = 1; @endphp
                @forelse($montlys as $row)
                  <tr>
                    <td>{{ $i++ }}</td>
                    <td>
                      @if($row->customer)
                        {{ ucfirst(strtolower($row->customer->last_name)) }}
                        {{ ucfirst(strtolower($row->customer->first_name)) }}
                      @else
                        N/A
                      @endif
                    </td>
                    <td>{{ $row->account_number ?? 'N/A' }}</td>
                    <td>{{ number_format((float)$row->interest_rate_percent, 4) }}</td>
                    <td>{{ number_format((float)$row->balance_basis, 2) }}</td>
                    <td>{{ number_format((float)$row->profit_amount, 2) }}</td>
                    <td>{{ number_format((float)$row->withdrawals_total, 2) }}</td>
                    <td>
                      @php
                        $status = strtolower((string)$row->status);
                        $cls = $status === 'approved' ? 'label-success'
                             : ($status === 'pending' ? 'label-warning' : 'label-danger');
                        $text = $status === 'approved' ? 'Approved'
                              : ($status === 'pending' ? 'Pending' : ucfirst($status));
                      @endphp
                      <span class="label {{ $cls }}">{{ $text }}</span>
                    </td>
                    <td>{{ $row->reference ?? '—' }}</td>
                    <td>{{ $row->month ?? '—' }}</td>
                    <td>{{ optional($row->created_at)->format('d-m-Y h:ia') }}</td>
                  </tr>
                @empty
                  <tr>
                    <td colspan="11" class="text-center">No records found.</td>
                  </tr>
                @endforelse
              </tbody>
            </table>
          </div>

          {{-- simple label styles if not using Bootstrap labels --}}
          <style>
            .label { display:inline-block; padding:.25em .6em; font-size:85%; border-radius:.25rem; color:#fff }
            .label-success { background:#28a745 }
            .label-warning { background:#ffc107; color:#212529 }
            .label-danger  { background:#dc3545 }
          </style>

        </div>
      </div>
    </div>
  </div>
</div>
@endsection
