@extends('layout.app')

@section('title') NDIC Report @endsection
@section('pagetitle') NDIC Report @endsection

@section('content')
    <?php $getsetvalue = new \App\Models\Setting(); ?>
    <style>
        .form-step { display: none; }
        .form-active { display: block; }
        .width-70 { width: 70%; }
    </style>

    <div class="container">
        <div class="row" id="advanced-input">
            <div class="col-md-12">
                <div class="panel widget">
                    <div class="panel-heading"></div>
                    <div class="panel-body">
                        <form class="form-horizontal" id="ndicForm"
                              action="{{ route('report.ndic.export') }}"
                              method="post" enctype="multipart/form-data" role="form">
                            @csrf

                            {{-- STEP 1: Reporting Month --}}
                            <div class="form-step form-active" id="step1">
                                <h5 style="font-weight:900">Reporting Date Information</h5>

                                <div class="row">
                                    <div class="col-md-8 col-lg-8 col-sm-12">
                                        <div class="form-group" style="margin-bottom:10px">
                                            <label class="col-sm-4 control-label">Reporting Month:</label>
                                            <div class="col-sm-8 controls">
                                                <input class="width-70 form-control" type="month"
                                                       name="reporting_month" id="reporting_month" required>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                {{-- Optional explicit Next button --}}
                                <div class="row" style="float:right;margin-top:10px;">
                                    <button type="button" id="btnNext" class="btn btn-info btn-sm">
                                        Next <i class="fa fa-arrow-right"></i>
                                    </button>
                                </div>
                            </div>

                            {{-- STEP 2: Bank Details --}}
                            <div class="form-step" id="step2">
                                <h5 style="font-weight:900">Bank Details</h5>

                                <div class="form-group">
                                    <label class="col-sm-2 control-label">Type of Bank:</label>
                                    <div class="col-sm-7 controls">
                                        <input class="width-70 form-control" type="text" name="type_of_bank" value="MFB" required>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label class="col-sm-2 control-label">Name of the Bank:</label>
                                    <div class="col-sm-7 controls">
                                        <input class="width-70 form-control" type="text" name="bank_name" required
                                               value="{{ ucwords($getsetvalue->getsettingskey('company_name')) }}">
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label class="col-sm-2 control-label">Address of the Bank:</label>
                                    <div class="col-sm-7 controls">
                                        <input class="width-70 form-control" type="text" name="bank_address" required
                                               value="{{ $getsetvalue->getsettingskey('company_address') }}">
                                    </div>
                                </div>

                                <h6 style="font-weight:700;margin-left:15px;margin-top:10px">Managing Director</h6>
                                <div class="form-group">
                                    <label class="col-sm-2 control-label">Name:</label>
                                    <div class="col-sm-7 controls">
                                        <input class="width-70 form-control" type="text" name="md_name" required>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="col-sm-2 control-label">Contact No:</label>
                                    <div class="col-sm-7 controls">
                                        <input class="width-70 form-control" type="tel" name="md_phone" required>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="col-sm-2 control-label">Email Id:</label>
                                    <div class="col-sm-7 controls">
                                        <input class="width-70 form-control" type="email" name="md_email" required>
                                    </div>
                                </div>

                                <h6 style="font-weight:700;margin-left:15px;margin-top:10px">Chief Compliance Officer</h6>
                                <div class="form-group">
                                    <label class="col-sm-2 control-label">Name:</label>
                                    <div class="col-sm-7 controls">
                                        <input class="width-70 form-control" type="text" name="cco_name" required>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="col-sm-2 control-label">Contact No:</label>
                                    <div class="col-sm-7 controls">
                                        <input class="width-70 form-control" type="tel" name="cco_phone" required>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="col-sm-2 control-label">Email Id:</label>
                                    <div class="col-sm-7 controls">
                                        <input class="width-70 form-control" type="email" name="cco_email" required>
                                    </div>
                                </div>

                                <h6 style="font-weight:700;margin-left:15px;margin-top:10px">Chief Financial Officer</h6>
                                <div class="form-group">
                                    <label class="col-sm-2 control-label">Name:</label>
                                    <div class="col-sm-7 controls">
                                        <input class="width-70 form-control" type="text" name="cfo_name" required>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="col-sm-2 control-label">Contact No:</label>
                                    <div class="col-sm-7 controls">
                                        <input class="width-70 form-control" type="tel" name="cfo_phone" required>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="col-sm-2 control-label">Email Id:</label>
                                    <div class="col-sm-7 controls">
                                        <input class="width-70 form-control" type="email" name="cfo_email" required>
                                    </div>
                                </div>

                                <div class="row" style="float:right;margin-top:10px;">
                                    <button type="submit" class="btn btn-success btn-sm">
                                        Generate XLSX <i class="fa fa-file-excel-o"></i>
                                    </button>
                                </div>
                            </div>
                        </form>

                        {{-- Inline script so it runs even without @stack("scripts") --}}
                        <script>
                        (function(){
                            var step1 = document.getElementById('step1');
                            var step2 = document.getElementById('step2');
                            var monthInput = document.getElementById('reporting_month');
                            var nextBtn = document.getElementById('btnNext');

                            function showStep2(){
                                step1.classList.remove('form-active');
                                step2.classList.add('form-active');
                            }

                            function showStep1(){
                                step2.classList.remove('form-active');
                                step1.classList.add('form-active');
                            }

                            // Always start at Step 1
                            showStep1();

                            // Auto-advance if the month is already filled (browser memory / back nav)
                            if (monthInput && monthInput.value) {
                                showStep2();
                            }

                            // Advance when month changes/inputs
                            if (monthInput) {
                                monthInput.addEventListener('change', function(){ if (this.value) showStep2(); });
                                monthInput.addEventListener('input', function(){ if (this.value) showStep2(); });
                            }

                            // Explicit Next button
                            if (nextBtn) {
                                nextBtn.addEventListener('click', function(){
                                    if (monthInput && monthInput.checkValidity()) {
                                        showStep2();
                                    } else {
                                        monthInput.reportValidity();
                                    }
                                });
                            }
                        })();
                        </script>
                    </div> <!-- panel-body -->
                </div> <!-- panel -->
            </div>
        </div>
    </div>
@endsection
