@extends('layout.app')
@section('title')
    Trial Balance
@endsection
@section('pagetitle')
Trial Balance
@endsection
@section('content')
  <div class="container" style="@media print{width:100% !important;}">
    <?php
    $getsetvalue = new \App\Models\Setting();
   ?>
    @inject('getloan', 'App\Http\Controllers\ReportsController')

    <div class="row" id="advanced-input">
              <div class="col-md-12">
                <div class="panel widget">
                    <div class="panel-heading">
                        <div style="text-align: end">
                           {{-- <a href="{{route('branch.create')}}" class="btn btn-default"><span class="menu-icon"> <i class="fa fa-plus"></i> </span> Add Branch</a> --}}
                        </div>
                      </div>
                  <div class="panel-body">
                    <div class="noprint" style="margin-bottom: 15px">
                      <form action="{{route('report.trialbalance')}}" method="get" onsubmit="thisForm()">
                        <input type="hidden" name="filter" value="true">
                        <input type="hidden" name="bsheettyp" value="2">
                        <table class="table table-bordered table-hover table-sm">
                          <thead>
                            <tr>
                              <th>From Date</th>
                              <th>To Date</th>
                              <th>Display Zero Balance</th>
                              <th></th>
                            </tr>
                          </thead>
                          <tbody>
                            <tr>
                              <td>
                                <div class="form-group">
                                  <input type="date" name="datefrom" required id="" class="form-control" value="{{!empty($_GET['datefrom']) ? $_GET['datefrom'] : ''}}">
                                </div>
                              </td>
                              <td>
                                <div class="form-group">
                                  <input type="date" name="dateto" required id="" class="form-control" value="{{!empty($_GET['dateto']) ? $_GET['dateto'] : ''}}">
                                </div>
                              </td>
                              <td>
                                 <div class="form-group">
                                     <select name="zbalance" class="form-control" autocomplete="off">
                                          <option value="0" selected>No</option>
                                         <option value="1" {{!empty($_GET['zbalance']) && $_GET['zbalance'] == "1" ? "selected" : ''}}>Yes</option>
                                     </select>
                                </div>
                              </td>
                                 <td>
                                <button type="submit" class="btn btn-success btn-sm" id="btnsetsubmit">Generate Report</button>
                                <button type="button" class="btn btn-danger btn-sm" onclick="window.location.href='{{route('report.trialbalance')}}'">Reset</button>
                              </td>
                            </tr>
                          </tbody>
                        </table>
                      </form>
                    </div>

                      <div class="text-right noprint">
                        <button type="button" class="btn btn-info btn-sm" onclick="exporttoexcel()"><i class="fa fa-file-excel-o" aria-hidden="true"></i> Export To Excel</button>
                        <button type="button" class="btn btn-danger btn-sm" onclick="printsection()"><i class="fa fa-print" aria-hidden="true"></i> Print</button>
                      </div>
                      <div id="printdiv">
                        <div class="text-center">
                          <h3><strong>{{ucwords("trial balance report")}}</strong></h3>
                          <h5><strong>{{ucwords($getsetvalue->getsettingskey('company_name'))}}</strong></h5>

                          @if (!empty($_GET['filter']) && $_GET['filter'] == true)
                          <p><b>As At: {{date("d M, Y",strtotime($_GET['dateto']))}}</b></p>
                          @endif

                          <p><b>Generated On {{date('d M, Y')." at ".date('h:i:s')}}</b></p>
                        </div>
                        <div class="table-responsive">
                          <table id="balansheet" class="table table-striped table-bordered table-condensed" style="width: 100%">
                            <thead>
                                <tr>
                                    <th><b>Description</b></th>
                                    <th><b>GL Code</b></th>
                                    <th><b>Debit({{$getsetvalue->getsettingskey('currency_symbol')}})</b></th>
                                    <th><b>Credit({{$getsetvalue->getsettingskey('currency_symbol')}})</b></th>
                                </tr>
                            </thead>
                              <tbody>
                                <?php
                                $ataccate = DB::table('account_categories')->where('type','asset')->get();
                                $libaccate = DB::table('account_categories')->where('type','liability')->get();
                                $cpaccate = DB::table('account_categories')->where('type','capital')->get();

                                 $inaccate = DB::table('account_categories')->where('type','income')->get();
                                $expaccate = DB::table('account_categories')->where('type','expense')->get();

                                $asstbal = 0;
                                $libal = 0;
                                $capbal = 0;
                                $tbal = 0;

                                 $expbal = 0;
                                 $incmbal = 0;
                                ?>
                                <tr>
                                    <td><b>ASSETS</b></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                </tr>
                                    @foreach ($ataccate as $item)

                                            <?php
                                            if(request()->zbalance == '1'){
                                                $asstgls = DB::table('general_ledgers')->select('id','gl_name','gl_code')->where('account_category_id',$item->id)
                                                                                        ->where('status','1')
                                                                                      ->get();
                                            }else{
                                               $asstgls = DB::table('general_ledgers')->select('id','gl_name','gl_code')->where('account_category_id',$item->id)
                                                                                    ->where('status','1')
                                                                                    ->where('account_balance','!=','0')->get();
                                            }
                                            ?>

                                            @if (count($asstgls) > 0)
                                                    <tr style="padding:10px">
                                                <td class="text-primary" style="font-weight:bold; margin-top:5px;margin-bottom:10px; padding:8px">{{ucwords($item->name)}}</td>
                                                <td></td>
                                                <td></td>
                                                <td></td>
                                            </tr>
                                            @endif

                                       @if (!empty($_GET['filter']) && $_GET['filter'] == true)

                                              @foreach ($asstgls as $glitem)
                                               <tr>
                                                <td><span style="margin-left:15px">{{ucwords($glitem->gl_name)}}</span> </td>
                                                <td><span style="margin-left:15px">{{ucwords($glitem->gl_code)}}</span> </td>
                                                <td align="right">
                                                    <?php
                                                        $ascrtrnx = DB::table('savings_transaction_g_l_s')->where('general_ledger_id',$glitem->id)
                                                                                                             ->where('type','credit')
                                                                                                             ->where('status','approved')
                                                                                                         ->whereBetween('created_at',[request()->datefrom, request()->dateto])
                                                                                                         ->sum('amount');

                                                        $asdbtrnx = DB::table('savings_transaction_g_l_s')->where('general_ledger_id',$glitem->id)
                                                                                                             ->where('type','debit')
                                                                                                             ->where('status','approved')
                                                                                                         ->whereBetween('created_at',[request()->datefrom, request()->dateto])
                                                                                                         ->sum('amount');
                                                        $astrnx = $asdbtrnx - $ascrtrnx;
                                                      $asstbal += $astrnx;
                                                    ?>
                                                    <span style="text-align:right"><b>{{number_format($astrnx,2)}}</b></span>
                                                </td>
                                                <td align="right">0.00</td>
                                              </tr>
                                             @endforeach

                                             @else

                                             @foreach ($asstgls as $glitem)
                                               <tr>
                                                <td><span style="margin-left:15px">{{ucwords($glitem->gl_name)}}</span> </td>
                                                <td><span style="margin-left:15px">{{ucwords($glitem->gl_code)}}</span> </td>
                                                <td align="right">
                                                    <?php
                                                        $ascrtrnx = DB::table('savings_transaction_g_l_s')->where('general_ledger_id',$glitem->id)
                                                                                                             ->where('type','credit')
                                                                                                             ->where('status','approved')
                                                                                                         ->sum('amount');

                                                        $asdbtrnx = DB::table('savings_transaction_g_l_s')->where('general_ledger_id',$glitem->id)
                                                                                                             ->where('type','debit')
                                                                                                             ->where('status','approved')
                                                                                                         ->sum('amount');
                                                        $astrnx = $asdbtrnx - $ascrtrnx;
                                                      $asstbal += $astrnx;
                                                    ?>
                                                    <span style="text-align:right"><b>{{number_format($astrnx,2)}}</b></span>
                                                </td>
                                                <td align="right">0.00</td>
                                              </tr>
                                             @endforeach

                                             @endif

                                            @endforeach
                                            <tr>
                                            <td><h5 style="font-weight:bold;text-align:left">Total Assets</h5></td>
                                            <td></td>
                                            <td align="right"><b style="font-weight:bold;text-align:right" id="total-assets">{{number_format($asstbal,2)}}</b></td>
                                            <td align="right">0.00</td>
                                          </tr>

                                          <tr>
                                            <td><b>EXPENSES</b></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                        </tr>
                                            @foreach ($expaccate as $item)

                                                    <?php
                                                    if(request()->zbalance == '1'){
                                                        $expgls = DB::table('general_ledgers')->select('id','gl_name','gl_code')->where('account_category_id',$item->id)
                                                                                                ->where('status','1')
                                                                                              ->get();
                                                    }else{
                                                       $expgls = DB::table('general_ledgers')->select('id','gl_name','gl_code')->where('account_category_id',$item->id)
                                                                                            ->where('status','1')
                                                                                            ->where('account_balance','!=','0')->get();
                                                    }
                                                    ?>

                                                    @if (count($expgls) > 0)
                                                            <tr style="padding:10px">
                                                        <td class="text-primary" style="font-weight:bold; margin-top:5px;margin-bottom:10px; padding:8px">{{ucwords($item->name)}}</td>
                                                        <td></td>
                                                        <td></td>
                                                        <td></td>
                                                    </tr>
                                                    @endif

                                               @if (!empty($_GET['filter']) && $_GET['filter'] == true)

                                                      @foreach ($expgls as $glitem)
                                                       <tr>
                                                        <td><span style="margin-left:15px">{{ucwords($glitem->gl_name)}}</span> </td>
                                                        <td><span style="margin-left:15px">{{ucwords($glitem->gl_code)}}</span> </td>
                                                        <td align="right">
                                                            <?php
                                                                $expcrtrnx = DB::table('savings_transaction_g_l_s')->where('general_ledger_id',$glitem->id)
                                                                                                                     ->where('type','credit')
                                                                                                                     ->where('status','approved')
                                                                                                                 ->whereBetween('created_at',[request()->datefrom, request()->dateto])
                                                                                                                 ->sum('amount');

                                                                $expdbtrnx = DB::table('savings_transaction_g_l_s')->where('general_ledger_id',$glitem->id)
                                                                                                                     ->where('type','debit')
                                                                                                                     ->where('status','approved')
                                                                                                                 ->whereBetween('created_at',[request()->datefrom, request()->dateto])
                                                                                                                 ->sum('amount');
                                                            $exptrnx = $expdbtrnx - $expcrtrnx;
                                                            $expbal += $exptrnx;
                                                            ?>
                                                            <span style="text-align:right"><b>{{number_format($exptrnx,2)}}</b></span>
                                                        </td>
                                                        <td align="right">0.00</td>
                                                      </tr>
                                                     @endforeach

                                                     @else

                                                     @foreach ($expgls as $glitem)
                                                       <tr>
                                                        <td><span style="margin-left:15px">{{ucwords($glitem->gl_name)}}</span> </td>
                                                        <td><span style="margin-left:15px">{{ucwords($glitem->gl_code)}}</span> </td>
                                                        <td align="right">
                                                            <?php
                                                                $expcrtrnx = DB::table('savings_transaction_g_l_s')->where('general_ledger_id',$glitem->id)
                                                                                                                     ->where('type','credit')
                                                                                                                     ->where('status','approved')
                                                                                                                 ->sum('amount');

                                                                $expdbtrnx = DB::table('savings_transaction_g_l_s')->where('general_ledger_id',$glitem->id)
                                                                                                                     ->where('type','debit')
                                                                                                                     ->where('status','approved')
                                                                                                                 ->sum('amount');
                                                                $exptrnx = $expdbtrnx - $expcrtrnx;
                                                              $expbal += $exptrnx;
                                                            ?>
                                                            <span style="text-align:right"><b>{{number_format($exptrnx,2)}}</b></span>
                                                        </td>
                                                        <td align="right">0.00</td>
                                                      </tr>
                                                     @endforeach

                                                     @endif

                                                    @endforeach
                                                    <tr>
                                                    <td><h5 style="font-weight:bold;text-align:left">Total Expense</h5></td>
                                                    <td></td>
                                                    <td align="right"><b style="font-weight:bold;text-align:right" id="total-expense">{{number_format($expbal,2)}}</b></td>
                                                    <td align="right">0.00</td>
                                                  </tr>

                                          <tr>
                                            <td><b>LIABILITIES</b></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                          </tr>
                                                    @foreach ($libaccate as $item)

                                                    <?php
                                                    if(request()->zbalance == '1'){
                                                        $ligls = DB::table('general_ledgers')->select('id','gl_name','gl_code')->where('account_category_id',$item->id)
                                                                                                ->where('status','1')
                                                                                              ->get();
                                                    }else{
                                                       $ligls = DB::table('general_ledgers')->select('id','gl_name','gl_code')->where('account_category_id',$item->id)
                                                                                            ->where('status','1')
                                                                                            ->where('account_balance','!=','0')->get();
                                                    }
                                                    ?>

                                                 @if (count($ligls) > 0)

                                                  <tr style="padding:10px">
                                                    <td class="text-warning" style="font-weight:bold; margin-top:5px;margin-bottom:10px; padding:8px">{{ucwords($item->name)}}</td>
                                                    <td></td>
                                                    <td></td>
                                                    <td></td>
                                                </tr>

                                                 @endif

                                                  @if (!empty($_GET['filter']) && $_GET['filter'] == true)

                                                       @foreach ($ligls as $gllbitem)
                                                       <tr>
                                                        <td><span style="margin-left:15px">{{ucwords($gllbitem->gl_name)}}</span> </td>
                                                        <td><span style="margin-left:15px">{{ucwords($gllbitem->gl_code)}}</span> </td>
                                                        <td align="right">0.00</td>
                                                        <td align="right">
                                                            <?php
                                                                $lbcrtrnx = DB::table('savings_transaction_g_l_s')->where('general_ledger_id',$gllbitem->id)
                                                                                                                     ->where('type','credit')
                                                                                                                     ->where('status','approved')
                                                                                                                 ->whereBetween('created_at',[request()->datefrom, request()->dateto])
                                                                                                                 ->sum('amount');

                                                                $lbdbtrnx = DB::table('savings_transaction_g_l_s')->where('general_ledger_id',$gllbitem->id)
                                                                                                                     ->where('type','debit')
                                                                                                                     ->where('status','approved')
                                                                                                                 ->whereBetween('created_at',[request()->datefrom, request()->dateto])
                                                                                                                 ->sum('amount');
                                                            $lbtrnx = $lbcrtrnx - $lbdbtrnx;
                                                            $libal += $lbtrnx;
                                                            ?>
                                                            <span style="text-align:right"><b>{{number_format($lbtrnx,2)}}</b></span>
                                                        </td>
                                                      </tr>
                                                     @endforeach

                                                     @else

                                                     @foreach ($ligls as $gllbitem)
                                                     <tr>
                                                      <td><span style="margin-left:15px">{{ucwords($gllbitem->gl_name)}}</span> </td>
                                                      <td><span style="margin-left:15px">{{ucwords($gllbitem->gl_code)}}</span> </td>
                                                      <td align="right">0.00</td>
                                                      <td align="right">
                                                          <?php
                                                              $lbcrtrnx = DB::table('savings_transaction_g_l_s')->where('general_ledger_id',$gllbitem->id)
                                                                                                                   ->where('type','credit')
                                                                                                                   ->where('status','approved')
                                                                                                               ->sum('amount');

                                                              $lbdbtrnx = DB::table('savings_transaction_g_l_s')->where('general_ledger_id',$gllbitem->id)
                                                                                                                   ->where('type','debit')
                                                                                                                   ->where('status','approved')
                                                                                                               ->sum('amount');
                                                          $lbtrnx = $lbcrtrnx - $lbdbtrnx;
                                                          $libal += $lbtrnx;
                                                          ?>
                                                          <span style="text-align:right"><b>{{number_format($lbtrnx,2)}}</b></span>
                                                      </td>
                                                    </tr>
                                                   @endforeach

                                                     @endif
                                                    @endforeach
                                                    <tr>
                                                    <td><h5 style="font-weight:bold;text-align:left">Total Liabilities</h5></td>
                                                    <td></td>
                                                    <td align="right">0.00</td>
                                                    <td align="right"><b style="font-weight:bold;text-align:right" id="total-liabilities">{{number_format($libal,2)}}</b></td>
                                                  </tr>

                                            <tr>
                                                <td><b>CAPITAL</b> </td>
                                                <td></td>
                                                <td></td>
                                                <td></td>
                                             </tr>

                                            @foreach ($cpaccate as $item)

                                            <?php
                                            if(request()->zbalance == '1'){
                                                $cpacco = DB::table('general_ledgers')->select('id','gl_name','gl_code')->where('status','1')->where('account_category_id',$item->id)
                                                                                      ->get();
                                            }else{
                                               $cpacco = DB::table('general_ledgers')->select('id','gl_name','gl_code')->where('account_category_id',$item->id)
                                                                                      ->where('status','1')
                                                                                      ->where('account_balance','!=','0')
                                                                                      ->get();
                                            }
                                            ?>

                                            @if (count($cpacco) > 0)

                                                <tr>
                                                  <td class="text-danger" style="font-weight:bold; margin-top:5px;margin-bottom:10px; padding:8px">{{ucwords($item->name)}}</td>
                                              <td></td>
                                              <td></td>
                                              <td></td>
                                              </tr>

                                            @endif

                                    @if (!empty($_GET['filter']) && $_GET['filter'] == true)
                                             @foreach ($cpacco as $glcpitem)
                                             <tr>
                                                <td><span style="margin-left:15px">{{ucwords($glcpitem->gl_name)}}</span></td>
                                                <td><span style="margin-left:15px">{{ucwords($glcpitem->gl_code)}}</span></td>
                                                <td align="right">0.00</td>
                                                <td align="right">
                                                    <?php
                                                        $cpcrtrnx = DB::table('savings_transaction_g_l_s')->where('general_ledger_id',$glcpitem->id)
                                                                                                        ->where('type','credit')
                                                                                                        ->where('status','approved')
                                                                                                         ->whereBetween('created_at',[request()->datefrom, request()->dateto])
                                                                                                         ->sum('amount');

                                                        $cpdbtrnx = DB::table('savings_transaction_g_l_s')->where('general_ledger_id',$glcpitem->id)
                                                                                                        ->where('type','debit')
                                                                                                        ->where('status','approved')
                                                                                                         ->whereBetween('created_at',[request()->datefrom, request()->dateto])
                                                                                                         ->sum('amount');
                                                    $cptrnx = $cpcrtrnx - $cpdbtrnx;
                                                     $capbal += $cptrnx;
                                                    ?>
                                                   <span style="text-align:right"> <b>{{number_format($cptrnx,2)}}</b></span>

                                                </td>
                                            </tr>
                                             @endforeach

                                             @else

                                             @foreach ($cpacco as $glcpitem)
                                             <tr>
                                                <td><span style="margin-left:15px">{{ucwords($glcpitem->gl_name)}}</span></td>
                                                <td><span style="margin-left:15px">{{ucwords($glcpitem->gl_code)}}</span></td>
                                                <td align="right">0.00</td>
                                                <td align="right">
                                                    <?php
                                                        $cpcrtrnx = DB::table('savings_transaction_g_l_s')->where('general_ledger_id',$glcpitem->id)
                                                                                                        ->where('type','credit')
                                                                                                        ->where('status','approved')
                                                                                                         ->sum('amount');

                                                        $cpdbtrnx = DB::table('savings_transaction_g_l_s')->where('general_ledger_id',$glcpitem->id)
                                                                                                        ->where('type','debit')
                                                                                                        ->where('status','approved')
                                                                                                         ->sum('amount');
                                                    $cptrnx = $cpcrtrnx - $cpdbtrnx;
                                                     $capbal += $cptrnx;
                                                    ?>
                                                   <span style="text-align:right"> <b>{{number_format($cptrnx,2)}}</b></span>

                                                </td>
                                            </tr>
                                             @endforeach

                                             @endif
                                            @endforeach

                                           <tr>

                                            <td><h5 style="font-weight:bold;text-align:left">Total Capital</h5></td>
                                            <td></td>
                                            <td align="right">0.00</td>
                                            <td align="right"><b style="font-weight:bold;text-align:right" id="total-capital">{{number_format($capbal,2)}}</b></td>
                                          </tr>

                                          <tr>
                                            <td><b>INCOME</b> </td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                         </tr>

                                        @foreach ($inaccate as $item)

                                        <?php
                                        if(request()->zbalance == '1'){
                                            $incmacco = DB::table('general_ledgers')->select('id','gl_name','gl_code')->where('status','1')->where('account_category_id',$item->id)
                                                                                  ->get();
                                        }else{
                                           $incmacco = DB::table('general_ledgers')->select('id','gl_name','gl_code')->where('account_category_id',$item->id)
                                                                                  ->where('status','1')
                                                                                ->where('account_balance','!=','0')->get();
                                        }
                                        ?>

                                        @if (count($incmacco) > 0)

                                            <tr>
                                              <td class="text-danger" style="font-weight:bold; margin-top:5px;margin-bottom:10px; padding:8px">{{ucwords($item->name)}}</td>
                                          <td></td>
                                          <td></td>
                                          <td></td>
                                          </tr>

                                        @endif

                                @if (!empty($_GET['filter']) && $_GET['filter'] == true)
                                         @foreach ($incmacco as $glincmitem)
                                         <tr>
                                            <td><span style="margin-left:15px">{{ucwords($glincmitem->gl_name)}}</span></td>
                                            <td><span style="margin-left:15px">{{ucwords($glincmitem->gl_code)}}</span></td>
                                            <td align="right">0.00</td>
                                            <td align="right">
                                                <?php
                                                    $incmcrtrnx = DB::table('savings_transaction_g_l_s')->where('general_ledger_id',$glincmitem->id)
                                                                                                    ->where('type','credit')
                                                                                                    ->where('status','approved')
                                                                                                     ->whereBetween('created_at',[request()->datefrom, request()->dateto])
                                                                                                     ->sum('amount');

                                                    $incmdbtrnx = DB::table('savings_transaction_g_l_s')->where('general_ledger_id',$glincmitem->id)
                                                                                                    ->where('type','debit')
                                                                                                    ->where('status','approved')
                                                                                                     ->whereBetween('created_at',[request()->datefrom, request()->dateto])
                                                                                                     ->sum('amount');
                                                $incmtrnx = $incmcrtrnx - $incmdbtrnx;
                                                 $incmbal += $incmtrnx;
                                                ?>
                                               <span style="text-align:right"> <b>{{number_format($incmtrnx,2)}}</b></span>

                                            </td>
                                        </tr>
                                         @endforeach

                                         @else

                                         @foreach ($incmacco as $glincmitem)
                                         <tr>
                                            <td><span style="margin-left:15px">{{ucwords($glincmitem->gl_name)}}</span></td>
                                            <td><span style="margin-left:15px">{{ucwords($glincmitem->gl_code)}}</span></td>
                                            <td align="right">0.00</td>
                                            <td align="right">
                                                <?php
                                                    $incmcrtrnx = DB::table('savings_transaction_g_l_s')->where('general_ledger_id',$glincmitem->id)
                                                                                                    ->where('type','credit')
                                                                                                    ->where('status','approved')
                                                                                                     ->sum('amount');

                                                    $incmdbtrnx = DB::table('savings_transaction_g_l_s')->where('general_ledger_id',$glincmitem->id)
                                                                                                    ->where('type','debit')
                                                                                                    ->where('status','approved')
                                                                                                     ->sum('amount');
                                                $incmtrnx = $incmcrtrnx - $incmdbtrnx;
                                                 $incmbal += $incmtrnx;
                                                ?>
                                               <span style="text-align:right"> <b>{{number_format($incmtrnx,2)}}</b></span>

                                            </td>
                                        </tr>
                                         @endforeach

                                         @endif
                                        @endforeach

                                       <tr>

                                        <td><h5 style="font-weight:bold;text-align:left">Total Income</h5></td>
                                        <td></td>
                                        <td align="right">0.00</td>
                                        <td align="right"><b style="font-weight:bold;text-align:right" id="total-income">{{number_format($incmbal,2)}}</b></td>
                                      </tr>

                                      <!-- ADJUSTMENT row will be injected here by JS if needed -->
                                      <!-- BALANCED TOTAL row will be injected here by JS -->
                              </tbody>
                          </table>
                      </div>
                      </div>

                  </div>
                </div>
                <!-- Panel Widget -->
              </div>
              <!-- col-md-12 -->
            </div>
            <!-- row -->
  </div>
@endsection
@section('scripts')
<script>
    function printsection() {
     //document.getElementById("noprint").style.display='none';
   var divContents = document.getElementById("printdiv").innerHTML;
   var a = window.open('', '', 'height=500, width=500');
   a.document.write('<html>');
   a.document.write('<body>  @if (!empty($_GET["filter"]) && $_GET["filter"] == true)<h3>Trial Balance for the period: {{date("d M, Y",strtotime($_GET["datefrom"]))." To ".date("d M, Y",strtotime($_GET["dateto"]))}}</h3>@else <h3>Trial Balance</h3>@endif');
   a.document.write(divContents);
   a.document.write('</body></html>');
   a.document.close();
   a.print();
   }

   function exporttoexcel(){
       $("#balansheet").table2excel({
     exclude: ".excludeThisClass",
     name: "Trial_Balance_Report",
     filename: "Trial_Balance_Report.xls", // do include extension
     preserveColors: false // set to true if you want background colors and font colors preserved
 });
   }

   // ---------- Frontend balancing logic ----------
   document.addEventListener('DOMContentLoaded', function() {
       balanceTrial(); // run on load
   });

   function parseNumberFromCell(text) {
       if (!text) return 0;
       // remove commas, spaces, currency symbols, parentheses, etc.
       var cleaned = String(text).replace(/[^0-9\.\-]/g, '');
       if (cleaned === '' || cleaned === '.' || cleaned === '-')
           return 0;
       var val = parseFloat(cleaned);
       return isNaN(val) ? 0 : val;
   }

   function formatNumber(num) {
       return Number(num).toLocaleString(undefined, {minimumFractionDigits:2, maximumFractionDigits:2});
   }

   function removeExistingRows() {
       // remove previously added adjustment or balanced-total rows (idempotent)
       var prevAdj = document.getElementById('tb-adjustment-row');
       if (prevAdj) prevAdj.remove();
       var prevBal = document.getElementById('tb-balanced-total-row');
       if (prevBal) prevBal.remove();
   }

   function balanceTrial() {
       removeExistingRows();

       var tbody = document.querySelector('#balansheet tbody');
       if (!tbody) return;

       var rows = Array.from(tbody.querySelectorAll('tr'));

       var debitTotal = 0;
       var creditTotal = 0;

       // Identify GL rows by checking for a <span> inside the first td (this matches your template's GL rows)
       rows.forEach(function(row) {
           var firstTd = row.querySelector('td:first-child');
           if (!firstTd) return;

           // Only treat rows that have a span in the first td as GL detail rows
           if (firstTd.querySelector('span')) {
               var tds = row.querySelectorAll('td');
               // make sure we have at least 4 columns
               if (tds.length >= 4) {
                   var debitText = tds[2].innerText || tds[2].textContent || '';
                   var creditText = tds[3].innerText || tds[3].textContent || '';
                   var debitVal = parseNumberFromCell(debitText);
                   var creditVal = parseNumberFromCell(creditText);
                   debitTotal += debitVal;
                   creditTotal += creditVal;
               }
           }
       });

       // compute difference
       var diff = debitTotal - creditTotal;

       // where to insert adjustment and balanced total: after all rows in tbody
       // create adjustment row only if there is an imbalance
       if (Math.abs(diff) > 0.004) { // tolerance for floating precision
           var adjRow = document.createElement('tr');
           adjRow.id = 'tb-adjustment-row';
           // if positive => debit > credit => add adjustment on credit side
           if (diff > 0) {
               adjRow.innerHTML = '<td><b>Adjustment (Auto)</b></td>' +
                                  '<td></td>' +
                                  '<td align="right">0.00</td>' +
                                  '<td align="right"><b>' + formatNumber(diff) + '</b></td>';
           } else {
               // diff < 0 => credit > debit => add adjustment on debit side
               var absd = Math.abs(diff);
               adjRow.innerHTML = '<td><b>Adjustment (Auto)</b></td>' +
                                  '<td></td>' +
                                  '<td align="right"><b>' + formatNumber(absd) + '</b></td>' +
                                  '<td align="right">0.00</td>';
           }
           tbody.appendChild(adjRow);
       }

       // compute final balanced totals
       var finalDebit = debitTotal + (diff < 0 ? Math.abs(diff) : 0);
       var finalCredit = creditTotal + (diff > 0 ? diff : 0);
       var grandRow = document.createElement('tr');
       grandRow.id = 'tb-balanced-total-row';
       grandRow.innerHTML = '<td><h5 style="font-weight:bold;text-align:left">Balanced Total</h5></td>' +
                            '<td></td>' +
                            '<td align="right"><b style="font-weight:bold;text-align:right">' + formatNumber(finalDebit) + '</b></td>' +
                            '<td align="right"><b style="font-weight:bold;text-align:right">' + formatNumber(finalCredit) + '</b></td>';
       tbody.appendChild(grandRow);


   }
</script>
@endsection
