@extends('layout.app')

@section('title', 'CSV Export Preview')
@section('pagetitle', 'CSV Export Preview')

@section('content')
<div class="container">
  <div class="panel widget">
    <div class="panel-heading" style="display:flex; justify-content:space-between; align-items:center;">
      <h4 style="margin:0;">CSV Export Preview</h4>
      <a href="{{ url()->previous() }}" class="btn btn-default">Back</a>
    </div>

    <div class="panel-body">
      <p class="text-muted">This is only a preview. Use the CSV button to download the real file.</p>
      <div class="table-responsive">
        <table class="table table-bordered table-striped table-sm">
          <thead>
            <tr>
              <th>Code</th>
              <th>Name</th>
              <th>Account No</th>
              <th>Target Amount</th>
              <th>Save Amount</th>
              <th>Target Name</th>
              <th>Frequency</th>
              <th>Start Date</th>
              <th>Status</th>
            </tr>
          </thead>
          <tbody>
            @foreach($rows as $r)
              <tr>
                <td>{{ $r->code }}</td>
                <td>{{ ucwords(trim(($r->c_last_name ?? '').' '.($r->c_first_name ?? ''))) ?: 'N/A' }}</td>
                <td>{{ $r->account_number }}</td>
                <td>{{ number_format((float)$r->target_amount,2) }}</td>
                <td>{{ number_format((float)$r->auto_save_amount,2) }}</td>
                <td>{{ $r->savings_plan_name }}</td>
                <td>{{ ucfirst((string)$r->frequency) }}</td>
                <td>{{ $r->auto_save_start_date }}</td>
                <td>{{ ucfirst((string)$r->status) }}</td>
              </tr>
            @endforeach
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>
@endsection
