@extends('layout.app')

@section('title', 'Create Target Savings Products')
@section('pagetitle', 'Create Target Savings Products')

@section('content')
    <div class="container">
        <div class="row" id="advanced-input">
            <div class="col-md-12">
                <div class="panel widget">
                    <div class="panel-heading">
                        <div style="text-align: end">
                            <a href="{{ route('targetsavings.product') }}" class="btn btn-danger"><span class="menu-icon"> <i
                                        class="fa fa-angle-left"></i> </span> Back</a>
                        </div>
                    </div>
                    <div class="panel-body">
                        <div class="row">

                            
                        </div>
                        <form class="form-horizontal" action="{{ route('targetsavings.product.store') }}" method="post"
                            role="form" onsubmit="thisForm()">
                            @csrf

                            <div class="form-group">
                                <label class="col-sm-3 control-label">Name</label>
                                <div class="col-sm-7 controls">
                                    <input class="form-control width-70" required="required" name="name" type="text"
                                        id="name" value="{{ old('name') }}" placeholder="Product name">
                                </div>
                            </div>

                            <div class="form-group">
                                <label class="col-sm-3 control-label">Minimum Target Deposit</label>
                                <div class="col-sm-7 controls">
                                    <!-- Visible, formatted with commas -->
                                    <input class="form-control width-70" placeholder="Min Deposit" required
                                        id="minimum_deposit_display" type="text" inputmode="decimal"
                                        value="{{ old('minimum_target_deposit') }}"
                                        oninput="formatCurrencyInput(this, 'minimum_target_deposit')">

                                    <!-- Hidden, real numeric value submitted to server -->
                                    <input type="hidden" name="minimum_target_deposit" id="minimum_target_deposit"
                                        value="{{ old('minimum_target_deposit') }}">
                                </div>
                            </div>

                            <div class="form-group">
                                <label class="col-sm-3 control-label">Interest Rate (%)</label>
                                <div class="col-sm-7 controls">
                                    <input class="form-control width-70" placeholder="Interest Rate" required
                                        name="interest_rate" id="interest_rate" type="text" inputmode="decimal"
                                        step="0.001" min="0" max="100" value="{{ old('interest_rate') }}"
                                        oninput="this.value = this.value.replace(/[^0-9.]/g,'').replace(/(\..*)\./g,'$1')" />

                                </div>
                            </div>

                            <div class="form-group">
                                <label class="col-sm-3 control-label">Minimum Hold Days</label>
                                <div class="col-sm-7 controls">
                                    <input class="form-control width-70" placeholder="Mini Hold Days before Terminate"
                                        required name="minimum_hold_days" id="minimum_hold_days" type="number"
                                        inputmode="numeric" step="1" min="30"
                                        value="{{ old('minimum_hold_days', 30) }}"
                                        oninput="this.value = this.value.replace(/[^0-9]/g,'')">
                                </div>
                            </div>



                            <div class="form-group form-actions">
                                <div class="col-sm-4"> </div>
                                <div class="col-sm-7">
                                    <button class="btn vd_btn vd_bg-green vd_white" type="submit" id="btnssubmit"><i
                                            class="icon-ok"></i>Save Record</button>

                                </div>
                            </div>
                        </form>
                    </div>
                </div>
                <!-- Panel Widget -->
            </div>
            <!-- col-md-12 -->
        </div>
        <!-- row -->
    </div>




    <script>
        function formatCurrencyInput(displayEl, hiddenId) {
            // keep only digits and dot
            const raw = displayEl.value.replace(/[^0-9.]/g, '');
            // split integer and decimal
            const parts = raw.split('.');
            let intPart = parts[0] || '';
            const decPart = parts[1] !== undefined ? parts[1].slice(0, 2) : undefined; // 2 d.p.

            // add thousand separators to integer part
            intPart = intPart.replace(/^0+(?=\d)/, ''); // trim leading zeros (but allow "0.xx")
            const formattedInt = intPart ? Number(intPart).toLocaleString() : '';

            // rebuild display value
            displayEl.value = decPart !== undefined ? `${formattedInt}.${decPart}` : formattedInt;

            // set hidden raw numeric value
            const hidden = document.getElementById(hiddenId);
            hidden.value = decPart !== undefined ?
                `${intPart || 0}.${decPart.padEnd(2, '0')}` :
                (intPart || 0);
        }

        // Initialize formatting on page load (for old() values)
        document.addEventListener('DOMContentLoaded', function() {
            const display = document.getElementById('minimum_deposit_display');
            if (display) formatCurrencyInput(display, 'minimum_target_deposit');
        });
    </script>
@endsection
