@extends('layout.app')

@section('title', 'Target Savings Details')
@section('pagetitle', 'Target Savings Details')

@section('content')
    <div class="container">
        <div class="row" id="advanced-input">
            <div class="col-md-12">
                <div class="panel widget">
                    <div class="panel-heading d-flex justify-content-between align-items-center"
                        style="display:flex; justify-content:space-between; align-items:center;">
                        <h4 class="panel-title" style="margin:0;"></h4>
                        <div>
                            <a href="{{ route('targetsavings.manage') }}" class="btn btn-danger"
                                style="padding:.8rem 1.3rem; font-weight:600;">
                                <i class="fa fa-angle-left"></i> Back
                            </a>
                        </div>

                    </div>

                    <div class="panel-body">
                        <div class="row">
                            <div class="col-md-7 col-lg-7 col-sm-12">
                                @include('includes.errors')
                                @include('includes.success')
                            </div>
                        </div>
                        <div class="row align-items-start">
                            <!-- LEFT COLUMN -->
                            <div class="col-md-4 col-lg-4 col-sm-12">
                                <div class="row">
                                    <div class="col-md-4 col-lg-4 col-sm-4">
                                        <img class="img-circle" src="/img/avater.webp" width="90" height="90"
                                            alt="customer photo" />
                                    </div>
                                    <div class="col-md-8 col-lg-8 col-sm-12" style="text-align:left;">
                                        <p style="font-size:13px;font-weight:700; color:#000000">
                                            Name: {{ $customer['first_name'] }} {{ $customer['last_name'] }}
                                        </p>
                                        <p style="font-size:13px;font-weight:700; color:#000000">
                                            Account Number: {{ number_format($customer['account_balance'], 2) }}
                                        </p>
                                        <p style="font-size:13px;font-weight:700; color:#000000">
                                            Business Name: {{ $customer['business_name'] ?? 'Nil' }}
                                        </p>
                                        <p style="font-size:13px;font-weight:700; color:#000000">
                                            Occupation: {{ $customer['occupation'] }}
                                        </p>
                                        <p style="font-size:13px;font-weight:700; color:#000000">
                                            Gender: {{ $customer['gender'] }}
                                        </p>
                                    </div>
                                </div>

                                <!-- ACCOUNT OFFICER MOVED BELOW -->
                                <div style="margin-top:10px;">
                                    <p style="font-size:13px;font-weight:700; color:#000000">
                                        Account Officer: {{ $customer['account_officer'] }}
                                    </p>
                                </div>
                            </div>

                            <!-- MIDDLE COLUMN -->
                            <div class="col-md-4 col-lg-4 col-sm-12">
                                <p style="font-size:13px;font-weight:700; color:#000000">Phone: {{ $customer['phone'] }}</p>
                                <p style="font-size:13px;font-weight:700; color:#000000">Email: {{ $customer['email'] }}</p>
                                <p style="font-size:13px;font-weight:700; color:#000000">Address:
                                    {{ $customer['residential_address'] }}</p>
                                <p style="font-size:13px;font-weight:700; color:#000000">State: {{ $customer['state'] }}
                                </p>
                                <p style="font-size:13px;font-weight:700; color:#000000">LGA: {{ $customer['state_lga'] }}
                                </p>
                            </div>

                            <!-- RIGHT COLUMN: FLEX BUTTONS -->
                            <div class="col-md-4 col-lg-4 col-sm-12">
                                <div
                                    style="
                                            display:flex;
                                            flex-wrap:wrap;
                                            gap:10px;
                                            justify-content:flex-start;
                                            align-items:center;
                                        ">
                                    @if ($target->status !== 'rejected')
                                        @if ($target->status === 'pending')
                                            @if ($target->user_id !== auth()->id())
                                                <a href="{{ route('targetsavings.approve', $target->id) }}"
                                                    class="btn btn-success" style="padding:.8rem 1.3rem; font-weight:600;">
                                                    <i class="fa fa-check"></i> Approve
                                                </a>

                                                <a href="{{ route('targetsavings.reject', $target->id) }}"
                                                    class="btn btn-danger" style="padding:.8rem 1.3rem; font-weight:600;">
                                                    <i class="fa fa-times"></i> Reject
                                                </a>
                                            @endif
                                        @else
                                            @if ($target->status === 'approved')
                                                <a href="{{ route('targetsavings.terminate', $target->id) }}"
                                                    class="btn btn-warning text-white"
                                                    style="padding:.8rem 1.3rem; font-weight:600;">
                                                    <i class="fa fa-ban"></i> Terminate
                                                </a>
                                            @endif
                                        @endif
                                    @endif
                                </div>
                            </div>
                        </div>

                        <hr>

                        <!-- ========================= -->
                        <!--   TARGET SAVINGS SUMMARY  -->
                        <!-- ========================= -->
                        @php
                            $status = strtolower($target->status ?? 'pending');
                            $colorClass = match ($status) {
                                'active' => 'color:#198754;',
                                'pending' => 'color:#f0ad4e;',
                                'terminate' => 'color:#dc3545;',
                                'reject' => 'color:#dc3545;',
                                'closed', 'close' => 'color:#0d6efd;',
                                default => 'color:#6c757d;',
                            };
                        @endphp

                        <div class="row" style="margin-bottom:10px;">
                            <div class="col-sm-12" style="display:flex;gap:18px;align-items:center;flex-wrap:wrap;">
                                <span style="font-weight:700; {{ $colorClass }}">
                                    {{ ucfirst($target->status ?? '—') }}
                                </span>
                                <span class="text-muted">Code: <b>{{ $target->code ?? '—' }}</b></span>
                                <span class="text-muted">Account: <b>{{ $target->account_number ?? '—' }}</b></span>
                                <span class="text-muted">Created:
                                    <b>{{ $target->created_at?->format('d M, Y h:ia') ?? '—' }}</b>
                                </span>
                                <span class="text-muted">Last Update:
                                    <b>{{ $target->updated_at?->format('d M, Y h:ia') ?? '—' }}</b>
                                </span>
                            </div>
                        </div>

                        <!-- SUMMARY TABLE -->
                        <div class="table-responsive">
                            <table class="table table-striped table-sm table-bordered table-condensed table-hover">
                                <thead>
                                    <tr style="background-color:#D1F9FF">
                                        <th>Target Code</th>
                                        <th>Start Date</th>
                                        <th>Frequency</th>
                                        <th>Target (₦)</th>
                                        <th>Auto Save Amount (₦)</th>

                                        <th>Interest (%)</th>
                                        <th>Total Accrued Interest (₦)</th>
                                        <th>Total Saved (₦)</th>
                                        <th>Status</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>{{ $target->code ?? '—' }}</td>
                                        <td>{{ $target->auto_save_start_date ? \Carbon\Carbon::parse($target->start_date)->format('d-m-Y') : '—' }}
                                        </td>
                                        <td>{{ ucfirst($target->frequency ?? '—') }}</td>
                                        <td>₦{{ number_format((float) ($target->target_amount ?? 0), 2) }}</td>
                                        <td>₦{{ number_format((float) ($target->auto_save_amount ?? 0), 2) }}</td>
                                        <td>{{ $product->interest_rate ?? '—' }}%</td>
                                        <td>₦{{ number_format((float) ($target->total_accrued_interest ?? 0), 2) }}</td>
                                        <td>₦{{ number_format((float) ($target->total_amount_saved ?? 0), 2) }}</td>
                                        <td><span
                                                style="font-weight:700; {{ $colorClass }}">{{ ucfirst($target->status ?? '—') }}</span>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>

                        <hr>



                        <hr>


                        <div class="table-responsive">
                            <table class="table"
                                style="border:none; border-collapse:separate; border-spacing:0 6px; width:100%;">
                                <tbody>
                                    @php
                                        $fmtDate = fn($d) => $d
                                            ? \Carbon\Carbon::parse($d)->format('d M, Y h:ia')
                                            : '—';
                                        $fmtDateShort = fn($d) => $d
                                            ? \Carbon\Carbon::parse($d)->format('d M, Y')
                                            : '—';
                                        $money = fn($n) => '₦' . number_format((float) ($n ?? 0), 2);

                                        $fields = [
                                            ['Plan Name', $target->savings_plan_name ?? '—'],
                                            [
                                                'Product',
                                                ($product->name ?? '—') . ' (' . ($product->product_code ?? '—') . ')',
                                            ],

                                            ['Auto Save', $target->auto_save ?? false ? 'Yes' : 'No'],
                                            ['Auto Save Start', $fmtDateShort($target->auto_save_start_date ?? null)],
                                            [
                                                'Duration',
                                                ($target->duration ?? 0) .
                                                ' ' .
                                                (($target->duration_unit ?? 'month') .
                                                    (($target->duration ?? 0) > 1 ? 's' : '')),
                                            ],

                                            ['Funding Source', $target->funding_source_type ?? '—'],
                                            ['Currency', $target->currency ?? 'NGN'],
                                            ['Target Code', $target->code ?? '—'],

                                            ['Customer ID', $target->customer_id ?? '—'],
                                            ['User ID', $target->user_id ?? '—'],
                                            ['Product ID', $target->target_savings_products_id ?? '—'],

                                            ['Account Number', $target->account_number ?? '—'],
                                            ['Target Amount', $money($target->target_amount ?? 0)],
                                            ['Frequency', ucfirst($target->frequency ?? '—')],

                                            ['Save Now Amount', $money($target->auto_save_amount ?? 0)],
                                            ['Status', ucfirst($target->status ?? '—')],
                                            ['Start Date', $fmtDateShort($target->start_date ?? null)],

                                            ['Maturity Date', $fmtDateShort($target->maturity_date ?? null)],
                                            ['Interest Method', ucfirst($target->interest_method ?? '—')],
                                            ['Amount Saved', $money($target->total_amount_saved ?? 0)],

                                            ['Amount Paid Out', $money($target->amount_paid_out ?? 0)],
                                            ['Accrued Interest', $money($target->total_accrued_interest ?? 0)],
                                            ['Created By', $target->created_by ?? '—'],

                                            ['Approved By', $target->approved_by ?? '—'],
                                            ['Declined By', $target->declined_by ?? '—'],
                                            // ['Terminated By', $target->use9

                                            ['Updated By', $target->updated_by ?? '—'],
                                            ['Created Date', $fmtDate($target->created_date ?? null)],
                                            ['Updated Date', $fmtDate($target->updated_date ?? null)],

                                            ['Approved At', $fmtDate($target->approved_at ?? null)],
                                            ['Declined At', $fmtDate($target->declined_at ?? null)],
                                            ['Terminated At', $fmtDate($target->terminate_at ?? null)],

                                            ['Created At', $fmtDate($target->created_at ?? null)],
                                            ['Updated At', $fmtDate($target->updated_at ?? null)],
                                            [
                                                'Metadata',
                                                $target->metadata
                                                    ? (is_array($target->metadata)
                                                        ? json_encode($target->metadata)
                                                        : (string) $target->metadata)
                                                    : '—',
                                            ],
                                        ];
                                    @endphp

                                    {{-- Render 3 columns per row --}}
                                    @foreach (collect($fields)->chunk(3) as $row)
                                        <tr style="border-bottom:1px solid #f3f3f3;">
                                            @foreach ($row as $i => [$label, $value])
                                                <td
                                                    style="
              width:33%;
              padding:10px 16px;
              vertical-align:top;
              border-right:{{ $i < 2 ? '2px solid #cfd3d7' : 'none' }};
            ">
                                                    <div style="display:flex; align-items:flex-start; gap:6px;">
                                                        <span
                                                            style="min-width:140px; color:#6c757d; font-weight:500; flex-shrink:0;">
                                                            {{ $label }}:
                                                        </span>
                                                        <span style="color:#000; font-weight:600; flex:1; text-align:left;">
                                                            {{ $value }}
                                                        </span>
                                                    </div>
                                                </td>
                                            @endforeach

                                            {{-- Fill remaining columns if less than 3 --}}
                                            @for ($i = count($row); $i < 3; $i++)
                                                <td style="width:33%; padding:10px 16px;"></td>
                                            @endfor
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>

                        <hr>

                        <div class="table-responsive">
                            <h3>Schedules</h3>
                            <table class="table table-striped table-sm table-bordered table-condensed table-hover">
                                <thead>
                                    <tr style="background-color:#D1F9FF">
                                        <th>Schedule No</th>
                                        <th>Target Code</th>
                                        <th>Amount (₦)</th>
                                        <th>Due Date</th>
                                        <th>Status</th>
                                        <th>Disbursed By</th>
                                        <th>Disbursed At</th>
                                        <th>Paid At</th>
                                        <th>Updated At</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse ($schedules as $item)
                                        <tr>
                                            <td>{{ $item->schedule_no ?? '—' }}</td>
                                            <td>{{ $item->target_savings_code ?? '—' }}</td>
                                            <td>{{ number_format((float) $item->amount, 2) }}</td>
                                            <td>{{ $item->due_date ? \Carbon\Carbon::parse($item->due_date)->format('d M, Y') : '—' }}
                                            </td>
                                            <td>{{ ucfirst($item->status ?? '—') }}</td>
                                            <td>{{ $item->disbursed_by ?? '—' }}</td>
                                            <td>
                                                {{ $item->disbursed_at ? \Carbon\Carbon::parse($item->disbursed_at)->format('d M, Y H:i') : '—' }}
                                            </td>
                                            <td>
                                                {{ $item->paid_at ? \Carbon\Carbon::parse($item->paid_at)->format('d M, Y H:i') : '—' }}
                                            </td>
                                            <td>
                                                {{ $item->updated_at ? \Carbon\Carbon::parse($item->updated_at)->format('d M, Y H:i') : '—' }}
                                            </td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="9" class="text-center text-muted">
                                                No schedules found.
                                            </td>
                                        </tr>
                                    @endforelse
                                </tbody>
                            </table>

                        </div>

                    </div> <!-- panel-body -->
                </div> <!-- panel -->
            </div> <!-- col -->
        </div> <!-- row -->
    </div> <!-- container -->
@endsection
