@extends('layout.app')
@section('title')
    Create User
@endsection
@section('pagetitle')
    Create User
@endsection
@section('content')
    <div class="container">
        <div class="row" id="advanced-input">
            <div class="col-md-12">
                <div class="panel widget">
                    <div class="panel-heading">
                        <div style="text-align: end">
                            <a href="{{ route('user.all') }}" class="btn btn-danger"><span class="menu-icon"> <i
                                        class="fa fa-angle-left"></i> </span> Back</a>
                        </div>
                    </div>
                    <div class="panel-body">
                        <div class="row">
                            <div class="col-md-7 col-lg-7 col-sm-12">
                                @include('includes.errors')
                                @include('includes.success')
                            </div>
                        </div>
                        <form class="form-horizontal" action="{{ route('user.store') }}" method="post" role="form"
                            id="addusers" enctype="multipart/form-data">
                            @csrf

                            {{-- First Name --}}
                            <div class="form-group">
                                <label class="col-sm-2 control-label">First Name</label>
                                <div class="col-sm-7 controls">
                                    <input class="width-70" type="text" name="first_name" value="{{ old('first_name') }}"
                                        placeholder="Enter First Name" autocomplete="off">

                                </div>
                            </div>

                            {{-- Last Name --}}
                            <div class="form-group">
                                <label class="col-sm-2 control-label">Last Name</label>
                                <div class="col-sm-7 controls">
                                    <input class="width-70" type="text" name="last_name" value="{{ old('last_name') }}"
                                        placeholder="Enter Last Name" autocomplete="off">

                       
                                </div>
                            </div>

                            {{-- Username --}}
                            <div class="form-group">
                                <label class="col-sm-2 control-label">Username</label>
                                <div class="col-sm-7 controls">
                                    <input class="width-70" type="text" name="username" value="{{ old('username') }}"
                                        placeholder="Enter User Name" autocomplete="off">

                               
                                </div>
                            </div>

                            {{-- Email --}}
                            <div class="form-group">
                                <label class="col-sm-2 control-label">Email</label>
                                <div class="col-sm-7 controls">
                                    <input class="width-70" type="email" name="email" value="{{ old('email') }}"
                                        placeholder="Enter Email" autocomplete="off">

                                </div>
                            </div>

                            {{-- Gender --}}
                            <div class="form-group">
                                <label class="col-sm-2 control-label">Gender</label>
                                <div class="col-sm-7 controls">
                                    <select class="width-70" name="gender">
                                        <option disabled selected>Select...</option>
                                        <option value="male" {{ old('gender') == 'male' ? 'selected' : '' }}>Male
                                        </option>
                                        <option value="female" {{ old('gender') == 'female' ? 'selected' : '' }}>Female
                                        </option>
                                    </select>

                                  
                                </div>
                            </div>

                            {{-- Account Type (System Only) --}}
                            @if (Auth::user()->account_type === 'system')
                                <div class="form-group">
                                    <label class="col-sm-2 control-label">Account Type</label>
                                    <div class="col-sm-7 controls">
                                        <select class="width-70" name="account_type">
                                            <option disabled selected>Select...</option>
                                            <option value="system" {{ old('account_type') == 'system' ? 'selected' : '' }}>
                                                System Admin
                                            </option>
                                            <option value="user" {{ old('account_type') == 'user' ? 'selected' : '' }}>
                                                User
                                            </option>
                                        </select>

                                    
                                    </div>
                                </div>
                            @endif

                            {{-- Phone --}}
                            <div class="form-group">
                                <label class="col-sm-2 control-label">Phone</label>
                                <div class="col-sm-7 controls">
                                    <input class="width-70" type="text" name="phone" value="{{ old('phone') }}"
                                        placeholder="Enter Phone" autocomplete="off">

                                
                                </div>
                            </div>

                            {{-- Address --}}
                            <div class="form-group">
                                <label class="col-sm-2 control-label">Address</label>
                                <div class="col-sm-7 controls">
                                    <input class="width-70" type="text" name="address" value="{{ old('address') }}"
                                        placeholder="Enter Address" autocomplete="off">

                               
                                </div>
                            </div>

                            {{-- Password (Auto Generated) --}}
                            <div class="form-group">
                                <label class="col-sm-2 control-label">Password</label>
                                <div class="col-sm-7 controls">
                                    <input class="width-70" type="text" name="password" readonly
                                        value="{{ mt_rand(11111111, 99999999) }}">

                                </div>
                            </div>

                            {{-- Role --}}
                            <div class="form-group">
                                <label class="col-sm-2 control-label">Role</label>
                                <div class="col-sm-7 controls">
                                    <select class="width-70" name="role">
                                        <option disabled selected>Select Role...</option>
                                        @foreach ($roles as $role)
                                            <option value="{{ $role->id }}"
                                                {{ old('role') == $role->id ? 'selected' : '' }}>
                                                {{ $role->name }}
                                            </option>
                                        @endforeach
                                    </select>

                                 
                                </div>
                            </div>

                            {{-- Submit --}}
                            <div class="form-group form-actions">
                                <div class="col-sm-4"></div>
                                <div class="col-sm-7">
                                    <button class="btn vd_btn vd_bg-green vd_white" type="submit">
                                        <i class="icon-ok"></i> Save Record
                                    </button>
                                </div>
                            </div>

                        </form>

                    </div>
                </div>
                <!-- Panel Widget -->
            </div>
            <!-- col-md-12 -->
        </div>
        <!-- row -->
    </div>
@endsection
