<?php $__env->startSection('title'); ?>
    System Analysis
<?php $__env->stopSection(); ?>

<?php $__env->startSection('pagetitle'); ?>
    System Analysis
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="container">
        <div class="row" id="advanced-input">
            <div class="col-md-12">
                <div class="panel widget">
                    <div class="panel-heading">
                        <h3 class="panel-title text-danger">System Performance & Memory Analysis</h3>
                    </div>

                    <div class="panel-body">

                        
                        <div class="row" style="margin-bottom:20px;">
                            <div class="col-sm-3">
                                <div class="well text-center">
                                    <div class="h4"><?php echo e($summary['total_entries']); ?></div>
                                    <div class="text-muted">Total Samples (memprof.log)</div>
                                </div>
                            </div>
                            <div class="col-sm-3">
                                <div class="well text-center">
                                    <div class="h4"><?php echo e($summary['total_routes']); ?></div>
                                    <div class="text-muted">Unique Endpoints</div>
                                </div>
                            </div>
                            <div class="col-sm-3">
                                <div class="well text-center">
                                    <?php if($summary['most_called']): ?>
                                        <div class="small text-muted">Most Called Route</div>
                                        <div style="font-size:12px; word-break:break-all;">
                                            <?php echo e($summary['most_called']['route']); ?>

                                        </div>
                                        <div class="small text-muted">
                                            <?php echo e($summary['most_called']['count']); ?> calls
                                            (<?php echo e(number_format($summary['most_called']['percentage'], 1)); ?>%)
                                        </div>
                                    <?php else: ?>
                                        <div class="text-muted">No Data</div>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="col-sm-3">
                                <div class="well text-center">
                                    <?php if($summary['slowest_route']): ?>
                                        <div class="small text-muted">Slowest (Avg)</div>
                                        <div style="font-size:12px; word-break:break-all;">
                                            <?php echo e($summary['slowest_route']['route']); ?>

                                        </div>
                                        <div class="small text-muted">
                                            <?php echo e(number_format($summary['slowest_route']['avg_duration'], 1)); ?> ms avg
                                        </div>
                                    <?php else: ?>
                                        <div class="text-muted">No Data</div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>

                        <?php if($summary['total_entries'] == 0): ?>
                            <p class="text-muted">
                                No data found in <code>storage/logs/memprof.log</code>.
                                Make sure your profiler is writing JSON lines into this file.
                            </p>
                        <?php else: ?>
                            <div class="row">

                                
                                <div class="col-sm-6">
                                    <h4>Most Called Routes</h4>
                                    <div class="table-responsive" style="max-height: 55vh; overflow:auto;">
                                        <table class="table table-striped table-condensed">
                                            <thead>
                                            <tr>
                                                <th>#</th>
                                                <th>Route</th>
                                                <th class="text-right">Calls</th>
                                                <th class="text-right">% of Total</th>
                                                <th class="text-right">Avg Time (ms)</th>
                                                <th class="text-right">Avg Mem</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <?php $__empty_1 = true; $__currentLoopData = $byCount; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                <tr>
                                                    <td>
                                                        <?php echo e($byCount->firstItem() + $index); ?>

                                                    </td>
                                                    <td style="max-width: 220px; word-break: break-all;">
                                                        <?php if(!empty($row['is_api']) && $row['is_api']): ?>
                                                            <span class="label label-info">API</span>
                                                        <?php endif; ?>
                                                        <?php echo e($row['route']); ?>

                                                    </td>
                                                    <td class="text-right"><?php echo e($row['count']); ?></td>
                                                    <td class="text-right">
                                                        <?php echo e(number_format($row['percentage'], 1)); ?>%
                                                    </td>
                                                    <td class="text-right">
                                                        <?php echo e(number_format($row['avg_duration'], 1)); ?>

                                                    </td>
                                                    <td class="text-right">
                                                        <?php echo e(number_format($row['avg_memory'], 2)); ?>

                                                    </td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                <tr>
                                                    <td colspan="6" class="text-muted text-center">
                                                        No route data available.
                                                    </td>
                                                </tr>
                                            <?php endif; ?>
                                            </tbody>
                                        </table>
                                    </div>

                                    
                                    <div class="text-center">
                                        <?php echo e($byCount->links()); ?>

                                    </div>
                                </div>

                                
                                <div class="col-sm-6">
                                    <h4>Slowest Routes (Avg Duration)</h4>
                                    <div class="table-responsive" style="max-height: 55vh; overflow:auto;">
                                        <table class="table table-striped table-condensed">
                                            <thead>
                                            <tr>
                                                <th>#</th>
                                                <th>Route</th>
                                                <th class="text-right">Calls</th>
                                                <th class="text-right">Avg Time (ms)</th>
                                                <th class="text-right">Max Time (ms)</th>
                                                <th class="text-right">Max Mem</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <?php $__empty_1 = true; $__currentLoopData = $byAvgDuration; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                <tr>
                                                    <td>
                                                        <?php echo e($byAvgDuration->firstItem() + $index); ?>

                                                    </td>
                                                    <td style="max-width: 220px; word-break: break-all;">
                                                        <?php if(!empty($row['is_api']) && $row['is_api']): ?>
                                                            <span class="label label-info">API</span>
                                                        <?php endif; ?>
                                                        <?php echo e($row['route']); ?>

                                                    </td>
                                                    <td class="text-right"><?php echo e($row['count']); ?></td>
                                                    <td class="text-right">
                                                        <?php echo e(number_format($row['avg_duration'], 1)); ?>

                                                    </td>
                                                    <td class="text-right">
                                                        <?php echo e(number_format($row['max_duration'], 1)); ?>

                                                    </td>
                                                    <td class="text-right">
                                                        <?php echo e(number_format($row['max_memory'], 2)); ?>

                                                    </td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                <tr>
                                                    <td colspan="6" class="text-muted text-center">
                                                        No route data available.
                                                    </td>
                                                </tr>
                                            <?php endif; ?>
                                            </tbody>
                                        </table>
                                    </div>

                                    
                                    <div class="text-center">
                                        <?php echo e($byAvgDuration->links()); ?>

                                    </div>
                                </div>

                            </div>
                        <?php endif; ?>

                    </div> 
                </div> 
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /app/resources/views/system/analysis.blade.php ENDPATH**/ ?>