
<?php if (! $__env->hasRenderedOnce('1b89af11-c3b6-495e-9dbd-804862cd4a28')): $__env->markAsRenderedOnce('1b89af11-c3b6-495e-9dbd-804862cd4a28'); ?>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css"/>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>

  <?php
    // Collect common flash keys Laravel apps use
    $flashKeys = ['success','error','warning','info','status','message','danger','primary'];
    $flashes = [];
    foreach ($flashKeys as $k) {
        if (session()->has($k)) {
            $val = session($k);
            // Normalize arrays to a single string with new lines
            if (is_array($val)) {
                $val = implode("\n", $val);
            }
            $flashes[$k] = $val;
        }
    }
  ?>

  <script>
    // ---------- Toastr defaults ----------
    toastr.options = {
      closeButton: true,
      progressBar: true,
      newestOnTop: true,
      preventDuplicates: true,
      positionClass: "toast-top-right",
      timeOut: 5000,
      extendedTimeOut: 2000
    };

    // Helpers
    window.toastSuccess = (msg) => toastr.success(msg || 'Success');
    window.toastError   = (msg) => toastr.error(msg || 'Something went wrong');
    window.toastInfo    = (msg) => toastr.info(msg || 'Info');
    window.toastWarn    = (msg) => toastr.warning(msg || 'Warning');

    window.showValidationErrors = (xhr) => {
      if (xhr?.responseJSON?.errors) {
        const lines = [];
        Object.values(xhr.responseJSON.errors).forEach(arr => arr.forEach(msg => lines.push(msg)));
        toastr.error(lines.join('\n'));
      } else if (xhr?.responseJSON?.message) {
        toastr.error(xhr.responseJSON.message);
      } else {
        toastr.error('Validation error');
      }
    };

    window.notifyFromResponse = (res) => {
      const ok = (res?.status === 'success' || res?.status === 1 || res?.status === '1' || res?.status === true);
      if (ok) return toastSuccess(res?.msg || 'Operation successful');
      return toastError(res?.msg || 'Operation failed');
    };

    // ---------- Flash messages from Laravel session ----------
    (function () {
      const flashes = <?php echo json_encode($flashes, 15, 512) ?>;

      const mapType = (key) => {
        // Map various keys to a toastr method
        switch (key) {
          case 'success':
          case 'status':   // Laravel often uses 'status' for success
            return 'success';
          case 'error':
          case 'danger':
            return 'error';
          case 'warning':
            return 'warning';
          case 'info':
          case 'message':
          case 'primary':
          default:
            return 'info';
        }
      };

      Object.entries(flashes).forEach(([k, v]) => {
        const t = mapType(k);
        toastr[t](v);
      });
    })();

    // ---------- Validation bag ----------
    <?php if($errors->any()): ?>
      toastr.error(<?php echo json_encode(implode("\n", $errors->all()), 512) ?>);
    <?php endif; ?>
  </script>
<?php endif; ?>
<?php /**PATH /home/victor/Documents/GGT/passako-cba/resources/views/layout/toastr.blade.php ENDPATH**/ ?>